/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;

public abstract class AbstractIERBlockEntity
extends AbstractECContainerBlockEntity {
    protected AbstractIERBlockEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public abstract IElementStorage getElementStorage();

    public abstract IRuneHandler getRuneHandler();

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        IElementStorage elementStorage = this.getElementStorage();
        if (compound.func_74764_b("element_storage") && elementStorage instanceof INBTSerializable) {
            ((INBTSerializable)elementStorage).deserializeNBT((INBT)compound.func_74775_l("element_storage"));
        }
        if (compound.func_74764_b("rune_handler")) {
            IRuneHandler.readNBT(this.getRuneHandler(), compound.func_150295_c("rune_handler", 8));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        IElementStorage elementStorage = this.getElementStorage();
        if (elementStorage instanceof INBTSerializable) {
            compound.func_218657_a("element_storage", ((INBTSerializable)elementStorage).serializeNBT());
        }
        compound.func_218657_a("rune_handler", (INBT)IRuneHandler.writeNBT(this.getRuneHandler()));
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f) {
            if (cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
                IElementStorage elementStorage = this.getElementStorage();
                return LazyOptional.of((NonNullSupplier)(elementStorage != null ? () -> elementStorage : null)).cast();
            }
            if (cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
                IRuneHandler runeHandler = this.getRuneHandler();
                return LazyOptional.of((NonNullSupplier)(runeHandler != null ? () -> runeHandler : null)).cast();
            }
        }
        return super.getCapability(cap, side);
    }
}

