/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.block.container.IElementContainer;
import sirttas.elementalcraft.block.entity.AbstractECTickableBlockEntity;

public abstract class AbstractElementContainerBlockEntity
extends AbstractECTickableBlockEntity
implements IElementContainer {
    protected final SingleElementStorage elementStorage;

    protected AbstractElementContainerBlockEntity(TileEntityType<?> tileEntityTypeIn, Function<Runnable, SingleElementStorage> elementStorage) {
        super(tileEntityTypeIn);
        this.elementStorage = elementStorage.apply(this::func_70296_d);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("element_storage")) {
            this.elementStorage.deserializeNBT(compound.func_74775_l("element_storage"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("element_storage", (INBT)this.elementStorage.serializeNBT());
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }
}

