/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.rune.handler;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;

public class RuneHandler
implements IRuneHandler {
    private final int max;
    private final List<Rune> runes;
    private final Map<Rune.BonusType, Float> bonuses;

    public RuneHandler(int max) {
        this.max = max;
        this.runes = new ArrayList<Rune>(max);
        this.bonuses = new EnumMap<Rune.BonusType, Float>(Rune.BonusType.class);
    }

    @Override
    public void addRune(Rune rune) {
        if (this.runes.size() < this.max) {
            this.runes.add(rune);
            rune.getBonuses().forEach((bonus, value) -> this.bonuses.put((Rune.BonusType)((Object)bonus), Float.valueOf(this.getBonus((Rune.BonusType)((Object)bonus)) + value.floatValue())));
        }
    }

    @Override
    public void removeRune(Rune rune) {
        if (this.runes.contains(rune)) {
            this.runes.remove(rune);
            rune.getBonuses().forEach((bonus, value) -> this.bonuses.put((Rune.BonusType)((Object)bonus), Float.valueOf(this.getBonus((Rune.BonusType)((Object)bonus)) - value.floatValue())));
        }
    }

    @Override
    public int getMaxRunes() {
        return this.max;
    }

    @Override
    public List<Rune> getRunes() {
        return (List)this.runes.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Override
    public float getBonus(Rune.BonusType type) {
        return this.bonuses.getOrDefault((Object)type, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getRuneCount() {
        return this.runes.size();
    }

    @Override
    public int getRuneCount(Rune rune) {
        return this.runes == null ? 0 : (int)this.runes.stream().filter(rune::equals).count();
    }
}

