/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.world;

import com.mojang.serialization.Codec;
import elucent.eidolon.Config;
import elucent.eidolon.world.CatacombPieces;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class CatacombStructure
extends Structure<NoFeatureConfig> {
    public CatacombStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, NoFeatureConfig config) {
        int i = chunkX >> 4;
        int j = chunkZ >> 4;
        rand.setSeed((long)(i ^ j << 4) ^ seed);
        double prob = (float)rand.nextInt(10000) / 10000.0f;
        return prob < 1.0 / (Double)Config.CATACOMB_RARITY.get();
    }

    public String func_143025_a() {
        return new ResourceLocation("eidolon", "catacomb").toString();
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        static ICatacombFactory[][] POOLS = new ICatacombFactory[][]{{CatacombPieces.MediumRoom::new, CatacombPieces.MediumRoom::new, CatacombPieces.Turnaround::new, CatacombPieces.Turnaround::new, CatacombPieces.Graveyard::new, CatacombPieces.Graveyard::new, CatacombPieces.Coffin::new, CatacombPieces.Lab::new}, {CatacombPieces.SmallRoom::new, CatacombPieces.SmallRoom::new, CatacombPieces.SmallRoom::new, CatacombPieces.SmallRoom::new, CatacombPieces.SmallRoom::new, CatacombPieces.SmallRoom::new, CatacombPieces.Skull::new, CatacombPieces.Skull::new, CatacombPieces.Skull::new, CatacombPieces.Shrine::new, CatacombPieces.Spawner::new, CatacombPieces.Trap::new}, {CatacombPieces.CorridorCenter::new}, new ICatacombFactory[0]};

        public Start(Structure<NoFeatureConfig> config, int chunkX, int chunkZ, MutableBoundingBox bounds, int refs, long seed) {
            super(config, chunkX, chunkZ, bounds, refs, seed);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int i = chunkX * 16;
            int j = chunkZ * 16;
            int k = Math.min(32, generator.func_222532_b(i, j, Heightmap.Type.OCEAN_FLOOR_WG));
            if (k < 17) {
                k = 17;
            }
            BlockPos blockpos = new BlockPos(i + this.field_214631_d.nextInt(16), this.field_214631_d.nextInt(k - 16) + 8, j + this.field_214631_d.nextInt(16));
            this.generate(templateManager, blockpos, (Random)this.field_214631_d, this.field_75075_a);
            this.func_202500_a();
        }

        RoomType at(Map<BlockPos, RoomType> rooms, int x, int z) {
            return rooms.getOrDefault(new BlockPos(x, 0, z), RoomType.EMPTY);
        }

        boolean canPlace(Map<BlockPos, RoomType> rooms, int x, int z, int w, int h) {
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    if (this.at(rooms, x + i, z + j) == RoomType.EMPTY) continue;
                    return false;
                }
            }
            return true;
        }

        ICatacombFactory roomFor(RoomType type, Random random) {
            ICatacombFactory[] pool = POOLS[type.ordinal()];
            return pool[random.nextInt(pool.length)];
        }

        BlockPos adjDims(ResourceLocation rl, TemplateManager tm) {
            Template t = tm.func_200219_b(rl);
            BlockPos dims = t.func_186259_a();
            return new BlockPos((dims.func_177958_n() - 3) / 4, 0, (dims.func_177952_p() - 3) / 4);
        }

        void tryVisit(Queue<BlockPos> q, Map<BlockPos, RoomType> m, BlockPos p, RoomType type) {
            if (!m.containsKey(p)) {
                m.put(p, RoomType.CORRIDOR);
                q.add(p);
            }
        }

        BlockPos tryPlace(Map<BlockPos, RoomType> rooms, BlockPos desired, int w, int h) {
            for (int xx = 0; xx < w; ++xx) {
                for (int yy = 0; yy < h; ++yy) {
                    boolean can = true;
                    for (int i = 0; i < w; ++i) {
                        for (int j = 0; j < h; ++j) {
                            if (rooms.getOrDefault(desired.func_177982_a(i, 0, j), RoomType.CORRIDOR) == RoomType.CORRIDOR) continue;
                            can = false;
                        }
                    }
                    if (!can) continue;
                    return desired.func_177982_a(-xx, 0, -yy);
                }
            }
            return null;
        }

        void setRoom(Map<BlockPos, RoomType> rooms, Set<Edge> edges, RoomType type, BlockPos pos, int w, int h) {
            rooms.put(pos, type);
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    if (i != 0 || j != 0) {
                        rooms.put(pos.func_177982_a(i, 0, j), RoomType.EMPTY);
                    }
                    if (i > 0) {
                        edges.remove(new Edge(pos.func_177982_a(i, 0, j), pos.func_177982_a(i - 1, 0, j), 0.0f));
                        edges.remove(new Edge(pos.func_177982_a(i - 1, 0, j), pos.func_177982_a(i, 0, j), 0.0f));
                    }
                    if (j <= 0) continue;
                    edges.remove(new Edge(pos.func_177982_a(i, 0, j), pos.func_177982_a(i, 0, j - 1), 0.0f));
                    edges.remove(new Edge(pos.func_177982_a(i, 0, j - 1), pos.func_177982_a(i, 0, j), 0.0f));
                }
            }
        }

        void generate(TemplateManager tm, BlockPos pos, Random random, List<StructurePiece> components) {
            BlockPos place;
            int i;
            int size = (random.nextInt(3) + 2) * 16 + 3;
            HashMap<BlockPos, RoomType> rooms = new HashMap<BlockPos, RoomType>();
            ArrayDeque<BlockPos> frontier = new ArrayDeque<BlockPos>();
            boolean breadth = false;
            rooms.put(new BlockPos(0, 0, 0), RoomType.CORRIDOR);
            frontier.add(new BlockPos(0, 0, 0));
            while (!(frontier.isEmpty() && rooms.size() >= size || frontier.isEmpty() && rooms.size() < size)) {
                BlockPos next = (BlockPos)frontier.removeLast();
                if (random.nextInt(6) == 0) {
                    breadth = !breadth;
                }
                RoomType type = (RoomType)((Object)rooms.get(next));
                if (rooms.size() >= size) continue;
                if (random.nextBoolean()) {
                    this.tryVisit(frontier, rooms, next.func_177978_c(), type);
                }
                if (random.nextBoolean()) {
                    this.tryVisit(frontier, rooms, next.func_177968_d(), type);
                }
                if (random.nextBoolean()) {
                    this.tryVisit(frontier, rooms, next.func_177976_e(), type);
                }
                if (!random.nextBoolean()) continue;
                this.tryVisit(frontier, rooms, next.func_177974_f(), type);
            }
            HashSet<Edge> edges = new HashSet<Edge>();
            HashSet<Edge> maze = new HashSet<Edge>();
            ArrayList vertices = new ArrayList(rooms.keySet());
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            HashSet remaining = new HashSet(rooms.keySet());
            BlockPos start = (BlockPos)vertices.get(random.nextInt(vertices.size()));
            visited.add(start);
            remaining.remove(start);
            for (Map.Entry e : rooms.entrySet()) {
                if (rooms.containsKey(((BlockPos)e.getKey()).func_177978_c())) {
                    edges.add(new Edge((BlockPos)e.getKey(), ((BlockPos)e.getKey()).func_177978_c(), random.nextFloat()));
                    edges.add(new Edge(((BlockPos)e.getKey()).func_177978_c(), (BlockPos)e.getKey(), random.nextFloat()));
                }
                if (rooms.containsKey(((BlockPos)e.getKey()).func_177968_d())) {
                    edges.add(new Edge((BlockPos)e.getKey(), ((BlockPos)e.getKey()).func_177968_d(), random.nextFloat()));
                    edges.add(new Edge(((BlockPos)e.getKey()).func_177968_d(), (BlockPos)e.getKey(), random.nextFloat()));
                }
                if (rooms.containsKey(((BlockPos)e.getKey()).func_177974_f())) {
                    edges.add(new Edge((BlockPos)e.getKey(), ((BlockPos)e.getKey()).func_177974_f(), random.nextFloat()));
                    edges.add(new Edge(((BlockPos)e.getKey()).func_177974_f(), (BlockPos)e.getKey(), random.nextFloat()));
                }
                if (!rooms.containsKey(((BlockPos)e.getKey()).func_177976_e())) continue;
                edges.add(new Edge((BlockPos)e.getKey(), ((BlockPos)e.getKey()).func_177976_e(), random.nextFloat()));
                edges.add(new Edge(((BlockPos)e.getKey()).func_177976_e(), (BlockPos)e.getKey(), random.nextFloat()));
            }
            while (visited.size() < vertices.size()) {
                Edge min = null;
                for (Edge e : edges) {
                    if (!visited.contains(e.start) || !remaining.contains(e.end)) continue;
                    min = e;
                }
                if (min == null) break;
                maze.add(min);
                maze.add(new Edge(min.end, min.start, 0.0f));
                visited.add(min.end);
                remaining.remove(min.end);
            }
            for (i = 0; i < size / 6; ++i) {
                place = this.tryPlace(rooms, (BlockPos)vertices.get(random.nextInt(vertices.size())), 2, 2);
                if (place == null) continue;
                this.setRoom(rooms, maze, RoomType.MEDIUM_ROOM, place, 2, 2);
            }
            for (i = 0; i < size / 3; ++i) {
                place = this.tryPlace(rooms, (BlockPos)vertices.get(random.nextInt(vertices.size())), 1, 1);
                if (place == null) continue;
                this.setRoom(rooms, maze, RoomType.SMALL_ROOM, place, 1, 1);
            }
            for (Map.Entry e : rooms.entrySet()) {
                ICatacombFactory factory = e.getValue() == RoomType.EMPTY ? null : this.roomFor((RoomType)((Object)e.getValue()), random);
                BlockPos loc = pos.func_177982_a(((BlockPos)e.getKey()).func_177958_n() * 4, 0, ((BlockPos)e.getKey()).func_177952_p() * 4);
                switch ((RoomType)((Object)e.getValue())) {
                    case SMALL_ROOM: {
                        components.add(factory.create(tm, loc, random));
                        break;
                    }
                    case MEDIUM_ROOM: {
                        components.add(factory.create(tm, loc, random));
                        break;
                    }
                    case CORRIDOR: {
                        components.add(factory.create(tm, loc, random));
                        break;
                    }
                }
            }
            for (Map.Entry e : rooms.entrySet()) {
                Edge north = new Edge((BlockPos)e.getKey(), ((BlockPos)e.getKey()).func_177978_c(), 0.0f);
                Edge south = new Edge((BlockPos)e.getKey(), ((BlockPos)e.getKey()).func_177968_d(), 0.0f);
                Edge west = new Edge((BlockPos)e.getKey(), ((BlockPos)e.getKey()).func_177976_e(), 0.0f);
                Edge east = new Edge((BlockPos)e.getKey(), ((BlockPos)e.getKey()).func_177974_f(), 0.0f);
                BlockPos loc = pos.func_177982_a(((BlockPos)e.getKey()).func_177958_n() * 4, 0, ((BlockPos)e.getKey()).func_177952_p() * 4);
                if (maze.contains(north)) {
                    components.add((StructurePiece)new CatacombPieces.CorridorDoor(tm, loc, Rotation.NONE, random));
                }
                if (maze.contains(west)) {
                    components.add((StructurePiece)new CatacombPieces.CorridorDoor(tm, loc, Rotation.COUNTERCLOCKWISE_90, random));
                }
                if (maze.contains(south)) {
                    components.add((StructurePiece)new CatacombPieces.CorridorDoor(tm, loc, Rotation.CLOCKWISE_180, random));
                }
                if (!maze.contains(east)) continue;
                components.add((StructurePiece)new CatacombPieces.CorridorDoor(tm, loc, Rotation.CLOCKWISE_90, random));
            }
            this.func_202500_a();
        }

        static class Edge {
            public BlockPos start;
            public BlockPos end;
            public float weight;

            public Edge(BlockPos a, BlockPos b, float weight) {
                this.weight = weight;
                this.start = a;
                this.end = b;
            }

            public boolean equals(Object object) {
                return object instanceof Edge && ((Edge)object).start.equals((Object)this.start) && ((Edge)object).end.equals((Object)this.end);
            }

            public int hashCode() {
                return 480026207 * this.start.hashCode() ^ 1914791117 * this.end.hashCode();
            }
        }

        static interface ICatacombFactory {
            public StructurePiece create(TemplateManager var1, BlockPos var2, Random var3);
        }

        static enum RoomType {
            MEDIUM_ROOM,
            SMALL_ROOM,
            CORRIDOR,
            EMPTY;

        }
    }
}

