/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.tile;

import elucent.eidolon.Registry;
import elucent.eidolon.block.WoodenStandBlock;
import elucent.eidolon.gui.WoodenBrewingStandContainer;
import elucent.eidolon.tile.CrucibleTileEntity;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class WoodenStandTileEntity
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUT_SLOTS = new int[]{0, 1, 2};
    private NonNullList<ItemStack> brewingItemStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private int brewTime;
    private int heat;
    private boolean[] filledSlots;
    private Item ingredientID;
    public final IIntArray field_213954_a = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return WoodenStandTileEntity.this.brewTime;
                }
                case 1: {
                    return WoodenStandTileEntity.this.heat;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    WoodenStandTileEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    WoodenStandTileEntity.this.heat = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public WoodenStandTileEntity() {
        super(Registry.WOODEN_STAND_TILE_ENTITY);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.eidolon.wooden_brewing_stand");
    }

    public int func_70302_i_() {
        return this.brewingItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.brewingItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        boolean[] aboolean;
        TileEntity below;
        boolean flag = this.canBrew();
        boolean flag1 = this.brewTime > 0;
        ItemStack itemstack1 = (ItemStack)this.brewingItemStacks.get(3);
        if (this.field_145850_b.func_82737_E() % 20L == 0L && (below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof CrucibleTileEntity) {
            int prevHeat = this.heat;
            int n = this.heat = ((CrucibleTileEntity)below).boiling ? 1 : 0;
            if (prevHeat != this.heat) {
                this.func_70296_d();
            }
        }
        if (flag1) {
            boolean flag2;
            --this.brewTime;
            boolean bl = flag2 = this.brewTime == 0;
            if (flag2 && flag) {
                this.brewPotions();
                this.func_70296_d();
            } else if (!flag || this.heat == 0) {
                this.brewTime = 0;
                this.func_70296_d();
            } else if (this.ingredientID != itemstack1.func_77973_b()) {
                this.brewTime = 0;
                this.func_70296_d();
            }
        } else if (flag && this.heat > 0) {
            this.brewTime = 800;
            this.ingredientID = itemstack1.func_77973_b();
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K && !Arrays.equals(aboolean = this.createFilledSlotsArray(), this.filledSlots)) {
            this.filledSlots = aboolean;
            BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (!(blockstate.func_177230_c() instanceof WoodenStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.field_176451_a.length; ++i) {
                blockstate = (BlockState)blockstate.func_206870_a((Property)BrewingStandBlock.field_176451_a[i], (Comparable)Boolean.valueOf(aboolean[i]));
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 2);
        }
    }

    public boolean[] createFilledSlotsArray() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.brewingItemStacks.get(i)).func_190926_b()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean canBrew() {
        ItemStack itemstack = (ItemStack)this.brewingItemStacks.get(3);
        if (!itemstack.func_190926_b()) {
            return BrewingRecipeRegistry.canBrew(this.brewingItemStacks, (ItemStack)itemstack, (int[])OUTPUT_SLOTS);
        }
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (!PotionBrewing.func_185205_a((ItemStack)itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = (ItemStack)this.brewingItemStacks.get(i);
            if (itemstack1.func_190926_b() || !PotionBrewing.func_185208_a((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    private void brewPotions() {
        if (ForgeEventFactory.onPotionAttemptBrew(this.brewingItemStacks)) {
            return;
        }
        ItemStack itemstack = (ItemStack)this.brewingItemStacks.get(3);
        BrewingRecipeRegistry.brewPotions(this.brewingItemStacks, (ItemStack)itemstack, (int[])OUTPUT_SLOTS);
        ForgeEventFactory.onPotionBrewed(this.brewingItemStacks);
        BlockPos blockpos = this.func_174877_v();
        if (itemstack.hasContainerItem()) {
            ItemStack itemstack1 = itemstack.getContainerItem();
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                itemstack = itemstack1;
            } else if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (ItemStack)itemstack1);
            }
        } else {
            itemstack.func_190918_g(1);
        }
        this.brewingItemStacks.set(3, (Object)itemstack);
        this.field_145850_b.func_217379_c(1035, blockpos, 0);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.brewingItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.brewingItemStacks);
        this.brewTime = nbt.func_74765_d("BrewTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("BrewTime", (short)this.brewTime);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.brewingItemStacks);
        return compound;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.brewingItemStacks.size() ? (ItemStack)this.brewingItemStacks.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.brewingItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.brewingItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.brewingItemStacks.size()) {
            this.brewingItemStacks.set(index, (Object)stack);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 3) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack) && !Tags.Items.DUSTS_REDSTONE.func_230235_a_((Object)stack.func_77973_b()) && !Tags.Items.DUSTS_GLOWSTONE.func_230235_a_((Object)stack.func_77973_b());
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)stack) && this.func_70301_a(index).func_190926_b();
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : OUTPUT_SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (index == 3) {
            return stack.func_77973_b() == Items.field_151069_bo;
        }
        return true;
    }

    public void func_174888_l() {
        this.brewingItemStacks.clear();
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new WoodenBrewingStandContainer(id, player, (IInventory)this, this.field_213954_a);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

