/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import elucent.eidolon.tile.CrucibleTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.BiomeColors;

public class CrucibleTileRenderer
extends TileEntityRenderer<CrucibleTileEntity> {
    private final ModelRenderer stirrer = new ModelRenderer(16, 16, 0, 0);
    public static final ResourceLocation STIRRER_TEXTURE = new ResourceLocation("eidolon", "textures/block/crucible_stirrer.png");

    public CrucibleTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.stirrer.func_78793_a(0.0f, 0.0f, 0.0f);
        this.stirrer.func_78784_a(0, 8).func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f, false);
        this.stirrer.func_78784_a(0, 0).func_228303_a_(-1.0f, 3.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
    }

    public void render(CrucibleTileEntity tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float coeff;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(STIRRER_TEXTURE);
        float f = coeff = tile.stirTicks == 0 ? 0.0f : ((float)tile.stirTicks - partialTicks) / 20.0f;
        if (!tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177984_a()).func_224755_d((IBlockReader)tile.func_145831_w(), tile.func_174877_v().func_177984_a(), Direction.DOWN)) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.625, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f + coeff * 360.0f));
            matrixStackIn.func_227861_a_(0.0, -0.125 * Math.sin((double)coeff * Math.PI), 0.125);
            this.stirrer.field_78795_f = 0.3926991f * (1.0f - (float)Math.sin((double)coeff * Math.PI));
            this.stirrer.func_228308_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)STIRRER_TEXTURE)), combinedLightIn, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
        }
        if (tile.hasWater) {
            TextureAtlasSprite water = (TextureAtlasSprite)mc.func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/water_still"));
            IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228647_g_());
            Matrix4f mat = matrixStackIn.func_227866_c_().func_227870_a_();
            int color = BiomeColors.func_228363_c_((IBlockDisplayReader)tile.func_145831_w(), (BlockPos)tile.func_174877_v());
            int r = ColorHelper.PackedColor.func_233007_b_((int)color);
            int g = ColorHelper.PackedColor.func_233008_c_((int)color);
            int b = ColorHelper.PackedColor.func_233009_d_((int)color);
            int a = ColorHelper.PackedColor.func_233004_a_((int)color);
            if (tile.steps.size() > 0) {
                r = (int)(tile.getRed() * 255.0f);
                g = (int)(tile.getGreen() * 255.0f);
                b = (int)(tile.getBlue() * 255.0f);
            }
            builder.func_227888_a_(mat, 0.125f, 0.75f, 0.125f).func_225586_a_(r, g, b, 192).func_225583_a_(water.func_94214_a(2.0), water.func_94207_b(2.0)).func_227886_a_(combinedLightIn).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(mat, 0.125f, 0.75f, 0.875f).func_225586_a_(r, g, b, 192).func_225583_a_(water.func_94214_a(14.0), water.func_94207_b(2.0)).func_227886_a_(combinedLightIn).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(mat, 0.875f, 0.75f, 0.875f).func_225586_a_(r, g, b, 192).func_225583_a_(water.func_94214_a(14.0), water.func_94207_b(14.0)).func_227886_a_(combinedLightIn).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(mat, 0.875f, 0.75f, 0.125f).func_225586_a_(r, g, b, 192).func_225583_a_(water.func_94214_a(2.0), water.func_94207_b(14.0)).func_227886_a_(combinedLightIn).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        }
    }
}

