/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.spell;

import elucent.eidolon.Registry;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ReputationProvider;
import elucent.eidolon.deity.Deities;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.spell.Signs;
import elucent.eidolon.spell.StaticSpell;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class DarkTouchSpell
extends StaticSpell {
    public static final String NECROTIC_KEY = new ResourceLocation("eidolon", "necrotic").toString();

    public DarkTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, signs);
    }

    @Override
    public boolean canCast(World world, BlockPos pos, PlayerEntity player) {
        if (!world.getCapability(ReputationProvider.CAPABILITY).isPresent()) {
            return false;
        }
        if (((IReputation)world.getCapability(ReputationProvider.CAPABILITY).resolve().get()).getReputation(player, Deities.DARK_DEITY.getId()) < 4.0) {
            return false;
        }
        BlockRayTraceResult ray = world.func_217299_a(new RayTraceContext(player.func_174824_e(0.0f), player.func_174824_e(0.0f).func_178787_e(player.func_70040_Z().func_186678_a(4.0)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        Vector3d v = ray.func_216346_c() == RayTraceResult.Type.BLOCK ? ray.func_216347_e() : player.func_174824_e(0.0f).func_178787_e(player.func_70040_Z().func_186678_a(4.0));
        List items = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(v.field_72450_a - 1.5, v.field_72448_b - 1.5, v.field_72449_c - 1.5, v.field_72450_a + 1.5, v.field_72448_b + 1.5, v.field_72449_c + 1.5));
        if (items.size() != 1) {
            return false;
        }
        ItemStack stack = ((ItemEntity)items.get(0)).func_92059_d();
        return stack.func_190916_E() == 1 && this.canTouch(stack);
    }

    boolean canTouch(ItemStack stack) {
        return stack.func_77973_b() == Registry.PEWTER_INLAY.get() || stack.func_77973_b() == Items.field_221618_aT || stack.func_77973_b() instanceof MusicDiscItem && stack.func_77973_b() != Registry.PAROUSIA_DISC.get();
    }

    ItemStack touchResult(ItemStack stack) {
        if (stack.func_77973_b() == Registry.PEWTER_INLAY.get()) {
            return new ItemStack((IItemProvider)Registry.UNHOLY_SYMBOL.get());
        }
        if (stack.func_77973_b() == Items.field_221618_aT) {
            return new ItemStack((IItemProvider)Registry.TOP_HAT.get());
        }
        if (stack.func_77973_b() instanceof MusicDiscItem && stack.func_77973_b() != Registry.PAROUSIA_DISC.get()) {
            return new ItemStack((IItemProvider)Registry.PAROUSIA_DISC.get());
        }
        return stack;
    }

    @Override
    public void cast(World world, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult ray = world.func_217299_a(new RayTraceContext(player.func_174824_e(0.0f), player.func_174824_e(0.0f).func_178787_e(player.func_70040_Z().func_186678_a(4.0)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        Vector3d v = ray.func_216346_c() == RayTraceResult.Type.BLOCK ? ray.func_216347_e() : player.func_174824_e(0.0f).func_178787_e(player.func_70040_Z().func_186678_a(4.0));
        List items = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(v.field_72450_a - 1.5, v.field_72448_b - 1.5, v.field_72449_c - 1.5, v.field_72450_a + 1.5, v.field_72448_b + 1.5, v.field_72449_c + 1.5));
        if (items.size() == 1) {
            if (!world.field_72995_K) {
                ItemStack stack = ((ItemEntity)items.get(0)).func_92059_d();
                if (this.canTouch(stack)) {
                    ((ItemEntity)items.get(0)).func_92058_a(this.touchResult(stack));
                    Vector3d p = ((ItemEntity)items.get(0)).func_213303_ch();
                    ((ItemEntity)items.get(0)).func_174869_p();
                    Networking.sendToTracking(world, ((ItemEntity)items.get(0)).func_233580_cy_(), new MagicBurstEffectPacket(p.field_72450_a, p.field_72448_b, p.field_72449_c, Signs.WICKED_SIGN.getColor(), Signs.BLOOD_SIGN.getColor()));
                }
            } else {
                world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_190021_aL, SoundCategory.NEUTRAL, 1.0f, 0.6f + world.field_73012_v.nextFloat() * 0.2f);
            }
        }
    }
}

