/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.ritual;

import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualConsumePacket;
import elucent.eidolon.ritual.IRequirement;
import elucent.eidolon.ritual.IRitualItemProvider;
import elucent.eidolon.ritual.RequirementInfo;
import elucent.eidolon.ritual.Ritual;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemRequirement
implements IRequirement {
    Object match;

    public ItemRequirement(ItemStack item) {
        this.match = item;
    }

    public ItemRequirement(Item item) {
        this.match = item;
    }

    public ItemRequirement(Block block) {
        this.match = Item.func_150898_a((Block)block);
    }

    public ItemRequirement(ITag<Item> item) {
        this.match = item;
    }

    @Override
    public RequirementInfo isMet(Ritual ritual, World world, BlockPos pos) {
        List<IRitualItemProvider> tiles = Ritual.getTilesWithinAABB(IRitualItemProvider.class, world, ritual.getSearchBounds(pos));
        if (tiles.isEmpty()) {
            return RequirementInfo.FALSE;
        }
        for (int i = 0; i < tiles.size(); ++i) {
            ItemStack stack = tiles.get(i).provide();
            if (this.match instanceof ItemStack && ItemStack.func_77989_b((ItemStack)((ItemStack)this.match), (ItemStack)stack)) {
                return new RequirementInfo(true, ((TileEntity)tiles.get(i)).func_174877_v());
            }
            if (this.match instanceof Item && stack.func_77973_b() == (Item)this.match) {
                return new RequirementInfo(true, ((TileEntity)tiles.get(i)).func_174877_v());
            }
            if (!(this.match instanceof ITag) || !((ITag)this.match).func_230235_a_((Object)stack.func_77973_b())) continue;
            return new RequirementInfo(true, ((TileEntity)tiles.get(i)).func_174877_v());
        }
        return RequirementInfo.FALSE;
    }

    @Override
    public void whenMet(Ritual ritual, World world, BlockPos pos, RequirementInfo info) {
        ((IRitualItemProvider)world.func_175625_s(info.getPos())).take();
        if (!world.field_72995_K) {
            Networking.sendToTracking(world, pos.func_177981_b(2), new RitualConsumePacket(info.getPos(), pos.func_177981_b(2), ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
        }
    }

    public Object getMatch() {
        return this.match;
    }
}

