/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon;

import com.mojang.authlib.GameProfile;
import elucent.eidolon.Config;
import elucent.eidolon.Registry;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.capability.KnowledgeProvider;
import elucent.eidolon.capability.ReputationProvider;
import elucent.eidolon.entity.ai.PriestBarterGoal;
import elucent.eidolon.entity.ai.WitchBarterGoal;
import elucent.eidolon.event.SpeedFactorEvent;
import elucent.eidolon.item.CleavingAxeItem;
import elucent.eidolon.item.CodexItem;
import elucent.eidolon.item.ReaperScytheItem;
import elucent.eidolon.item.WarlockRobesItem;
import elucent.eidolon.network.CrystallizeEffectPacket;
import elucent.eidolon.network.KnowledgeUpdatePacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.ritual.Ritual;
import elucent.eidolon.spell.Signs;
import elucent.eidolon.tile.GobletTileEntity;
import elucent.eidolon.util.EntityUtil;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class Events {
    @SubscribeEvent
    public void attachWorldCaps(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof World) {
            event.addCapability(new ResourceLocation("eidolon", "reputation"), (ICapabilityProvider)new ReputationProvider());
        }
    }

    @SubscribeEvent
    public void attachEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Entity) {
            event.addCapability(new ResourceLocation("eidolon", "knowledge"), (ICapabilityProvider)new KnowledgeProvider());
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        Capability<IKnowledge> KNOWLEDGE = KnowledgeProvider.CAPABILITY;
        KNOWLEDGE.getStorage().readNBT(KNOWLEDGE, event.getPlayer().getCapability(KNOWLEDGE, null).resolve().get(), null, KNOWLEDGE.getStorage().writeNBT(KNOWLEDGE, event.getOriginal().getCapability(KNOWLEDGE, null).resolve().get(), null));
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            Networking.sendTo(event.getPlayer(), new KnowledgeUpdatePacket(event.getPlayer(), false));
        }
    }

    @SubscribeEvent
    public void onTarget(LivingSetAttackTargetEvent event) {
        if (EntityUtil.isEnthralledBy(event.getEntityLiving(), event.getTarget())) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDropsEvent event) {
        BlockPos pos;
        World world;
        List<GobletTileEntity> goblets;
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof MonsterEntity) && (goblets = Ritual.getTilesWithinAABB(GobletTileEntity.class, world = entity.field_70170_p, new AxisAlignedBB((pos = entity.func_233580_cy_()).func_177982_a(-2, -2, -2), pos.func_177982_a(3, 3, 3)))).size() > 0) {
            GobletTileEntity goblet = goblets.stream().min(Comparator.comparingDouble(g -> g.func_174877_v().func_177951_i((Vector3i)pos))).get();
            goblet.setEntityType(entity.func_200600_R());
        }
        if ((entity instanceof WitchEntity || entity instanceof VillagerEntity) && entity.func_184614_ca().func_77973_b() instanceof CodexItem) {
            event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_184614_ca().func_77946_l()));
        }
        if (EntityUtil.isEnthralled(entity)) {
            event.getDrops().clear();
            return;
        }
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)event.getSource().func_76346_g();
            ItemStack held = source.func_184614_ca();
            if (!entity.field_70170_p.field_72995_K && held.func_77973_b() instanceof ReaperScytheItem && entity.func_70662_br()) {
                int looting = ForgeHooks.getLootingLevel((Entity)entity, (Entity)source, (DamageSource)event.getSource());
                ItemEntity drop = new ItemEntity(source.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)Registry.SOUL_SHARD.get(), source.field_70170_p.field_73012_v.nextInt(2 + looting)));
                drop.func_174869_p();
                event.getDrops().add(drop);
                Networking.sendToTracking(entity.field_70170_p, entity.func_233580_cy_(), new CrystallizeEffectPacket(entity.func_233580_cy_()));
            }
            if (!entity.field_70170_p.field_72995_K && held.func_77973_b() instanceof CleavingAxeItem) {
                int looting = ForgeHooks.getLootingLevel((Entity)entity, (Entity)source, (DamageSource)event.getSource());
                ItemStack head = ItemStack.field_190927_a;
                if (entity instanceof WitherSkeletonEntity) {
                    head = new ItemStack((IItemProvider)Items.field_196183_dw);
                } else if (entity instanceof SkeletonEntity) {
                    head = new ItemStack((IItemProvider)Items.field_196182_dv);
                } else if (entity instanceof ZombieEntity) {
                    head = new ItemStack((IItemProvider)Items.field_196186_dz);
                } else if (entity instanceof CreeperEntity) {
                    head = new ItemStack((IItemProvider)Items.field_196185_dy);
                } else if (entity instanceof EnderDragonEntity) {
                    head = new ItemStack((IItemProvider)Items.field_196151_dA);
                } else if (entity instanceof PlayerEntity) {
                    head = new ItemStack((IItemProvider)Items.field_196184_dx);
                    GameProfile gameprofile = ((PlayerEntity)entity).func_146103_bH();
                    head.func_196082_o().func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameprofile));
                }
                if (!head.func_190926_b()) {
                    boolean doDrop = false;
                    if (entity.field_70170_p.field_73012_v.nextInt(20) == 0) {
                        doDrop = true;
                    } else {
                        for (int i = 0; i < looting; ++i) {
                            if (entity.field_70170_p.field_73012_v.nextInt(40) != 0) continue;
                            doDrop = true;
                            break;
                        }
                    }
                    if (doDrop) {
                        ItemEntity drop = new ItemEntity(source.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), head);
                        drop.func_174869_p();
                        event.getDrops().add(drop);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void registerSpawns(BiomeLoadingEvent ev) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)ev.getName());
        if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && ev.getCategory() != Biome.Category.MUSHROOM) {
            ev.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)Registry.WRAITH.get(), ((Integer)Config.WRAITH_SPAWN_WEIGHT.get()).intValue(), 1, 2));
            ev.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)Registry.ZOMBIE_BRUTE.get(), ((Integer)Config.ZOMBIE_BRUTE_SPAWN_WEIGHT.get()).intValue(), 1, 2));
        }
    }

    @SubscribeEvent
    public void registerCustomAI(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof LivingEntity && !event.getWorld().field_72995_K) {
            if (event.getEntity() instanceof PlayerEntity) {
                Networking.sendTo((PlayerEntity)event.getEntity(), new KnowledgeUpdatePacket((PlayerEntity)event.getEntity(), false));
            }
            if (event.getEntity() instanceof WitchEntity) {
                ((WitchEntity)event.getEntity()).field_70714_bg.func_75776_a(1, (Goal)new WitchBarterGoal((WitchEntity)event.getEntity(), stack -> stack.func_77973_b() == Registry.CODEX.get(), stack -> CodexItem.withSign(stack, Signs.WICKED_SIGN)));
            }
            if (event.getEntity() instanceof VillagerEntity) {
                ((VillagerEntity)event.getEntity()).field_70714_bg.func_75776_a(1, (Goal)new PriestBarterGoal((VillagerEntity)event.getEntity(), stack -> stack.func_77973_b() == Registry.CODEX.get(), stack -> CodexItem.withSign(stack, Signs.SACRED_SIGN)));
            }
        }
    }

    @SubscribeEvent
    public void onApplyPotion(PotionEvent.PotionApplicableEvent event) {
        if (event.getPotionEffect().func_188419_a() == Effects.field_76421_d && event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof WarlockRobesItem) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource().func_76355_l() == DamageSource.field_82727_n.func_76355_l() || event.getSource().func_82725_o()) {
            if (event.getSource().func_76346_g() instanceof LivingEntity && ((LivingEntity)event.getSource().func_76346_g()).func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof WarlockRobesItem) {
                event.setAmount(event.getAmount() * 1.5f);
                if (event.getSource().func_76355_l() == DamageSource.field_82727_n.func_76355_l()) {
                    ((LivingEntity)event.getSource().func_76346_g()).func_70691_i(event.getAmount() / 2.0f);
                }
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof WarlockRobesItem) {
                event.setAmount(event.getAmount() / 2.0f);
            }
        }
    }

    @SubscribeEvent
    public void onGetSpeedFactor(SpeedFactorEvent event) {
        if (event.getSpeedFactor() < 1.0f && event.getEntity() instanceof LivingEntity && ((LivingEntity)event.getEntity()).func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof WarlockRobesItem) {
            float diff = 1.0f - event.getSpeedFactor();
            event.setSpeedFactor(1.0f - diff / 2.0f);
        }
    }
}

