/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.tile;

import elucent.eidolon.Registry;
import elucent.eidolon.network.ExtinguishEffectPacket;
import elucent.eidolon.network.FlameEffectPacket;
import elucent.eidolon.network.IgniteEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualCompletePacket;
import elucent.eidolon.particle.Particles;
import elucent.eidolon.ritual.Ritual;
import elucent.eidolon.ritual.RitualRegistry;
import elucent.eidolon.tile.TileEntityBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BrazierTileEntity
extends TileEntityBase
implements ITickableTileEntity {
    ItemStack stack = ItemStack.field_190927_a;
    boolean burning = false;
    int findingCounter = 0;
    int stepCounter = 0;
    Ritual ritual = null;
    int step = 0;
    boolean ritualDone = false;

    public BrazierTileEntity() {
        this(Registry.BRAZIER_TILE_ENTITY);
    }

    public BrazierTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        super.onDestroyed(state, pos);
        if (!this.stack.func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)this.stack);
        }
    }

    @Override
    public ActionResultType onActivated(BlockState state, BlockPos pos, PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            if (this.burning && player.func_225608_bj_() && player.func_184586_b(hand).func_190926_b()) {
                this.extinguish();
                return ActionResultType.SUCCESS;
            }
            if (!this.burning && player.func_184586_b(hand).func_190926_b() && !this.stack.func_190926_b()) {
                player.func_191521_c(this.stack);
                this.stack = ItemStack.field_190927_a;
                if (!this.field_145850_b.field_72995_K) {
                    this.sync();
                }
                return ActionResultType.SUCCESS;
            }
            if (!this.burning && !this.stack.func_190926_b() && player.func_184586_b(hand).func_77973_b() == Items.field_151033_d) {
                player.func_184586_b(hand).func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                this.startBurning();
                return ActionResultType.SUCCESS;
            }
            if (!player.func_184586_b(hand).func_190926_b() && this.stack.func_190926_b()) {
                this.stack = player.func_184586_b(hand).func_77946_l();
                this.stack.func_190920_e(1);
                player.func_184586_b(hand).func_190918_g(1);
                if (player.func_184586_b(hand).func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.sync();
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("stack"));
        this.burning = tag.func_74767_n("burning");
        this.ritual = tag.func_74764_b("ritual") ? RitualRegistry.find(new ResourceLocation(tag.func_74779_i("ritual"))) : null;
        this.step = tag.func_74762_e("step");
        this.ritualDone = tag.func_74767_n("ritualDone");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
        tag.func_74757_a("burning", this.burning);
        if (this.ritual != null) {
            tag.func_74778_a("ritual", this.ritual.getRegistryName().toString());
        }
        tag.func_74768_a("step", this.step);
        tag.func_74757_a("ritualDone", this.ritualDone);
        return tag;
    }

    protected void complete() {
        this.burning = false;
        this.stepCounter = 0;
        this.findingCounter = 0;
        if (!this.field_145850_b.field_72995_K) {
            if (this.ritual != null) {
                Networking.sendToTracking(this.field_145850_b, this.field_174879_c.func_177981_b(2), new RitualCompletePacket(this.field_174879_c.func_177981_b(2), this.ritual.getRed(), this.ritual.getGreen(), this.ritual.getBlue()));
            }
            this.ritual = null;
            Networking.sendToTracking(this.field_145850_b, this.field_174879_c, new ExtinguishEffectPacket(this.field_174879_c));
            this.sync();
        }
        this.ritual = null;
    }

    protected void extinguish() {
        this.burning = false;
        this.stepCounter = 0;
        this.findingCounter = 0;
        if (!this.field_145850_b.field_72995_K) {
            if (this.ritual != null) {
                Networking.sendToTracking(this.field_145850_b, this.field_174879_c.func_177981_b(2), new FlameEffectPacket(this.field_174879_c.func_177981_b(2), this.ritual.getRed(), this.ritual.getGreen(), this.ritual.getBlue()));
            }
            this.ritual = null;
            Networking.sendToTracking(this.field_145850_b, this.field_174879_c, new ExtinguishEffectPacket(this.field_174879_c));
            this.sync();
        }
        this.ritual = null;
    }

    protected void startBurning() {
        this.burning = true;
        this.findingCounter = 0;
        if (!this.field_145850_b.field_72995_K) {
            Networking.sendToTracking(this.field_145850_b, this.field_174879_c, new IgniteEffectPacket(this.field_174879_c, 1.0f, 0.5f, 0.25f));
            this.sync();
        }
    }

    protected void setRitual(Ritual ritual) {
        this.ritual = ritual;
        if (ritual == null) {
            this.extinguish();
        } else {
            this.stepCounter = 0;
            this.step = 0;
            this.ritualDone = false;
            if (!this.field_145850_b.field_72995_K) {
                Networking.sendToTracking(this.field_145850_b, this.field_174879_c.func_177981_b(2), new FlameEffectPacket(this.field_174879_c.func_177981_b(2), ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
                this.sync();
            }
        }
    }

    public void func_73660_a() {
        if (this.burning && this.findingCounter < 80 && this.ritual == null) {
            float progress = (float)(this.findingCounter - 40) / 40.0f;
            if (progress >= 0.0f) {
                for (int i = 0; i < 8; ++i) {
                    float angle = progress * (float)Math.PI / 4.0f + (float)i * (float)Math.PI / 4.0f;
                    float radius = 0.625f * MathHelper.func_76126_a((float)(4.0f * angle));
                    float x = (float)this.func_174877_v().func_177958_n() + 0.5f + MathHelper.func_76126_a((float)(angle += 0.7853982f)) * radius;
                    float y = (float)this.func_174877_v().func_177956_o() + 0.875f;
                    float z = (float)this.func_174877_v().func_177952_p() + 0.5f + MathHelper.func_76134_b((float)angle) * radius;
                    Particles.create(Registry.WISP_PARTICLE).setAlpha(0.25f * progress, 0.0f).setScale(0.125f, 0.0625f).setLifetime(20).setColor(1.0f, 0.5f, 0.25f, 1.0f, 0.25f, 0.375f).spawn(this.field_145850_b, x, y, z);
                }
            }
            ++this.findingCounter;
            if (this.findingCounter == 80) {
                Ritual r = RitualRegistry.find(this.field_145850_b, this.field_174879_c, this.stack);
                this.stack = ItemStack.field_190927_a;
                this.findingCounter = 81;
                this.setRitual(r);
            }
        }
        if (this.burning && this.ritual != null && !this.ritualDone) {
            ++this.stepCounter;
            if (this.stepCounter == 40) {
                Ritual.SetupResult result = this.ritual.setup(this.field_145850_b, this.field_174879_c, this.step);
                if (result == Ritual.SetupResult.SUCCEED) {
                    this.ritualDone = true;
                    if (!this.field_145850_b.field_72995_K) {
                        this.sync();
                    }
                    if (this.ritual.start(this.field_145850_b, this.field_174879_c) == Ritual.RitualResult.TERMINATE) {
                        this.complete();
                    }
                } else if (result == Ritual.SetupResult.FAIL && !this.field_145850_b.field_72995_K) {
                    this.extinguish();
                } else if (!this.field_145850_b.field_72995_K) {
                    this.stepCounter = 0;
                    ++this.step;
                    this.sync();
                }
            }
        }
        if (this.burning && this.ritual != null && this.ritualDone && this.ritual.tick(this.field_145850_b, this.field_174879_c) == Ritual.RitualResult.TERMINATE) {
            this.complete();
        }
        if (this.field_145850_b.field_72995_K && this.burning) {
            float x = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float y = this.func_174877_v().func_177956_o() + 1;
            float z = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float r = this.ritual == null ? 1.0f : this.ritual.getRed();
            float g = this.ritual == null ? 0.5f : this.ritual.getGreen();
            float b = this.ritual == null ? 0.25f : this.ritual.getBlue();
            Particles.create(Registry.FLAME_PARTICLE).setAlpha(0.5f, 0.0f).setScale(0.3125f, 0.125f).setLifetime(20).randomOffset(0.25, 0.125).randomVelocity(0.00625f, 0.01875f).addVelocity(0.0, 0.00625f, 0.0).setColor(r, g, b, r, g * 0.5f, b * 1.5f).spawn(this.field_145850_b, x, y, z);
            if (this.field_145850_b.field_73012_v.nextInt(5) == 0) {
                Particles.create(Registry.SMOKE_PARTICLE).setAlpha(0.125f, 0.0f).setScale(0.375f, 0.125f).setLifetime(80).randomOffset(0.25, 0.125).randomVelocity(0.025f, 0.025f).addVelocity(0.0, 0.1f, 0.0).setColor(0.5f, 0.5f, 0.5f, 0.25f, 0.25f, 0.25f).spawn(this.field_145850_b, x, (double)y + 0.125, z);
            }
            if (this.field_145850_b.field_73012_v.nextInt(40) == 0) {
                Particles.create(Registry.SPARKLE_PARTICLE).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(40).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.0).addVelocity(0.0, 0.125, 0.0).setColor(r, g * 1.5f, b * 2.0f, r, g, b).enableGravity().setSpin(0.4f).spawn(this.field_145850_b, x, y, z);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 1));
    }
}

