/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import elucent.eidolon.Registry;
import elucent.eidolon.codex.Page;
import elucent.eidolon.codex.WorktablePage;
import elucent.eidolon.gui.jei.RecipeWrappers;
import elucent.eidolon.recipe.WorktableRecipe;
import elucent.eidolon.util.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class WorktableRegistry {
    static Map<ResourceLocation, WorktableRecipe> recipes = new HashMap<ResourceLocation, WorktableRecipe>();

    public static void register(WorktableRecipe recipe) {
        ResourceLocation loc = recipe.getRegistryName();
        assert (loc != null);
        recipes.put(loc, recipe);
    }

    public static Page getDefaultPage(WorktableRecipe recipe) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Object o : recipe.core) {
            stacks.add(StackUtil.stackFromObject(o));
        }
        for (Object o : recipe.extras) {
            stacks.add(StackUtil.stackFromObject(o));
        }
        return new WorktablePage(recipe.result.func_77946_l(), stacks.toArray(new ItemStack[stacks.size()]));
    }

    public static List<RecipeWrappers.Worktable> getWrappedRecipes() {
        ArrayList<RecipeWrappers.Worktable> wrappers = new ArrayList<RecipeWrappers.Worktable>();
        for (Map.Entry<ResourceLocation, WorktableRecipe> entry : recipes.entrySet()) {
            Page page = null;
            wrappers.add(new RecipeWrappers.Worktable(entry.getValue(), page));
        }
        return wrappers;
    }

    public static WorktableRecipe find(ResourceLocation loc) {
        return recipes.get(loc);
    }

    public static WorktableRecipe find(IInventory core, IInventory outer) {
        for (WorktableRecipe recipe : recipes.values()) {
            if (!recipe.matches(core, outer)) continue;
            return recipe;
        }
        return null;
    }

    public static void init() {
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Registry.PEWTER_INGOT.get(), ItemStack.field_190927_a, Registry.PEWTER_INLAY.get(), Registry.BASIC_AMULET.get(), Registry.PEWTER_INLAY.get(), ItemStack.field_190927_a, Blocks.field_150343_Z, ItemStack.field_190927_a}, new Object[]{Registry.SOUL_SHARD.get(), ItemStack.field_190927_a, Registry.SOUL_SHARD.get(), ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.VOID_AMULET.get())).setRegistryName("eidolon", "void_amulet"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Registry.LESSER_SOUL_GEM.get(), ItemStack.field_190927_a, Registry.ENCHANTED_ASH.get(), Items.field_151030_Z, Registry.ENCHANTED_ASH.get(), ItemStack.field_190927_a, Registry.ENCHANTED_ASH.get(), ItemStack.field_190927_a}, new Object[]{Registry.PEWTER_INLAY.get(), Registry.PEWTER_INLAY.get(), Registry.PEWTER_INLAY.get(), Registry.PEWTER_INLAY.get()}, new ItemStack((IItemProvider)Registry.WARDED_MAIL.get())).setRegistryName("eidolon", "warded_mail"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{Registry.PEWTER_INGOT.get(), Registry.PEWTER_INGOT.get(), ItemStack.field_190927_a, ItemStack.field_190927_a, Items.field_151055_y, Registry.PEWTER_INGOT.get(), Items.field_151055_y, ItemStack.field_190927_a, ItemStack.field_190927_a}, new Object[]{Registry.UNHOLY_SYMBOL.get(), Registry.SOUL_SHARD.get(), Registry.TATTERED_CLOTH.get(), Registry.SOUL_SHARD.get()}, new ItemStack((IItemProvider)Registry.REAPER_SCYTHE.get())).setRegistryName("eidolon", "reaper_scythe"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{Registry.PEWTER_INGOT.get(), Registry.PEWTER_INGOT.get(), ItemStack.field_190927_a, Registry.PEWTER_INGOT.get(), Items.field_151055_y, ItemStack.field_190927_a, ItemStack.field_190927_a, Items.field_151055_y, ItemStack.field_190927_a}, new Object[]{Registry.UNHOLY_SYMBOL.get(), ItemStack.field_190927_a, Registry.PEWTER_INLAY.get(), ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.CLEAVING_AXE.get())).setRegistryName("eidolon", "cleaving_axe"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Items.field_151122_aG, ItemStack.field_190927_a, Registry.ARCANE_GOLD_INGOT.get(), Blocks.field_150343_Z, Registry.ARCANE_GOLD_INGOT.get(), Blocks.field_150343_Z, Blocks.field_150343_Z, Blocks.field_150343_Z}, new Object[]{Tags.Items.GEMS_DIAMOND, Registry.GOLD_INLAY.get(), Tags.Items.GEMS_DIAMOND, Registry.GOLD_INLAY.get()}, new ItemStack((IItemProvider)Registry.SOUL_ENCHANTER.get())).setRegistryName("eidolon", "soul_enchanter"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{Blocks.field_150343_Z, Blocks.field_235399_ni_, Blocks.field_150343_Z, ItemStack.field_190927_a, Registry.PEWTER_INGOT.get(), ItemStack.field_190927_a, ItemStack.field_190927_a, Registry.PEWTER_INLAY.get(), ItemStack.field_190927_a}, new Object[]{Items.field_151079_bi, Registry.SOUL_SHARD.get(), Registry.LESSER_SOUL_GEM.get(), Registry.SOUL_SHARD.get()}, new ItemStack((IItemProvider)Registry.REVERSAL_PICK.get())).setRegistryName("eidolon", "reversal_pick"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Registry.ARCANE_GOLD_INGOT.get(), Registry.SHADOW_GEM.get(), ItemStack.field_190927_a, Items.field_151055_y, Registry.ARCANE_GOLD_INGOT.get(), Registry.GOLD_INLAY.get(), ItemStack.field_190927_a, ItemStack.field_190927_a}, new Object[]{Registry.LESSER_SOUL_GEM.get(), Items.field_151065_br, Items.field_151065_br, Items.field_151065_br}, new ItemStack((IItemProvider)Registry.SOULFIRE_WAND.get())).setRegistryName("eidolon", "soulfire_wand"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Registry.PEWTER_INGOT.get(), Registry.WRAITH_HEART.get(), ItemStack.field_190927_a, Items.field_151055_y, Registry.PEWTER_INGOT.get(), Registry.PEWTER_INLAY.get(), ItemStack.field_190927_a, ItemStack.field_190927_a}, new Object[]{Registry.LESSER_SOUL_GEM.get(), Items.field_196106_bc, Items.field_196106_bc, Items.field_196106_bc}, new ItemStack((IItemProvider)Registry.BONECHILL_WAND.get())).setRegistryName("eidolon", "bonechill_wand"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{Blocks.field_222401_hJ, Blocks.field_222401_hJ, Blocks.field_222401_hJ, Tags.Items.STONE, Tags.Items.STONE, Tags.Items.STONE, Tags.Items.STONE, Registry.PEWTER_INLAY.get(), Tags.Items.STONE}, new Object[]{Registry.SOUL_SHARD.get(), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.STONE_ALTAR.get(), 3)).setRegistryName("eidolon", "stone_altar"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Blocks.field_196579_bG, ItemStack.field_190927_a, Tags.Items.STONE, Tags.Items.STONE, Tags.Items.STONE, ItemStack.field_190927_a, Tags.Items.STONE, ItemStack.field_190927_a}, new Object[]{Registry.UNHOLY_SYMBOL.get(), ItemStack.field_190927_a, Registry.GOLD_INLAY.get(), ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.UNHOLY_EFFIGY.get())).setRegistryName("eidolon", "unholy_effigy"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{Blocks.field_196556_aL, Blocks.field_196556_aL, Blocks.field_196556_aL, Blocks.field_196556_aL, Registry.SHADOW_GEM.get(), Blocks.field_196556_aL, Blocks.field_196556_aL, Blocks.field_196556_aL, Blocks.field_196556_aL}, new Object[]{Registry.UNHOLY_SYMBOL.get(), ItemStack.field_190927_a, Tags.Items.DYES_BLUE, ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.WICKED_WEAVE.get(), 8)).setRegistryName("eidolon", "wicked_weave"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Registry.WICKED_WEAVE.get(), ItemStack.field_190927_a, ItemStack.field_190927_a, Registry.WICKED_WEAVE.get(), ItemStack.field_190927_a, Registry.WICKED_WEAVE.get(), ItemStack.field_190927_a, Registry.WICKED_WEAVE.get()}, new Object[]{Registry.SOUL_SHARD.get(), ItemStack.field_190927_a, Registry.SOUL_SHARD.get(), ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.WARLOCK_HAT.get())).setRegistryName("eidolon", "warlock_hat"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), ItemStack.field_190927_a, Registry.WICKED_WEAVE.get()}, new Object[]{Registry.SOUL_SHARD.get(), ItemStack.field_190927_a, Registry.SOUL_SHARD.get(), ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.WARLOCK_CLOAK.get())).setRegistryName("eidolon", "warlock_cloak"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, Registry.WICKED_WEAVE.get(), ItemStack.field_190927_a, Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), ItemStack.field_190927_a, Registry.WICKED_WEAVE.get()}, new Object[]{Registry.SOUL_SHARD.get(), ItemStack.field_190927_a, Registry.SOUL_SHARD.get(), ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.WARLOCK_BOOTS.get())).setRegistryName("eidolon", "warlock_boots"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Tags.Items.ENDER_PEARLS, ItemStack.field_190927_a, Tags.Items.FEATHERS, Registry.BASIC_BELT.get(), Tags.Items.FEATHERS, ItemStack.field_190927_a, Registry.LESSER_SOUL_GEM.get(), ItemStack.field_190927_a}, new Object[]{Registry.ENDER_CALX.get(), Registry.PEWTER_INLAY.get(), Registry.ENDER_CALX.get(), Registry.PEWTER_INLAY.get()}, new ItemStack((IItemProvider)Registry.GRAVITY_BELT.get())).setRegistryName("eidolon", "gravity_belt"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Registry.GOLD_INLAY.get(), ItemStack.field_190927_a, Registry.ARCANE_GOLD_INGOT.get(), Registry.BASIC_BELT.get(), Registry.ARCANE_GOLD_INGOT.get(), ItemStack.field_190927_a, Tags.Items.GEMS_DIAMOND, ItemStack.field_190927_a}, new Object[]{Items.field_151116_aA, Registry.SOUL_SHARD.get(), Registry.ENCHANTED_ASH.get(), Registry.SOUL_SHARD.get()}, new ItemStack((IItemProvider)Registry.RESOLUTE_BELT.get())).setRegistryName("eidolon", "resolute_belt"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Registry.WICKED_WEAVE.get(), ItemStack.field_190927_a, Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), Registry.WICKED_WEAVE.get(), ItemStack.field_190927_a, Registry.LESSER_SOUL_GEM.get(), ItemStack.field_190927_a}, new Object[]{Registry.WARPED_SPROUTS.get(), Registry.ENDER_CALX.get(), Registry.SOUL_SHARD.get(), Registry.ENDER_CALX.get()}, new ItemStack((IItemProvider)Registry.PRESTIGIOUS_PALM.get())).setRegistryName("eidolon", "prestigious_palm"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{Registry.LEAD_INGOT.get(), Registry.LEAD_INGOT.get(), Registry.LEAD_INGOT.get(), Registry.LEAD_INGOT.get(), Registry.LEAD_INGOT.get(), Registry.LEAD_INGOT.get(), Items.field_151116_aA, Registry.SOUL_SHARD.get(), Items.field_151116_aA}, new Object[]{Tags.Items.STORAGE_BLOCKS_LAPIS, ItemStack.field_190927_a, Tags.Items.GEMS_QUARTZ, ItemStack.field_190927_a}, new ItemStack((IItemProvider)Registry.MIND_SHIELDING_PLATE.get())).setRegistryName("eidolon", "mind_shielding_plate"));
        WorktableRegistry.register(new WorktableRecipe(new Object[]{ItemStack.field_190927_a, Tags.Items.STORAGE_BLOCKS_DIAMOND, ItemStack.field_190927_a, ItemStack.field_190927_a, Registry.BASIC_AMULET.get(), ItemStack.field_190927_a, ItemStack.field_190927_a, Blocks.field_150359_w, ItemStack.field_190927_a}, new Object[]{Registry.ZOMBIE_HEART.get(), Registry.LESSER_SOUL_GEM.get(), Registry.WRAITH_HEART.get(), Registry.LESSER_SOUL_GEM.get()}, new ItemStack((IItemProvider)Registry.GLASS_HAND.get())).setRegistryName("eidolon", "glass_hand"));
    }
}

