/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easy_villagers.corelib.block.IItemBlock;
import de.maxhenkel.easy_villagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TraderBlockBase
extends VillagerBlockBase
implements ITileEntityProvider,
IItemBlock {
    public TraderBlockBase() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.5f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
    }

    @Override
    public abstract Item toItem();

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TraderTileentityBase)) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        TraderTileentityBase trader = (TraderTileentityBase)tileEntity;
        if (!trader.hasVillager() && heldItem.func_77973_b() instanceof VillagerItem) {
            trader.setVillager(heldItem.func_77946_l());
            ItemUtils.decrItemStack(heldItem, player);
            if (trader.hasWorkstation()) {
                EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
                if (villagerEntity != null) {
                    this.playWorkstationSound(worldIn, pos, trader);
                }
            } else {
                TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_219721_mv);
            }
            return ActionResultType.SUCCESS;
        }
        if (!trader.hasWorkstation() && heldItem.func_77973_b() instanceof BlockItem && trader.isValidBlock(((BlockItem)heldItem.func_77973_b()).func_179223_d())) {
            Block block = ((BlockItem)heldItem.func_77973_b()).func_179223_d();
            trader.setWorkstation(block);
            ItemUtils.decrItemStack(heldItem, player);
            EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
            if (villagerEntity != null) {
                this.playWorkstationSound(worldIn, pos, trader);
            }
            SoundType type = block.func_220072_p(block.func_176223_P());
            worldIn.func_184133_a(null, pos, type.func_185841_e(), SoundCategory.BLOCKS, type.func_185843_a(), type.func_185847_b());
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && trader.hasVillager()) {
            ItemStack stack = trader.removeVillager();
            if (heldItem.func_190926_b()) {
                player.func_184611_a(handIn, stack);
            } else if (!player.field_71071_by.func_70441_a(stack)) {
                Direction direction = (Direction)state.func_177229_b((Property)FACING);
                InventoryHelper.func_180173_a((World)worldIn, (double)((double)(direction.func_82601_c() + pos.func_177958_n()) + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)(direction.func_82599_e() + pos.func_177952_p()) + 0.5), (ItemStack)stack);
            }
            TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_219721_mv);
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && trader.hasWorkstation()) {
            ItemStack blockStack = new ItemStack((IItemProvider)trader.removeWorkstation());
            if (heldItem.func_190926_b()) {
                player.func_184611_a(handIn, blockStack);
            } else if (!player.field_71071_by.func_70441_a(blockStack)) {
                Direction direction = (Direction)state.func_177229_b((Property)FACING);
                InventoryHelper.func_180173_a((World)worldIn, (double)((double)(direction.func_82601_c() + pos.func_177958_n()) + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)(direction.func_82599_e() + pos.func_177952_p()) + 0.5), (ItemStack)blockStack);
            }
            if (trader.hasVillager()) {
                TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_187913_gm);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.openGUI(trader, player)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    protected abstract boolean openGUI(TraderTileentityBase var1, PlayerEntity var2);

    protected void playWorkstationSound(World world, BlockPos pos, TraderTileentityBase trader) {
        EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
        if (villagerEntity != null) {
            if (trader.getWorkstationProfession().equals(villagerEntity.func_213700_eh().func_221130_b())) {
                TraderBlockBase.playVillagerSound(world, pos, trader.getWorkstationProfession().func_226558_e_());
            } else {
                TraderBlockBase.playVillagerSound(world, pos, SoundEvents.field_187913_gm);
            }
        }
    }

    @Nullable
    public abstract TileEntity func_196283_a_(IBlockReader var1);

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }
}

