/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;

public class PlacementBehaviour {
    public static final PlacementBehaviour NON_SOLID = new PlacementBehaviour((world, pos, rotation, rand) -> false);
    public static final PlacementBehaviour SOLID = new PlacementBehaviour((world, pos, rotation, rand) -> true);
    public static final PlacementBehaviour RANDOM_IF_SOLID_NEARBY = new PlacementBehaviour((world, pos, rotation, rand) -> {
        if (PlacementBehaviour.isSolid(world, pos.func_177978_c()) || PlacementBehaviour.isSolid(world, pos.func_177974_f()) || PlacementBehaviour.isSolid(world, pos.func_177968_d()) || PlacementBehaviour.isSolid(world, pos.func_177976_e())) {
            return rand.nextFloat() < 0.6f;
        }
        return false;
    });
    public static PlacementBehaviour STRIPES = new PlacementBehaviour((world, pos, rotation, rand) -> {
        if (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180) {
            switch (pos.func_177952_p() % 3) {
                case 0: {
                    return rand.nextFloat() < 0.9f;
                }
                case -1: 
                case 1: {
                    return rand.nextFloat() < 0.5f;
                }
                case -2: 
                case 2: {
                    return rand.nextFloat() < 0.25f;
                }
            }
            return false;
        }
        switch (pos.func_177958_n() % 3) {
            case 0: {
                return rand.nextFloat() < 0.9f;
            }
            case -1: 
            case 1: {
                return rand.nextFloat() < 0.5f;
            }
            case -2: 
            case 2: {
                return rand.nextFloat() < 0.25f;
            }
        }
        return false;
    });
    public static PlacementBehaviour SMALL_GRID = new PlacementBehaviour((world, pos, rotation, rand) -> rand.nextFloat() < 0.95f - (float)Math.abs(pos.func_177958_n() % 3) * 0.2f - (float)Math.abs(pos.func_177952_p() % 3) * 0.2f);
    public static PlacementBehaviour LARGE_GRID = new PlacementBehaviour((world, pos, rotation, rand) -> rand.nextFloat() < 1.0f - (float)Math.abs(pos.func_177958_n() % 6) * 0.1f - (float)Math.abs(pos.func_177952_p() % 6) * 0.1f);
    private final PlacementFunction function;
    @Nullable
    public final BiFunction<Theme, SecondaryTheme, BlockStateProvider> airBlock;

    public PlacementBehaviour(PlacementFunction function) {
        this(function, null);
    }

    public PlacementBehaviour(PlacementFunction function, BiFunction<Theme, SecondaryTheme, BlockStateProvider> airBlock) {
        this.function = function;
        this.airBlock = airBlock;
    }

    public PlacementBehaviour withAirBlock(BiFunction<Theme, SecondaryTheme, BlockStateProvider> airBlock) {
        return new PlacementBehaviour(this.function, airBlock);
    }

    public boolean isSolid(IWorld world, BlockPos pos, Rotation pieceRotation, Random rand) {
        return this.function.isSolid(world, pos, pieceRotation, rand);
    }

    private static boolean isSolid(IWorld world, BlockPos pos) {
        if (world.func_217354_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return world.func_180495_p(pos).func_200132_m() || world.func_180495_p(pos.func_177977_b()).func_200132_m();
        }
        return false;
    }

    public static interface PlacementFunction {
        public boolean isSolid(IWorld var1, BlockPos var2, Rotation var3, Random var4);
    }
}

