/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonFeatures;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.Tile;
import xiroc.dungeoncrawl.dungeon.generator.DefaultDungeonGenerator;
import xiroc.dungeoncrawl.dungeon.generator.DungeonGenerator;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonEntrance;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonBuilder {
    public static final DungeonGenerator DEFAULT_GENERATOR = new DefaultDungeonGenerator();
    public Random rand;
    public Position2D start;
    public DungeonLayer[] layers;
    public ChunkPos chunkPos;
    public BlockPos startPos;
    public ChunkGenerator chunkGenerator;
    public Biome biome;
    private final DynamicRegistries dynamicRegistries;
    public Theme theme;
    public Theme catacombsTheme;
    public Theme lowerCatacombsTheme;
    public Theme bottomTheme;
    public SecondaryTheme secondaryTheme;
    public SecondaryTheme catacombsSecondaryTheme;
    public SecondaryTheme lowerCatacombsSecondaryTheme;
    public SecondaryTheme bottomSecondaryTheme;
    private static final int GRID_SIZE = 17;
    private static final int HALF_GRID_SIZE = 8;

    public DungeonBuilder(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, ChunkPos pos, Random rand) {
        this.dynamicRegistries = dynamicRegistries;
        this.chunkGenerator = chunkGenerator;
        this.rand = rand;
        this.chunkPos = pos;
        this.startPos = new BlockPos(pos.field_77276_a * 16 - 72 - 4, chunkGenerator.func_205470_d() - 15, pos.field_77275_b * 16 - 72 - 4);
        DungeonCrawl.LOGGER.debug("Creating a dungeon at (" + this.startPos.func_177958_n() + " | " + this.startPos.func_177956_o() + " | " + this.startPos.func_177952_p() + ").");
    }

    public DungeonBuilder(ServerWorld world, BlockPos pos, Random rand) {
        this.dynamicRegistries = world.func_241828_r();
        this.chunkGenerator = world.func_72863_F().func_201711_g();
        this.rand = rand;
        this.chunkPos = new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        this.startPos = new BlockPos(pos.func_177958_n() - 72, world.func_72863_F().field_186029_c.func_205470_d() - 15, pos.func_177952_p() - 72);
        DungeonCrawl.LOGGER.debug("Creating a dungeon at (" + this.startPos.func_177958_n() + " | " + this.startPos.func_177956_o() + " | " + this.startPos.func_177952_p() + ").");
    }

    public List<DungeonPiece> build() {
        if (this.startPos.func_177956_o() < 16) {
            return Lists.newArrayList();
        }
        this.biome = this.chunkGenerator.func_202090_b().func_225526_b_(this.chunkPos.field_77276_a << 2, this.chunkGenerator.func_230356_f_() >> 4, this.chunkPos.field_77275_b << 2);
        DungeonType type = DungeonType.randomType(this.biome.getRegistryName(), this.rand);
        this.generateLayout(type, DEFAULT_GENERATOR);
        ArrayList pieces = Lists.newArrayList();
        DungeonEntrance entrance = new DungeonEntrance();
        entrance.setWorldPosition(this.startPos.func_177958_n() + this.layers[0].start.x * 9, this.startPos.func_177956_o() + 9, this.startPos.func_177952_p() + this.layers[0].start.z * 9);
        entrance.stage = 0;
        entrance.model = type.entrances.roll(this.rand);
        ((DungeonPiece)entrance).createBoundingBox();
        this.determineThemes();
        entrance.theme = this.theme;
        entrance.secondaryTheme = this.secondaryTheme;
        pieces.add(entrance);
        this.postProcessDungeon(pieces, type, this.rand);
        return pieces;
    }

    private void generateLayout(DungeonType type, DungeonGenerator generator) {
        int layer;
        generator.initializeDungeon(type, this, this.chunkPos, this.rand);
        this.start = new Position2D(8, 8);
        int layerCount = generator.layerCount(this.rand, this.startPos.func_177956_o());
        this.layers = new DungeonLayer[layerCount];
        for (layer = 0; layer < this.layers.length; ++layer) {
            this.layers[layer] = new DungeonLayer(17);
        }
        for (layer = 0; layer < this.layers.length && (layer <= 0 || this.layers[layer - 1].end != null); ++layer) {
            generator.initializeLayer(type.getLayer((int)layer).settings, this, this.rand, layer, layer == layerCount - 1);
            generator.generateLayer(this, this.layers[layer], layer, this.rand, layer == 0 ? this.start : this.layers[layer - 1].end);
        }
        for (layer = 0; layer < this.layers.length; ++layer) {
            this.processCorridors(this.layers[layer], layer);
        }
    }

    private void processCorridors(DungeonLayer layer, int lyr) {
        int stage = Math.min(lyr, 4);
        for (int x = 0; x < layer.width; ++x) {
            for (int z = 0; z < layer.length; ++z) {
                if (layer.grid[x][z] == null || layer.grid[x][z].hasFlag(Tile.Flag.PLACEHOLDER)) continue;
                layer.grid[x][z].piece.stage = stage;
                if (layer.grid[x][z].piece.getDungeonPieceType() != 0) continue;
                DungeonFeatures.processCorridor(this, layer, x, z, this.rand, lyr, stage, this.startPos);
            }
        }
    }

    private void determineThemes() {
        ResourceLocation registryName = this.dynamicRegistries.func_243612_b(Registry.field_239720_u_).func_177774_c((Object)this.biome);
        if (registryName != null) {
            if (this.theme == null) {
                this.theme = Theme.randomTheme(registryName.toString(), this.rand);
            }
        } else if (this.theme == null) {
            this.theme = Theme.getBuiltinDefaultTheme();
        }
        if (this.secondaryTheme == null) {
            if (this.theme.secondaryTheme != null) {
                this.secondaryTheme = this.theme.secondaryTheme.roll(this.rand);
            } else {
                SecondaryTheme secondaryTheme = this.secondaryTheme = registryName != null ? Theme.randomSecondaryTheme(registryName.toString(), this.rand) : Theme.getBuiltinDefaultSecondaryTheme();
            }
        }
        if (this.catacombsTheme == null) {
            this.catacombsTheme = Theme.randomCatacombsTheme(this.rand);
        }
        if (this.catacombsSecondaryTheme == null) {
            this.catacombsSecondaryTheme = this.catacombsTheme.secondaryTheme != null ? this.catacombsTheme.secondaryTheme.roll(this.rand) : Theme.randomCatacombsSecondaryTheme(this.rand);
        }
        if (this.lowerCatacombsTheme == null) {
            this.lowerCatacombsTheme = Theme.randomLowerCatacombsTheme(this.rand);
        }
        if (this.lowerCatacombsSecondaryTheme == null) {
            this.lowerCatacombsSecondaryTheme = this.lowerCatacombsTheme.secondaryTheme != null ? this.lowerCatacombsTheme.secondaryTheme.roll(this.rand) : Theme.randomLowerCatacombsSecondaryTheme(this.rand);
        }
        if (this.bottomTheme == null) {
            this.bottomTheme = (Boolean)Config.NO_NETHER_STUFF.get() != false ? Theme.getTheme(Theme.PRIMARY_HELL_MOSSY) : Theme.randomHellTheme(this.rand);
        }
        this.bottomSecondaryTheme = this.bottomTheme.secondaryTheme != null && this.bottomSecondaryTheme == null ? this.bottomTheme.secondaryTheme.roll(this.rand) : Theme.randomHellSecondaryTheme(this.rand);
    }

    private void postProcessDungeon(List<DungeonPiece> pieces, DungeonType type, Random rand) {
        for (int i = 0; i < this.layers.length; ++i) {
            DungeonLayer layer = this.layers[i];
            ModelSelector modelSelector = type.getLayer((int)i).modelSelector;
            for (int x = 0; x < layer.width; ++x) {
                for (int z = 0; z < layer.length; ++z) {
                    Tile tile = layer.grid[x][z];
                    if (tile == null || tile.hasFlag(Tile.Flag.PLACEHOLDER)) continue;
                    switch (i) {
                        case 2: {
                            tile.piece.theme = this.catacombsTheme;
                            tile.piece.secondaryTheme = this.catacombsSecondaryTheme;
                            break;
                        }
                        case 3: {
                            tile.piece.theme = this.lowerCatacombsTheme;
                            tile.piece.secondaryTheme = this.lowerCatacombsSecondaryTheme;
                            break;
                        }
                        default: {
                            if (i >= 4) {
                                tile.piece.theme = this.bottomTheme;
                                tile.piece.secondaryTheme = this.bottomSecondaryTheme;
                                break;
                            }
                            tile.piece.theme = this.theme;
                            tile.piece.secondaryTheme = this.secondaryTheme;
                        }
                    }
                    if (!tile.hasFlag(Tile.Flag.FIXED_MODEL)) {
                        tile.piece.setupModel(this, modelSelector, pieces, rand);
                    }
                    if (!tile.hasFlag(Tile.Flag.FIXED_POSITION)) {
                        tile.piece.setWorldPosition(this.startPos.func_177958_n() + x * 9, this.startPos.func_177956_o() - i * 9, this.startPos.func_177952_p() + z * 9);
                    }
                    tile.piece.createBoundingBox();
                    if (tile.piece.getDungeonPieceType() == 10) {
                        layer.rotateNode(tile, rand);
                    }
                    if (tile.piece.hasChildPieces()) {
                        tile.piece.addChildPieces(pieces, this, type, modelSelector, i, rand);
                    }
                    tile.piece.setup(rand);
                    pieces.add(tile.piece);
                }
            }
        }
    }

    public static boolean isBlockProtected(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_185887_b((IBlockReader)world, pos) < 0.0f || BlockTags.field_226154_ad_.func_230235_a_((Object)state.func_177230_c());
    }
}

