/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;

public class Dungeon
extends Structure<NoFeatureConfig> {
    public static Set<Biome.Category> biomeCategories = ImmutableSet.builder().add((Object)Biome.Category.DESERT).add((Object)Biome.Category.EXTREME_HILLS).add((Object)Biome.Category.FOREST).add((Object)Biome.Category.ICY).add((Object)Biome.Category.JUNGLE).add((Object)Biome.Category.MESA).add((Object)Biome.Category.PLAINS).add((Object)Biome.Category.SAVANNA).add((Object)Biome.Category.SWAMP).add((Object)Biome.Category.TAIGA).build();
    public static ImmutableSet<String> whitelistedDimensions = ImmutableSet.of((Object)"minecraft:overworld");
    public static ImmutableSet<String> whitelistedBiomes = ImmutableSet.of();
    public static ImmutableSet<String> blacklistedBiomes = ImmutableSet.of();
    public static final String NAME = "dungeoncrawl:dungeon";

    public Dungeon() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    protected boolean func_230365_b_() {
        return false;
    }

    protected boolean isFeatureChunk(ChunkGenerator p_230363_1_, BiomeProvider p_230363_2_, long p_230363_3_, SharedSeedRandom p_230363_5_, int p_230363_6_, int p_230363_7_, Biome p_230363_8_, ChunkPos p_230363_9_, NoFeatureConfig p_230363_10_) {
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return NAME;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> p_i51341_1_, int chunkX, int chunkZ, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(p_i51341_1_, chunkX, chunkZ, boundsIn, referenceIn, seed);
        }

        public void generatePieces(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, TemplateManager p_230364_3_, int chunkX, int chunkZ, Biome p_230364_6_, NoFeatureConfig p_230364_7_) {
            ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
            DungeonBuilder builder = new DungeonBuilder(dynamicRegistries, chunkGenerator, chunkpos, (Random)this.field_214631_d);
            this.field_75075_a.addAll(builder.build());
            this.func_202500_a();
            DungeonCrawl.LOGGER.debug("Created the dungeon layout for [{}, {}] with a total of {} pieces.", (Object)chunkX, (Object)chunkZ, (Object)this.field_75075_a.size());
        }

        public void func_230366_a_(ISeedReader p_230366_1_, StructureManager p_230366_2_, ChunkGenerator p_230366_3_, Random p_230366_4_, MutableBoundingBox p_230366_5_, ChunkPos p_230366_6_) {
            if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                DungeonCrawl.LOGGER.debug("Starting dungeon generation in chunk [{},{}]", (Object)p_230366_6_.field_77276_a, (Object)p_230366_6_.field_77275_b);
            }
            super.func_230366_a_(p_230366_1_, p_230366_2_, p_230366_3_, p_230366_4_, p_230366_5_, p_230366_6_);
            if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                DungeonCrawl.LOGGER.debug("Finished dungeon generation in chunk [{},{}]", (Object)p_230366_6_.field_77276_a, (Object)p_230366_6_.field_77275_b);
            }
        }
    }
}

