/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IngredientStack;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.inventory.ContainerFusionCraftingCore;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FusionRecipeTransferHelper
implements IRecipeTransferHandler<ContainerFusionCraftingCore> {
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;

    public FusionRecipeTransferHelper(IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
    }

    public Class<ContainerFusionCraftingCore> getContainerClass() {
        return ContainerFusionCraftingCore.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ContainerFusionCraftingCore container, Object recipeObject, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        if (!(recipeObject instanceof IFusionRecipe)) {
            DraconicEvolution.LOGGER.error("Attempt to use JEI Fusion recipe transfer helper on a non IFusionRecipe");
            return this.handlerHelper.createInternalError();
        }
        IFusionRecipe recipe = (IFusionRecipe)recipeObject;
        TileFusionCraftingCore core = (TileFusionCraftingCore)container.tile;
        core.updateInjectors();
        int validInjectors = (int)core.getInjectors().stream().filter(e -> e.getInjectorTier().index >= recipe.getRecipeTier().index).count();
        if (validInjectors < recipe.fusionIngredients().size()) {
            return this.handlerHelper.createUserErrorWithTooltip(I18n.func_135052_a((String)"gui.draconicevolution.fusion_craft.ne_tier_injectors", (Object[])new Object[]{recipe.getRecipeTier().getDisplayName().getString()}));
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : container.field_75151_b) {
            if (slot.field_75222_d >= 36) continue;
            inventorySlots.put(slot.field_75222_d, slot);
        }
        List coreStacks = core.getInjectors().stream().map(IFusionInjector::getInjectorStack).collect(Collectors.toList());
        coreStacks.add(core.getCatalystStack());
        coreStacks.add(core.getOutputStack());
        int inputCount = 0;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++inputCount;
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Object slot : inventorySlots.values()) {
            ItemStack stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                availableItemStacks.put(((Slot)slot).field_75222_d, stack.func_77946_l());
                continue;
            }
            ++emptySlotCount;
        }
        int lastIndex = 36;
        for (ItemStack stack : coreStacks) {
            if (stack.func_190926_b()) continue;
            ++filledCraftSlotCount;
            availableItemStacks.put(lastIndex++, stack.func_77946_l());
        }
        if (filledCraftSlotCount - inputCount > emptySlotCount) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip(message);
        }
        List<Integer> missingStacks = this.checkForMissingIngredients(this.stackHelper, availableItemStacks, itemStackGroup.getGuiIngredients());
        if (missingStacks.size() > 0) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForSlots(message, missingStacks);
        }
        if (doTransfer) {
            DraconicNetwork.sendFusionRecipeMove(recipe, maxTransfer);
        }
        return null;
    }

    private List<Integer> checkForMissingIngredients(IStackHelper stackhelper, Map<Integer, ItemStack> availableItemStacks, Map<Integer, ? extends IGuiIngredient<ItemStack>> ingredientsMap) {
        ArrayList<Integer> missing = new ArrayList<Integer>();
        TreeSet<Integer> keys = new TreeSet<Integer>(ingredientsMap.keySet());
        for (Integer key : keys) {
            List requiredStacks;
            IGuiIngredient<ItemStack> ingredient = ingredientsMap.get(key);
            if (!ingredient.isInput() || (requiredStacks = ingredient.getAllIngredients()).isEmpty()) continue;
            boolean foundIngredient = false;
            for (ItemStack stack : requiredStacks) {
                boolean hasItems = false;
                do {
                    boolean removing = hasItems;
                    int required = stack.func_190916_E();
                    hasItems = false;
                    int found = 0;
                    for (ItemStack available : availableItemStacks.values()) {
                        if (!stackhelper.isEquivalent(available, stack, UidContext.Ingredient)) continue;
                        if (removing) {
                            available.func_190918_g(Math.min(required -= available.func_190916_E(), available.func_190916_E()));
                            if (required > 0) continue;
                            break;
                        }
                        if ((found += available.func_190916_E()) < stack.func_190916_E()) continue;
                        hasItems = true;
                        foundIngredient = true;
                        break;
                    }
                    availableItemStacks.entrySet().removeIf(e -> ((ItemStack)e.getValue()).func_190916_E() <= 0);
                } while (hasItems);
                if (!foundIngredient) continue;
                break;
            }
            if (foundIngredient) continue;
            missing.add(key);
        }
        return missing;
    }

    public static void doServerSideTransfer(ServerPlayerEntity player, ContainerFusionCraftingCore container, IFusionRecipe recipe, boolean maxTransfer) {
        TileFusionCraftingCore tile = (TileFusionCraftingCore)container.tile;
        LazyOptional optionalHandler = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        if (!optionalHandler.isPresent()) {
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Player has no inventory capability");
            return;
        }
        IItemHandler playerItemHandler = (IItemHandler)optionalHandler.orElseThrow(WTFException::new);
        for (int i = 0; i < tile.itemHandler.getSlots(); ++i) {
            ItemStack stack = tile.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            stack = InventoryUtils.insertItem((IItemHandler)playerItemHandler, (ItemStack)stack, (boolean)false);
            tile.itemHandler.setStackInSlot(i, stack);
            if (stack.func_190926_b()) continue;
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Failed to transfer core inventory to player.");
            return;
        }
        for (IFusionInjector injector : tile.getInjectors()) {
            ItemStack stack = injector.getInjectorStack();
            if (stack.func_190926_b()) continue;
            stack = InventoryUtils.insertItem((IItemHandler)playerItemHandler, (ItemStack)stack, (boolean)false);
            injector.setInjectorStack(stack);
            if (stack.func_190926_b()) continue;
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Failed to transfer core inventory to player.");
            return;
        }
        FusionRecipeTransferHelper.transferIngredients(playerItemHandler, tile, recipe, maxTransfer);
    }

    private static void transferIngredients(IItemHandler playerInv, IFusionInventory fusionInv, IFusionRecipe recipe, boolean maxTransfer) {
        int fullSets;
        ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < playerInv.getSlots(); ++i) {
            availableStacks.add(playerInv.getStackInSlot(i).func_77946_l());
        }
        for (fullSets = 0; (maxTransfer || fullSets == 0) && FusionRecipeTransferHelper.checkIngredient(availableStacks, recipe.getCatalyst(), true); ++fullSets) {
            boolean endCheck = false;
            for (IFusionRecipe.IFusionIngredient ingred : recipe.fusionIngredients()) {
                if (FusionRecipeTransferHelper.checkIngredient(availableStacks, ingred.get(), ingred.consume())) continue;
                endCheck = true;
                break;
            }
            if (endCheck) break;
        }
        int catCount = recipe.getCatalyst() instanceof IngredientStack ? ((IngredientStack)recipe.getCatalyst()).getCount() : 1;
        int maxStack = recipe.getCatalyst().func_193365_a().length > 0 ? recipe.getCatalyst().func_193365_a()[0].func_77976_d() : 1;
        fullSets = Math.min(fullSets, maxStack / catCount);
        List injectors = fusionInv.getInjectors().stream().sorted(Comparator.comparing(e -> ((IFusionInjector)e).getInjectorTier().index).reversed()).collect(Collectors.toList());
        List<IFusionRecipe.IFusionIngredient> ingredients = recipe.fusionIngredients();
        if (injectors.size() < ingredients.size()) {
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Unexpected error while transferring recipe");
            return;
        }
        for (int i = 0; i < fullSets; ++i) {
            ItemStack catalyst = FusionRecipeTransferHelper.getIngredient(fusionInv.getCatalystStack(), recipe.getCatalyst(), playerInv);
            fusionInv.setCatalystStack(catalyst);
            for (int fi = 0; fi < ingredients.size(); ++fi) {
                IFusionInjector injector = (IFusionInjector)injectors.get(fi);
                IFusionRecipe.IFusionIngredient ingredient = ingredients.get(fi);
                if (!ingredient.consume() && i > 0) continue;
                ItemStack stack = FusionRecipeTransferHelper.getIngredient(injector.getInjectorStack(), ingredient.get(), playerInv);
                injector.setInjectorStack(stack);
            }
        }
    }

    private static ItemStack getIngredient(ItemStack existing, Ingredient ingred, IItemHandler playerInv) {
        int count = ingred instanceof IngredientStack ? ((IngredientStack)ingred).getCount() : 1;
        for (int i = 0; i < playerInv.getSlots(); ++i) {
            ItemStack slot = playerInv.extractItem(i, count, true);
            if (!(ingred instanceof IngredientStack ? ((IngredientStack)ingred).itemTest(slot) : ingred.test(slot)) || !InventoryUtils.canStack((ItemStack)existing, (ItemStack)slot)) continue;
            int maxInsert = existing.func_190926_b() ? count : Math.min(count, existing.func_77976_d() - existing.func_190916_E());
            ItemStack extracted = playerInv.extractItem(i, maxInsert, false);
            if (existing.func_190926_b()) {
                existing = extracted;
            } else {
                existing.func_190917_f(extracted.func_190916_E());
            }
            if ((count -= extracted.func_190916_E()) > 0) continue;
            return existing;
        }
        return existing;
    }

    private static boolean checkIngredient(List<ItemStack> availableStacks, Ingredient ingred, boolean consume) {
        int count = ingred instanceof IngredientStack ? ((IngredientStack)ingred).getCount() : 1;
        for (ItemStack stack : availableStacks) {
            if (!(ingred instanceof IngredientStack ? ((IngredientStack)ingred).itemTest(stack) : ingred.test(stack))) continue;
            int stackSize = stack.func_190916_E();
            if (consume) {
                stack.func_190918_g(Math.min(count, stack.func_190916_E()));
            }
            if ((count -= stackSize) > 0) continue;
            availableStacks.removeIf(ItemStack::func_190926_b);
            return true;
        }
        availableStacks.removeIf(ItemStack::func_190926_b);
        return false;
    }
}

