/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.client.render.modelfx.BowModelEffect;
import com.brandon3055.draconicevolution.items.equipment.ModularBow;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.TippedArrowRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;

public class RenderModularBow
extends ToolRenderBase {
    public static ShaderProgram stringShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/common.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/bow_string.frag")).uniform("time", UniformType.FLOAT).uniform("tier", UniformType.INT)).whenUsed(cache -> cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 20.0f)).build();
    private RenderType bowStringType;
    @Nullable
    protected LivingEntity entity;
    @Nullable
    protected ClientWorld world;
    private BowModelEffect effectRenderer = new BowModelEffect();
    private final ItemOverrideList overrideList = new ItemOverrideList(){

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            RenderModularBow.this.entity = entity;
            RenderModularBow.this.world = world == null ? (entity == null ? null : (ClientWorld)entity.field_70170_p) : null;
            return originalModel;
        }
    };

    public RenderModularBow(TechLevel techLevel) {
        super(techLevel, "bow");
        Map model = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/item/equipment/bow.obj"), (int)4, null);
        this.baseModel = ((CCModel)model.get("bow_handle")).backfacedCopy();
        this.materialModel = ((CCModel)model.get("bow_arm")).backfacedCopy();
        this.gemModel = ((CCModel)model.get("bow_gem")).backfacedCopy();
        this.bowStringType = RenderType.func_228632_a_((String)"shaderStringType", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/item/equipment/bow_string.png"), true, false)).func_228726_a_(RenderState.field_228512_d_).func_228714_a_(RenderState.field_228491_A_).func_228727_a_(RenderState.WriteMaskState.field_228496_F_).func_228713_a_(RenderState.AlphaState.field_228517_i_).func_228728_a_(false));
        this.initBaseVBO();
        this.initMaterialVBO();
        this.initGemVBO();
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemCameraTransforms.TransformType transform, Matrix4 mat, MatrixStack mStack, IRenderTypeBuffer getter, boolean gui, int packedLight) {
        this.transform(mat, 0.46, 0.54, 0.5, gui ? 0.9 : 1.125);
        double drawAngle = this.getDrawAngle(stack, Minecraft.func_71410_x().func_193989_ak());
        if (gui) {
            getter.getBuffer((RenderType)this.guiBaseVBOType.withMatrix(mat).withLightMap(packedLight));
        } else {
            getter.getBuffer((RenderType)this.baseVBOType.withMatrix(mat).withLightMap(packedLight));
        }
        Matrix4 bottomMat = mat.copy();
        bottomMat.rotate(3.1415926535897403, Vector3.Y_POS);
        if (this.techLevel == TechLevel.CHAOTIC && DEConfig.toolShaders) {
            getter.getBuffer((RenderType)this.materialChaosVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularBow.getShaderType(this.chaosType, chaosShader)));
            getter.getBuffer((RenderType)this.materialChaosVBOType.withMatrix(bottomMat).withLightMap(packedLight).withState((RenderState)RenderModularBow.getShaderType(this.chaosType, chaosShader)));
        } else if (gui) {
            getter.getBuffer((RenderType)this.guiMaterialVBOType.withMatrix(mat).withLightMap(packedLight));
            getter.getBuffer((RenderType)this.guiMaterialVBOType.withMatrix(bottomMat).withLightMap(packedLight));
        } else {
            getter.getBuffer((RenderType)this.materialVBOType.withMatrix(mat).withLightMap(packedLight));
            getter.getBuffer((RenderType)this.materialVBOType.withMatrix(bottomMat).withLightMap(packedLight));
        }
        boolean hasPower = this.isCreative(this.entity) || stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent() && ModularBow.calculateShotEnergy(stack) <= EnergyUtils.getEnergyStored((ItemStack)stack);
        this.drawStrings(ccrs, mat, bottomMat, getter, drawAngle, packedLight, hasPower);
    }

    private void drawStrings(CCRenderState ccrs, Matrix4 topMat, Matrix4 bottomMat, IRenderTypeBuffer getter, double drawAngle, int packedLight, boolean isCharged) {
        RenderType bowStringType = this.bowStringType;
        if (DEConfig.toolShaders) {
            UniformCache uniforms = stringShader.pushCache();
            uniforms.glUniform1i("tier", this.techLevel.index);
            bowStringType = new ShaderRenderType(bowStringType, stringShader, uniforms);
        }
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(bowStringType), (Transformation)topMat);
        double crystalX = 0.12508;
        double crystalY = 0.6784399999999999;
        double A = 90.0 - drawAngle;
        double c = crystalY * (Math.sin(drawAngle * 0.017453292519943) / Math.sin(A * 0.017453292519943));
        if (isCharged) {
            float[] r = new float[]{0.0f, 0.55f, 1.0f, 0.5f};
            float[] g = new float[]{0.35f, 0.3f, 0.572f, 0.0f};
            float[] b = new float[]{0.65f, 0.9f, 0.172f, 0.0f};
            this.renderBeam((IVertexBuilder)builder, new Vector3(0.0, -crystalX, crystalY), new Vector3(0.0, -(crystalX + c), 0.0), r[this.techLevel.index], g[this.techLevel.index], b[this.techLevel.index]);
            this.renderBeam((IVertexBuilder)builder, new Vector3(0.0, -crystalX, -crystalY), new Vector3(0.0, -(crystalX + c), 0.0), r[this.techLevel.index], g[this.techLevel.index], b[this.techLevel.index]);
        }
        if (drawAngle > 0.0) {
            Matrix4 arrowMat = topMat.copy();
            arrowMat.translate(0.055, 0.325 - c, 0.0);
            arrowMat.rotate(1.5707963267948701, Vector3.Z_POS);
            this.renderArrow(arrowMat, getter, packedLight);
        }
        topMat.apply(new Rotation(drawAngle * 0.017453292519943, 1.0, 0.0, 0.0).at(new Vector3(0.0, -crystalX, -crystalY)));
        bottomMat.apply(new Rotation(drawAngle * 0.017453292519943, 1.0, 0.0, 0.0).at(new Vector3(0.0, -crystalX, -crystalY)));
        if (DEConfig.toolShaders) {
            getter.getBuffer((RenderType)this.gemVBOType.withMatrix(topMat).withLightMap(packedLight).withState((RenderState)RenderModularBow.getShaderType(this.shaderParentType, this.techLevel, gemShader)));
            getter.getBuffer((RenderType)this.gemVBOType.withMatrix(bottomMat).withLightMap(packedLight).withState((RenderState)RenderModularBow.getShaderType(this.shaderParentType, this.techLevel, gemShader)));
        } else {
            getter.getBuffer((RenderType)this.gemVBOType.withMatrix(topMat).withLightMap(packedLight));
            getter.getBuffer((RenderType)this.gemVBOType.withMatrix(bottomMat).withLightMap(packedLight));
        }
    }

    private void renderBeam(IVertexBuilder buffer, Vector3 source, Vector3 target, float r, float g, float b) {
        double scale = 0.03;
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply(scale);
        planeB.multiply(scale);
        planeC.multiply(scale);
        planeD.multiply(scale);
        float dist = 0.2f * (float)Utils.getDistanceAtoB((Vec3D)new Vec3D(source), (Vec3D)new Vec3D(target));
        float anim = DEConfig.toolShaders ? 0.0f : ((float)BCClientEventHandler.elapsedTicks + partialTicks) / -15.0f;
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferShaderQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferShaderQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferShaderQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferShaderQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
    }

    private void bufferShaderQuad(IVertexBuilder buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, float anim, float dist, float r, float g, float b) {
        if (!DEConfig.toolShaders) {
            this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
            return;
        }
        buffer.func_225582_a_(p1.x, p1.y, p1.z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_(p2.x, p2.y, p2.z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_(p4.x, p4.y, p4.z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_(p3.x, p3.y, p3.z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
    }

    private void bufferQuad(IVertexBuilder buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, float anim, float dist, float r, float g, float b) {
        buffer.func_225582_a_(p1.x, p1.y, p1.z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.5f, anim).func_181675_d();
        buffer.func_225582_a_(p2.x, p2.y, p2.z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.5f, dist + anim).func_181675_d();
        buffer.func_225582_a_(p4.x, p4.y, p4.z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(1.0f, dist + anim).func_181675_d();
        buffer.func_225582_a_(p3.x, p3.y, p3.z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(1.0f, anim).func_181675_d();
    }

    private void renderArrow(Matrix4 mat, IRenderTypeBuffer getter, int packedLight) {
        mat.scale((double)0.05625f, (double)0.05625f, (double)0.05625f);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(RenderType.func_228638_b_((ResourceLocation)TippedArrowRenderer.field_188305_a)), (Transformation)mat);
        this.bufferVertex((IVertexBuilder)builder, -7.0f, -2.0f, -2.0f, 0.0f, 0.15625f, -1, 0, 0, packedLight);
        this.bufferVertex((IVertexBuilder)builder, -7.0f, -2.0f, 2.0f, 0.15625f, 0.15625f, -1, 0, 0, packedLight);
        this.bufferVertex((IVertexBuilder)builder, -7.0f, 2.0f, 2.0f, 0.15625f, 0.3125f, -1, 0, 0, packedLight);
        this.bufferVertex((IVertexBuilder)builder, -7.0f, 2.0f, -2.0f, 0.0f, 0.3125f, -1, 0, 0, packedLight);
        this.bufferVertex((IVertexBuilder)builder, -7.0f, 2.0f, -2.0f, 0.0f, 0.15625f, 1, 0, 0, packedLight);
        this.bufferVertex((IVertexBuilder)builder, -7.0f, 2.0f, 2.0f, 0.15625f, 0.15625f, 1, 0, 0, packedLight);
        this.bufferVertex((IVertexBuilder)builder, -7.0f, -2.0f, 2.0f, 0.15625f, 0.3125f, 1, 0, 0, packedLight);
        this.bufferVertex((IVertexBuilder)builder, -7.0f, -2.0f, -2.0f, 0.0f, 0.3125f, 1, 0, 0, packedLight);
        for (int j = 0; j < 4; ++j) {
            mat.rotate(1.5707963267948701, Vector3.X_POS);
            this.bufferVertex((IVertexBuilder)builder, -8.5f, -2.0f, 0.0f, 0.0f, 0.0f, 0, 1, 0, packedLight);
            this.bufferVertex((IVertexBuilder)builder, 8.5f, -2.0f, 0.0f, 0.5f, 0.0f, 0, 1, 0, packedLight);
            this.bufferVertex((IVertexBuilder)builder, 8.5f, 2.0f, 0.0f, 0.5f, 0.15625f, 0, 1, 0, packedLight);
            this.bufferVertex((IVertexBuilder)builder, -8.5f, 2.0f, 0.0f, 0.0f, 0.15625f, 0, 1, 0, packedLight);
        }
    }

    public void bufferVertex(IVertexBuilder builder, float x, float y, float z, float u, float v, int normX, int normZ, int normY, int light) {
        builder.func_225582_a_((double)x, (double)y, (double)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_((float)normX, (float)normY, (float)normZ).func_181675_d();
    }

    @Override
    public IModelTransform getModelTransform() {
        return TransformUtils.DEFAULT_BOW;
    }

    private double getDrawAngle(ItemStack stack, float partialTicks) {
        if (this.entity != null && this.entity.func_184607_cu() == stack) {
            float maxCount = (float)this.entity.func_184612_cw() - partialTicks;
            return Math.max(0.0f, ModularBow.getPowerForTime((int)maxCount, stack) * 45.0f);
        }
        return 0.0;
    }

    private float getSpecialChargeTicks(ItemStack stack, float partialTicks) {
        if (this.entity != null && this.entity.func_184607_cu() == stack) {
            float maxCount = (float)this.entity.func_184612_cw() + partialTicks;
            return Math.max(0.0f, maxCount - (float)(ModularBow.getChargeTicks(stack) * 2));
        }
        return 0.0f;
    }

    private int getProjectileColour(ItemStack stack) {
        ItemStack ammo;
        if (this.entity != null && this.entity.func_184607_cu() == stack && !(ammo = this.entity.func_213356_f(stack)).func_190926_b() && ammo.func_77973_b() instanceof ArrowItem) {
            Potion potion = PotionUtils.func_185191_c((ItemStack)ammo);
            if (potion == Potions.field_185229_a) {
                return 0xFFFFFF;
            }
            return PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)potion, (Collection)PotionUtils.func_185190_b((ItemStack)ammo)));
        }
        return 0xFFFFFF;
    }

    private boolean isCreative(LivingEntity entity) {
        return entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d;
    }

    public static float torad(double degrees) {
        return (float)(degrees * 0.017453292519943);
    }
}

