/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.utils.ResourceHelperDE;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;

public class StaffBeamEffect
extends Particle {
    private LivingEntity shooter;
    private Vector3 origin = null;
    private Vector3 targetPos;
    private static IParticleRenderType renderType = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder builder, TextureManager textureManager) {
            ResourceHelperDE.bindTexture("textures/particle/energy_beam_draconic.png");
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
        }
    };

    public StaffBeamEffect(ClientWorld world, LivingEntity shooter, Vector3 targetPos) {
        super(world, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_());
        this.shooter = shooter;
        this.targetPos = targetPos;
        this.field_70547_e = 10;
    }

    public boolean shouldCull() {
        return false;
    }

    public IParticleRenderType func_217558_b() {
        return renderType;
    }

    public void func_189213_a() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        double rot;
        boolean firstPerson = this.shooter == renderInfo.func_216773_g() && !renderInfo.func_216770_i();
        Vector3 shooterPos = MathUtils.interpolateVec3((Vector3)new Vector3(this.shooter.field_70142_S, this.shooter.field_70137_T, this.shooter.field_70136_U), (Vector3)new Vector3(this.shooter.func_213303_ch()), (double)partialTicks);
        if (firstPerson) {
            this.origin = shooterPos.add(0.0, (double)this.shooter.func_70047_e() - 0.1125, 0.0);
            rot = (double)(this.shooter.func_195046_g(partialTicks) + 120.0f) * 0.017453292519943;
            double offset = 0.4 * Math.sin((double)(this.shooter.field_70125_A + 90.0f) * 0.017453292519943);
            this.origin.add(Math.cos(rot) * offset, Math.cos((double)(this.shooter.field_70125_A + 90.0f) * 0.017453292519943) * 0.4, Math.sin(rot) * offset);
        } else {
            this.origin = shooterPos.add(0.0, (double)this.shooter.func_70047_e() - 0.65, 0.0);
            rot = (double)(this.shooter.func_195046_g(partialTicks) + 104.0f) * 0.017453292519943;
            double offset = 0.9 * Math.sin((double)(this.shooter.field_70125_A + 90.0f) * 0.017453292519943);
            this.origin.add(Math.cos(rot) * offset, Math.cos((double)(this.shooter.field_70125_A + 90.0f) * 0.017453292519943) * 0.9, Math.sin(rot) * offset);
        }
        float progress = Math.min(1.0f, ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e);
        double scale = 0.05 * MathUtils.clampMap((double)progress, (double)0.0, (double)0.1, (double)0.0, (double)1.0) * MathUtils.clampMap((double)progress, (double)0.5, (double)1.0, (double)1.0, (double)0.0);
        Vector3 origin = this.origin.copy();
        Vector3 targetPos = this.targetPos.copy();
        Vector3d viewVec = renderInfo.func_216785_c();
        Vector3 source = origin.subtract(viewVec);
        Vector3 target = targetPos.subtract(viewVec);
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply(scale);
        planeB.multiply(scale);
        planeC.multiply(scale);
        planeD.multiply(scale);
        float dist = 0.2f * (float)Utils.getDistanceAtoB((Vec3D)new Vec3D(source), (Vec3D)new Vec3D(target));
        float anim = ((float)ClientEventHandler.elapsedTicks + partialTicks) / -15.0f;
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
    }

    private void bufferQuad(IVertexBuilder buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, float anim, float dist) {
        BCProfiler.RENDER.start("buffer_quad");
        buffer.func_225582_a_(p1.x, p1.y, p1.z).func_225583_a_(0.5f, anim).func_181675_d();
        buffer.func_225582_a_(p2.x, p2.y, p2.z).func_225583_a_(0.5f, dist + anim).func_181675_d();
        buffer.func_225582_a_(p4.x, p4.y, p4.z).func_225583_a_(1.0f, dist + anim).func_181675_d();
        buffer.func_225582_a_(p3.x, p3.y, p3.z).func_225583_a_(1.0f, anim).func_181675_d();
        BCProfiler.RENDER.stop();
    }
}

