/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingInjector;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CraftingInjector
extends BlockBCore
implements IHudBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static VoxelShape SHAPE_DOWN = VoxelShapes.func_197873_a((double)0.0625, (double)0.375, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
    private static VoxelShape SHAPE_UP = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375);
    private static VoxelShape SHAPE_NORTH = VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.375, (double)0.9375, (double)0.9375, (double)1.0);
    private static VoxelShape SHAPE_SOUTH = VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.625);
    private static VoxelShape SHAPE_WEST = VoxelShapes.func_197873_a((double)0.375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375);
    private static VoxelShape SHAPE_EAST = VoxelShapes.func_197873_a((double)0.0, (double)0.0625, (double)0.0625, (double)0.625, (double)0.9375, (double)0.9375);
    private final TechLevel techLevel;

    public CraftingInjector(AbstractBlock.Properties properties, TechLevel techLevel) {
        super(properties);
        this.techLevel = techLevel;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    public boolean isBlockFullCube() {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileFusionCraftingInjector();
    }

    public void func_176206_d(IWorld p_176206_1_, BlockPos p_176206_2_, BlockState p_176206_3_) {
        super.func_176206_d(p_176206_1_, p_176206_2_, p_176206_3_);
    }

    public void func_196243_a(BlockState p_196243_1_, World world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFusionCraftingInjector) {
            ((TileFusionCraftingInjector)tile).onDestroyed();
        }
        super.func_196243_a(p_196243_1_, world, pos, p_196243_4_, p_196243_5_);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileFusionCraftingInjector)) {
            return ActionResultType.FAIL;
        }
        TileFusionCraftingInjector craftingPedestal = (TileFusionCraftingInjector)tile;
        if (player.func_225608_bj_()) {
            craftingPedestal.singleItem.set(!craftingPedestal.singleItem.get());
            ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("fusion_inj.draconicevolution." + (craftingPedestal.singleItem.get() ? "single_item" : "multi_item")), (int)98);
            craftingPedestal.getDataManager().detectAndSendChanges();
            return ActionResultType.SUCCESS;
        }
        if (!craftingPedestal.itemHandler.getStackInSlot(0).func_190926_b()) {
            if (player.func_184614_ca().func_190926_b()) {
                player.func_184611_a(Hand.MAIN_HAND, craftingPedestal.itemHandler.getStackInSlot(0));
                craftingPedestal.setInjectorStack(ItemStack.field_190927_a);
            } else {
                world.func_217376_c((Entity)new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), craftingPedestal.itemHandler.getStackInSlot(0)));
                craftingPedestal.setInjectorStack(ItemStack.field_190927_a);
            }
        } else {
            ItemStack stack = player.func_184614_ca();
            player.func_184611_a(Hand.MAIN_HAND, InventoryUtils.insertItem((IItemHandler)craftingPedestal.itemHandler, (ItemStack)stack, (boolean)false));
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        switch (facing) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case UP: {
                return SHAPE_UP;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public void generateHudText(World world, BlockPos pos, PlayerEntity player, List<ITextComponent> displayList) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileFusionCraftingInjector) {
            boolean single = ((TileFusionCraftingInjector)te).singleItem.get();
            displayList.add((ITextComponent)new TranslationTextComponent("fusion_inj.draconicevolution." + (single ? "single_item" : "multi_item")).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GOLD}));
        }
    }
}

