/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class ModularOPStorage
implements IOPStorageModifiable,
INBTSerializable<CompoundNBT> {
    private boolean canExtract = false;
    private long energy = 0L;
    private long baseCapacity;
    public long baseTransfer;
    private ModuleHostImpl host;

    public ModularOPStorage(ModuleHostImpl host, long baseCapacity, long baseTransfer) {
        this.baseCapacity = baseCapacity;
        this.baseTransfer = baseTransfer;
        this.host = host;
    }

    public ModularOPStorage(ModuleHostImpl host, long baseCapacity, long baseTransfer, boolean canExtract) {
        this(host, baseCapacity, baseTransfer);
        this.canExtract = canExtract;
    }

    public long receiveOP(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.getMaxOPStored() - this.energy, Math.min(this.maxReceive(), maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public long extractOP(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract(), maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public long modifyEnergyStored(long amount) {
        if (amount > this.getMaxOPStored() - this.energy) {
            amount = this.getMaxOPStored() - this.energy;
        } else if (amount < -this.energy) {
            amount = -this.energy;
        }
        this.energy += amount;
        return Math.abs(amount);
    }

    public long getOPStored() {
        return this.energy;
    }

    public long getMaxOPStored() {
        return this.baseCapacity + this.host.getEnergyData().getCapacity();
    }

    public boolean canExtract() {
        return this.energy > 0L && (this.canExtract || this.host.getEnergyShare().getTransferRate() > 0L);
    }

    public boolean canReceive() {
        return this.energy < this.getMaxOPStored();
    }

    public long maxExtract() {
        return this.baseTransfer + this.host.getEnergyData().getTransfer();
    }

    public long maxReceive() {
        return this.baseTransfer + this.host.getEnergyData().getTransfer();
    }

    @Nullable
    public IOInfo getIOInfo() {
        return null;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("energy", this.energy);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.energy = nbt.func_74763_f("energy");
    }
}

