/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.data.ModuleProperties;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface Module<T extends ModuleData<T>>
extends IForgeRegistryEntry<Module<?>> {
    public ModuleType<T> getType();

    public ModuleProperties<T> getProperties();

    default public T getData() {
        return this.getProperties().getData();
    }

    default public TechLevel getModuleTechLevel() {
        return this.getProperties().getTechLevel();
    }

    public Item getItem();

    default public Collection<ModuleCategory> getCategories() {
        return this.getType().getCategories();
    }

    default public ModuleEntity createEntity() {
        return this.getType().createEntity(this);
    }

    default public InstallResult areModulesCompatible(Module<?> otherModule) {
        return this.getType().areModulesCompatible(this, otherModule);
    }

    default public int maxInstallable() {
        return this.getType().maxInstallable();
    }

    default public void addInformation(List<ITextComponent> toolTip) {
        this.getProperties().addStats(toolTip, this);
        if (this.maxInstallable() != -1) {
            toolTip.add((ITextComponent)new TranslationTextComponent("module.draconicevolution.max_installable").func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.maxInstallable())).func_240699_a_(TextFormatting.DARK_GREEN)));
        }
    }

    default public InstallResult doInstallationCheck(Stream<Module<?>> moduleStream) {
        List view = Collections.unmodifiableList(moduleStream.collect(Collectors.toList()));
        Optional<InstallResult> opt = view.stream().map(other -> this.areModulesCompatible((Module<?>)other).getBlockingResult(other.areModulesCompatible(this))).filter(e -> e.resultType == InstallResult.InstallResultType.NO || e.resultType == InstallResult.InstallResultType.ONLY_WHEN_OVERRIDEN).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        Iterable newModules = Iterables.concat(view, Collections.singleton(this));
        opt = ((Stream)Streams.stream((Iterable)newModules).parallel()).map(module -> {
            int max = module.maxInstallable();
            if (max == -1) {
                return null;
            }
            int installed = (int)Streams.stream((Iterable)newModules).filter(e -> e.getType() == module.getType() && e.getModuleTechLevel().index <= module.getModuleTechLevel().index).count();
            if (installed > max) {
                return new InstallResult(InstallResult.InstallResultType.NO, (Module<?>)module, null, (ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.error.module_install_limit"));
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        return opt.orElseGet(() -> new InstallResult(InstallResult.InstallResultType.YES, this, null, null));
    }
}

