/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.items.equipment.DEItemTier;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModularHoe
extends HoeItem
implements IModularTieredItem {
    private final TechLevel techLevel;
    private final DEItemTier itemTier;

    public ModularHoe(TechPropBuilder props) {
        super((IItemTier)new DEItemTier(props, EquipCfg::getHoeDmgMult, EquipCfg::getHoeSpeedMult), 0, 0.0f, props.build().func_234689_a_());
        this.techLevel = props.techLevel;
        this.itemTier = (DEItemTier)this.func_200891_e();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DEItemTier getItemTier() {
        return this.itemTier;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        return new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "hoe", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return IModularTieredItem.super.getDestroySpeed(stack, state);
    }

    @Override
    public float getBaseEfficiency() {
        return this.func_200891_e().func_200928_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }
}

