/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.JumpData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.client.model.ModularArmorModel;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.integration.equipment.IDEEquipment;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModularChestpiece
extends ArmorItem
implements IModularArmor,
IDEEquipment {
    private final TechLevel techLevel;
    @OnlyIn(value=Dist.CLIENT)
    private BipedModel<?> model;
    @OnlyIn(value=Dist.CLIENT)
    private BipedModel<?> model_on_armor;

    public ModularChestpiece(TechPropBuilder props) {
        super((IArmorMaterial)ArmorMaterial.DIAMOND, EquipmentSlotType.CHEST, props.build().func_234689_a_());
        this.techLevel = props.techLevel;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        if (entity instanceof LivingEntity && !EquipmentManager.findItem(e -> e.func_77973_b() instanceof ModularChestpiece, (LivingEntity)entity).func_190926_b()) {
            return false;
        }
        return MobEntity.func_184640_d((ItemStack)stack) == armorType;
    }

    @Override
    public boolean canEquip(LivingEntity livingEntity, String identifier) {
        if (!identifier.equals("body") || !EquipmentManager.findItem(e -> e.func_77973_b() instanceof ModularChestpiece, livingEntity).func_190926_b()) {
            return false;
        }
        return !(livingEntity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ModularChestpiece);
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.chestpieceWidth(this.techLevel), ModuleCfg.chestpieceHeight(this.techLevel), "chestpiece", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.CHESTPIECE);
        host.addPropertyBuilder(props -> {
            JumpData jump;
            SpeedData speed = host.getModuleData(ModuleTypes.SPEED);
            if (speed != null) {
                Supplier<Double> speedGetter = () -> {
                    double maxSpeed;
                    SpeedData data = host.getModuleData(ModuleTypes.SPEED);
                    double d = maxSpeed = data == null ? 0.0 : data.getSpeedMultiplier();
                    if (DEConfig.armorSpeedLimit != -1.0) {
                        maxSpeed = Math.min(maxSpeed, DEConfig.armorSpeedLimit);
                    }
                    return maxSpeed;
                };
                props.add(new DecimalProperty("walk_speed", 0.0).min(0.0).max(speedGetter).setFormatter(ConfigProperty.DecimalFormatter.PLUS_PERCENT_0));
                props.add(new DecimalProperty("run_speed", speedGetter.get()).min(0.0).max(speedGetter).setFormatter(ConfigProperty.DecimalFormatter.PLUS_PERCENT_0));
            }
            if ((jump = host.getModuleData(ModuleTypes.JUMP_BOOST)) != null) {
                Supplier<Double> jumpGetter = () -> {
                    JumpData data = host.getModuleData(ModuleTypes.JUMP_BOOST);
                    return data == null ? 0.0 : data.getMultiplier();
                };
                props.add(new DecimalProperty("jump_boost_run", 0.0).min(0.0).max(jumpGetter).setFormatter(ConfigProperty.DecimalFormatter.PLUS_PERCENT_0));
                props.add(new DecimalProperty("jump_boost", jumpGetter.get()).min(0.0).max(jumpGetter).setFormatter(ConfigProperty.DecimalFormatter.PLUS_PERCENT_0));
            }
        });
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseChestpieceEnergy(this.techLevel), EquipCfg.getBaseChestpieceTransfer(this.techLevel));
    }

    @Override
    public void initCapabilities(ItemStack stack, ModuleHostImpl host, MultiCapabilityProvider provider) {
        EquipmentManager.addCaps(stack, provider);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (this.model == null) {
            this.model = new ModularArmorModel(1.0f, this.techLevel, false);
        }
        return (A)((BipedModel)SneakyUtils.unsafeCast(this.model));
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getChestPieceModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, boolean onArmor) {
        if (this.model == null || this.model_on_armor == null) {
            this.model = new ModularArmorModel(1.0f, this.techLevel, false);
            this.model_on_armor = new ModularArmorModel(1.0f, this.techLevel, true);
        }
        return (A)((BipedModel)SneakyUtils.unsafeCast(onArmor ? this.model_on_armor : this.model));
    }

    public static ItemStack getChestpiece(LivingEntity entity) {
        ItemStack stack = entity.func_184582_a(EquipmentSlotType.CHEST);
        if (stack.func_77973_b() instanceof ModularChestpiece) {
            return stack;
        }
        return EquipmentManager.findItem(e -> e.func_77973_b() instanceof ModularChestpiece, entity);
    }
}

