/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GroundTarget
extends DislocatorTarget {
    private Vector3 entityPos;
    private UUID entityUUID;

    public GroundTarget(ItemEntity entity) {
        super((RegistryKey<World>)entity.field_70170_p.func_234923_W_());
        this.entityUUID = entity.func_110124_au();
        this.entityPos = Vector3.fromEntity((Entity)entity);
    }

    public GroundTarget(RegistryKey<World> world) {
        super(world);
    }

    @Override
    public TargetPos getTargetPos(MinecraftServer server, UUID linkID, UUID sourceDislocatorID) {
        ServerWorld targetWorld = this.getTargetWorld(server);
        Entity entity = targetWorld.func_217461_a(this.entityUUID);
        if (!(entity instanceof ItemEntity)) {
            AxisAlignedBB bb = new AxisAlignedBB(this.entityPos.pos().func_177982_a(-1, -1, -1), this.entityPos.pos().func_177982_a(1, 1, 1));
            bb.func_186662_g(5.0);
            List items = targetWorld.func_217357_a(ItemEntity.class, bb);
            for (ItemEntity item : items) {
                ItemStack stack = item.func_92059_d();
                UUID id = BoundDislocator.getLinkId(stack);
                if (id == null || !id.equals(linkID)) continue;
                return new TargetPos((Entity)item);
            }
        } else {
            ItemStack stack = ((ItemEntity)entity).func_92059_d();
            UUID id = BoundDislocator.getLinkId(stack);
            if (id != null && id.equals(linkID)) {
                return new TargetPos(entity);
            }
        }
        return null;
    }

    @Override
    protected void loadInternal(CompoundNBT nbt) {
        super.loadInternal(nbt);
        this.entityPos = Vector3.fromNBT((CompoundNBT)nbt);
        this.entityUUID = nbt.func_186857_a("entity_uuid");
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        this.entityPos.writeToNBT(nbt);
        nbt.func_186854_a("entity_uuid", this.entityUUID);
        return super.save(nbt);
    }

    @Override
    public DislocatorTarget.TargetType getType() {
        return DislocatorTarget.TargetType.ON_GROUND;
    }
}

