/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.logging.log4j.Logger;

public class StartPhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    public static final EntityPredicate AGRO_TARGETS = new EntityPredicate().func_221014_c().func_221013_a(300.0).func_221012_a(e -> e instanceof PlayerEntity);
    private Path currentPath;
    private Vector3d targetLocation;
    private boolean clockwise;
    private float agroLevel = 0.0f;
    private float minAgroLevel = 100.0f;
    private float maxAgroLevel = 300.0f;
    private float targetAgroLevel = 0.0f;
    private int agroModifier = 0;
    private int maxAgroModifier = 2400;
    private int failedAttacks = 0;

    public StartPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    public PhaseType<StartPhase> getType() {
        return PhaseType.START;
    }

    @Override
    public void serverTick() {
        double distanceFromTarget;
        this.agroLevel += (float)this.getPlayerCount();
        if (TimeKeeper.getServerTick() % 10 == 0) {
            this.debug("Start Phase, Target Agro: " + this.targetAgroLevel / 20.0f + ", Agro: " + this.agroLevel / 20.0f);
        }
        if (this.agroLevel >= this.targetAgroLevel / (float)Math.max(this.failedAttacks, 1) && this.startNextAttack()) {
            return;
        }
        double d = distanceFromTarget = this.targetLocation == null ? 0.0 : this.targetLocation.func_186679_c(this.guardian.func_226277_ct_(), this.guardian.func_226278_cu_(), this.guardian.func_226281_cx_());
        if (distanceFromTarget < 100.0 || distanceFromTarget > 22500.0 || this.guardian.field_70123_F || this.guardian.field_70124_G) {
            this.resumePathing();
        }
    }

    @Override
    public void globalServerTick() {
        if (this.agroModifier > 0) {
            --this.agroModifier;
        }
    }

    @Override
    public void initPhase() {
        this.minAgroLevel = 200.0f;
        this.maxAgroLevel = 600.0f;
        if (this.agroModifier > this.maxAgroModifier) {
            this.agroModifier = this.maxAgroModifier;
        }
        this.currentPath = null;
        this.targetLocation = null;
        float agroMod = 1.0f - (float)this.agroModifier / (float)this.maxAgroModifier * 0.75f;
        float minAgro = this.minAgroLevel * agroMod;
        float maxAgro = this.maxAgroLevel * agroMod;
        this.targetAgroLevel = minAgro + this.random.nextFloat() * (maxAgro - minAgro);
        this.agroLevel = 0.0f;
        if (this.guardian.field_70170_p.func_73046_m() != null) {
            this.debug("Start Phase, Target Agro: " + this.targetAgroLevel / 20.0f + ", Agro: " + this.agroLevel / 20.0f);
        }
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    private boolean startNextAttack() {
        PlayerEntity closeTarget = this.guardian.field_70170_p.func_217366_a(this.guardian.func_226277_ct_(), this.guardian.func_226278_cu_(), this.guardian.func_226281_cx_(), 30.0, true);
        if (closeTarget != null && (this.guardian.getShieldPower() < (float)DEConfig.guardianShield || this.random.nextFloat() < 0.25f)) {
            this.guardian.getPhaseManager().setPhase(PhaseType.COVER_FIRE);
            return true;
        }
        boolean aggressive = (double)this.agroModifier > (double)this.maxAgroModifier * 0.75 || this.failedAttacks > 3;
        List<PhaseType.WeightedPhase> phases = aggressive ? PhaseType.AGGRESSIVE_WEIGHTED : PhaseType.NORMAL_WEIGHTED;
        Vector3d focus = Vector3d.func_237489_a_((Vector3i)this.guardian.getArenaOrigin());
        List targetOptions = this.guardian.field_70170_p.func_217369_A().stream().filter(e -> e.func_195048_a(focus) <= 40000.0).filter(e -> AGRO_TARGETS.func_221015_a((LivingEntity)this.guardian, (LivingEntity)e)).collect(Collectors.toList());
        if (targetOptions.isEmpty()) {
            return false;
        }
        GuardianFightManager manager = this.guardian.getFightManager();
        if (manager == null) {
            return false;
        }
        PhaseType.WeightedPhase phaseType = (PhaseType.WeightedPhase)WeightedRandom.func_76271_a((Random)this.random, phases);
        Object phase = this.guardian.getPhaseManager().getPhase(phaseType.phase);
        if (phase instanceof ChargeUpPhase) {
            this.failedAttacks = 0;
            this.guardian.getPhaseManager().setPhase(PhaseType.APPROACH_POSITION).setTargetLocation(Vector3d.func_237489_a_((Vector3i)manager.getArenaOrigin().func_177981_b(48))).setNextPhase(phaseType.phase);
        } else {
            this.guardian.getPhaseManager().setPhase(phaseType.phase).targetPlayer((PlayerEntity)targetOptions.get(this.random.nextInt(targetOptions.size())));
        }
        return false;
    }

    private void resumePathing() {
        if (this.currentPath == null || this.currentPath.func_75879_b()) {
            int nearestIndex;
            int endIndex = nearestIndex = this.guardian.initPathPoints(false);
            if (this.guardian.func_70681_au().nextInt(8) == 0) {
                boolean bl = this.clockwise = !this.clockwise;
            }
            endIndex = this.clockwise ? (endIndex += 5 + this.guardian.func_70681_au().nextInt(7)) : (endIndex -= 5 + this.guardian.func_70681_au().nextInt(7));
            endIndex = Math.floorMod(endIndex, 24);
            this.currentPath = this.guardian.findPath(nearestIndex, endIndex, null);
            if (this.currentPath != null) {
                this.currentPath.func_75875_a();
            }
        }
        this.navigateToNextPathNode();
    }

    public void immediateAttack(@Nullable PlayerEntity target) {
        if (target != null) {
            this.attackPlayer(target);
        } else {
            this.agroLevel = this.targetAgroLevel;
        }
    }

    private void attackPlayer(PlayerEntity player) {
        if (this.guardian.func_70681_au().nextFloat() > 0.5f && this.guardian.func_70068_e((Entity)player) >= 40.0) {
            this.guardian.getPhaseManager().setPhase(PhaseType.BOMBARD_PLAYER).targetPlayer(player);
        } else {
            this.guardian.getPhaseManager().setPhase(PhaseType.CHARGE_PLAYER).targetPlayer(player);
        }
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.func_75879_b()) {
            BlockPos nextPos = this.currentPath.func_242948_g();
            this.currentPath.func_75875_a();
            double x = nextPos.func_177958_n();
            double z = nextPos.func_177952_p();
            double y = (float)nextPos.func_177956_o() + this.guardian.func_70681_au().nextFloat() * 20.0f;
            this.targetLocation = new Vector3d(x, y, z);
        }
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        if (!effective) {
            this.agroLevel += this.targetAgroLevel * 0.5f * (damage / 50.0f);
        }
        this.agroLevel = shield - damage > 0.0f ? (this.agroLevel += this.targetAgroLevel * 0.5f * (damage / ((float)DEConfig.guardianShield / 10.0f))) : (this.agroLevel += this.targetAgroLevel * 0.5f * (damage / ((float)DEConfig.guardianHealth / 10.0f)));
        this.agroModifier = (int)((float)this.agroModifier + (float)this.maxAgroModifier * 0.1f);
        if (this.guardian.field_70170_p.func_73046_m() != null) {
            this.debug("Agro: " + this.agroLevel + ", Agro Target: " + this.targetAgroLevel + ", Modifier: " + this.agroModifier + " " + (float)this.agroModifier / (float)this.maxAgroModifier * 100.0f + "%");
        }
        return damage;
    }

    @Override
    public void onCrystalAttacked(GuardianCrystalEntity crystal, BlockPos pos, DamageSource dmgSrc, @Nullable PlayerEntity plyr, float damage, boolean destroyed) {
        if (destroyed) {
            if (plyr != null && !plyr.field_71075_bZ.field_75102_a) {
                this.attackPlayer(plyr);
            } else {
                this.agroLevel = this.targetAgroLevel;
            }
        } else {
            this.agroLevel += this.targetAgroLevel * 0.25f * (damage / 10.0f);
            this.agroModifier = (int)((float)this.agroModifier + (float)this.maxAgroModifier * 0.05f * (damage / 10.0f));
            if (this.guardian.field_70170_p.func_73046_m() != null) {
                this.debug("Agro: " + this.agroLevel + ", Agro Target: " + this.targetAgroLevel + ", Modifier: " + this.agroModifier + " " + (float)this.agroModifier / (float)this.maxAgroModifier * 100.0f + "%");
            }
        }
    }

    private int getPlayerCount() {
        GuardianFightManager manager = this.guardian.getFightManager();
        if (manager != null) {
            return manager.getTrackedPlayers().size();
        }
        return this.guardian.field_70170_p.func_217373_a(AGRO_TARGETS, (LivingEntity)this.guardian, this.guardian.func_174813_aQ().func_186662_g(244.0)).size();
    }

    public StartPhase prevAttackFailed() {
        ++this.failedAttacks;
        return this;
    }
}

