/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityLootCore
extends Entity {
    private InventoryDynamic inventory = new InventoryDynamic();
    public double rotX = 0.0;
    public double rotY = 0.0;
    public int timeOffset = 0;
    public int pickupDellay = 0;
    public Map<ItemStack, Integer> displayMap = new HashMap<ItemStack, Integer>();
    public boolean isLooking = false;
    public float lookAnimation = 0.0f;
    private int despawnTimer = 0;
    private int lifespan = 6000;
    private boolean canDespawn = true;
    private List<ServerPlayerEntity> trackingPlayers = new ArrayList<ServerPlayerEntity>();

    public EntityLootCore(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return null;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.isLooking && this.lookAnimation < 1.0f) {
                this.lookAnimation += 0.05f;
            } else if (!this.isLooking && this.lookAnimation > 0.0f) {
                this.lookAnimation -= 0.05f;
            }
        } else if (this.canDespawn && this.despawnTimer++ > this.lifespan) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    public void func_70100_b_(PlayerEntity player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.despawnTimer = 0;
        if (this.pickupDellay > 0) {
            --this.pickupDellay;
            return;
        }
        if (this.inventory.xp > 0) {
            player.func_195068_e(this.inventory.xp);
            this.inventory.xp = 0;
        }
        boolean inserted = false;
        for (int i = this.inventory.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int start = stack.func_190916_E();
            ItemEntity item = new ItemEntity(this.field_70170_p, 0.0, 0.0, 0.0, stack);
            item.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            int result = ForgeEventFactory.onItemPickup((ItemEntity)item, (PlayerEntity)player);
            if (result != 1 && stack.func_190916_E() > 0 && !player.field_71071_by.func_70441_a(stack)) continue;
            if (!item.func_70089_S()) {
                stack.func_190920_e(0);
            }
            if (stack.func_190916_E() == 0) {
                this.inventory.func_70299_a(i, ItemStack.field_190927_a);
            } else {
                this.inventory.func_70299_a(i, stack);
            }
            if (stack.func_190916_E() >= start) continue;
            inserted = true;
        }
        if (inserted) {
            this.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.updateStored();
        }
        this.pickupDellay = 10;
        if (this.inventory.func_70302_i_() == 1 && this.inventory.func_70301_a(0).func_190926_b()) {
            this.func_70106_y();
        }
    }

    private void updateStored() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.displayMap = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack insert = this.inventory.func_70301_a(i);
            if (insert.func_190926_b()) continue;
            boolean added = false;
            for (ItemStack stack : this.displayMap.keySet()) {
                if (!insert.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)insert, (ItemStack)stack)) continue;
                added = true;
                this.displayMap.put(stack, this.displayMap.get(stack) + insert.func_190916_E());
                break;
            }
            if (added) continue;
            this.displayMap.put(insert, insert.func_190916_E());
        }
        for (ServerPlayerEntity serverPlayerEntity : this.trackingPlayers) {
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        this.trackingPlayers.add(player);
        super.func_184178_b(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        this.trackingPlayers.remove(player);
        super.func_184203_c(player);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.inventory.readFromNBT(compound);
        this.updateStored();
        this.despawnTimer = compound.func_74762_e("DespawnTimer");
        this.lifespan = compound.func_74762_e("Lifespan");
        this.canDespawn = compound.func_74767_n("CanDespawn");
    }

    protected void func_213281_b(CompoundNBT compound) {
        this.inventory.writeToNBT(compound);
        compound.func_74768_a("DespawnTimer", this.despawnTimer);
        compound.func_74768_a("Lifespan", this.lifespan);
        compound.func_74757_a("CanDespawn", this.canDespawn);
    }
}

