/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.sound;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.handlers.DESounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class ReactorSound
extends SimpleSound
implements ITickableSound {
    public boolean donePlaying = false;
    private TileReactorCore tile;
    private float targetPitch;
    private float targetVolume;
    private int stopTimer = 0;

    public ReactorSound(TileReactorCore tile) {
        super(DESounds.coreSound, SoundCategory.BLOCKS, tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE ? 10.0f : 1.5f, 1.0f, tile.func_174877_v());
        this.tile = tile;
        this.field_147659_g = true;
        this.targetPitch = 1.0f;
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }

    public void func_73660_a() {
        block13: {
            block12: {
                if (this.tile.roller != null) {
                    this.field_147660_d = (float)this.tile.roller.pos.x;
                    this.field_147661_e = (float)this.tile.roller.pos.y;
                    this.field_147658_f = (float)this.tile.roller.pos.z;
                } else {
                    this.field_147660_d = (float)this.tile.func_174877_v().func_177958_n() + 0.5f;
                    this.field_147661_e = (float)this.tile.func_174877_v().func_177956_o() + 0.5f;
                    this.field_147658_f = (float)this.tile.func_174877_v().func_177952_p() + 0.5f;
                }
                this.field_147663_c = (float)MathHelper.approachExp((double)this.field_147663_c, (double)this.targetPitch, (double)0.05);
                if (this.tile.reactorState.get() == TileReactorCore.ReactorState.WARMING_UP || this.tile.reactorState.get() == TileReactorCore.ReactorState.STOPPING || this.tile.reactorState.get() == TileReactorCore.ReactorState.COOLING) {
                    this.targetPitch = 0.5f + this.tile.shieldAnimationState / 2.0f;
                } else if (this.tile.reactorState.get() == TileReactorCore.ReactorState.RUNNING) {
                    this.targetPitch = 1.0f + (float)Math.max(0.0, Math.min(0.5, 1.0 - this.tile.shieldCharge.get() / this.tile.maxShieldCharge.get() * 10.0));
                } else if (this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE) {
                    if (this.field_147662_b == 1.5f) {
                        this.donePlaying = true;
                    }
                    if (this.tile.func_145831_w().field_73012_v.nextInt(10) == 0) {
                        this.targetPitch = 1.0f + this.tile.func_145831_w().field_73012_v.nextFloat() / 2.0f;
                    }
                }
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (this.tile.func_145837_r() || player == null) break block12;
                double d = player.func_195048_a(Vector3d.func_237491_b_((Vector3i)this.tile.func_174877_v()));
                int n = this.field_147662_b > 1.5f ? 4096 : 512;
                if (!(d > (double)n)) break block13;
            }
            this.donePlaying = true;
            this.field_147659_g = false;
        }
    }
}

