/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.client.DETextures;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.EffectLib;
import com.brandon3055.draconicevolution.client.render.tile.fxhandlers.FusionTileFXHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;

public class RenderTileFusionCraftingCore
extends TileEntityRenderer<TileFusionCraftingCore> {
    private static Random rand = new Random();
    private RenderType particleType = RenderType.func_228632_a_((String)"particle_type", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, false)).func_228713_a_(RenderState.field_228517_i_).func_228727_a_(RenderState.field_228495_E_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));

    public RenderTileFusionCraftingCore(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileFusionCraftingCore te, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packetLight, int packetOverlay) {
        this.renderContent(te, partialTicks, mStack, getter, packetLight, packetOverlay);
        FusionTileFXHandler handler = (FusionTileFXHandler)te.fxHandler;
        if (handler.renderActive()) {
            this.renderEffects(te, handler, partialTicks, mStack, getter, packetLight, packetOverlay);
        }
    }

    private void renderContent(TileFusionCraftingCore te, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packetLight, int packetOverlay) {
        ItemStack stack = !te.getOutputStack().func_190926_b() && !te.isCrafting() ? te.getOutputStack() : te.getCatalystStack();
        Minecraft mc = Minecraft.func_71410_x();
        if (!stack.func_190926_b()) {
            mStack.func_227860_a_();
            mStack.func_227861_a_(0.5, 0.5, 0.5);
            mStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            mStack.func_227863_a_(new Quaternion(0.0f, ((float)ClientEventHandler.elapsedTicks + partialTicks) * 0.8f, 0.0f, true));
            mc.func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, packetLight, packetOverlay, mStack, getter);
            mStack.func_227865_b_();
        }
    }

    private void renderEffects(TileFusionCraftingCore core, FusionTileFXHandler handler, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packetLight, int packetOverlay) {
        Minecraft mc = Minecraft.func_71410_x();
        ActiveRenderInfo renderInfo = mc.field_71460_t.func_215316_n();
        mStack.func_227861_a_(0.5, 0.5, 0.5);
        ParticleStatus pStatus = mc.field_71474_y.field_74362_aa;
        double particleSetting = pStatus == ParticleStatus.ALL ? 1.0 : (pStatus == ParticleStatus.DECREASED ? 0.6666666666666666 : 0.3333333333333333);
        int maxParticles = (int)(1000.0 * particleSetting);
        List<FusionTileFXHandler.IngredFX> ingredFXList = handler.getIngredients(partialTicks);
        int i = 0;
        for (FusionTileFXHandler.IngredFX ingred : ingredFXList) {
            this.renderIngredientEffect(renderInfo, mStack, getter, partialTicks, i++, ingred, maxParticles / ingredFXList.size());
            if (ingred.arcPos == null) continue;
            EffectLib.renderLightningP2PRotate(mStack, getter, ingred.pos, ingred.arcPos, 8, TimeKeeper.getClientTick() / 2, 0.06f, 0.04f, false, 0.0f, 6488253);
        }
        Rotation cameraRotation = new Rotation(new Quat(renderInfo.func_227995_f_()));
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(this.particleType), mStack);
        if (handler.injectTime > 0.0f) {
            rand.setSeed(3055L);
            double anim = handler.getRotationAnim(partialTicks);
            int chargePCount = 64;
            float pScale = 0.0625f;
            for (i = 0; i < chargePCount; ++i) {
                anim += rand.nextGaussian();
                float scale = MathHelper.func_76131_a((float)(handler.injectTime * (float)chargePCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
                if (scale <= 0.0f) break;
                float rotX = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 10.0);
                float rotY = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 15.0);
                double radius = 0.35 * MathUtils.clampMap((double)core.craftAnimProgress.get(), (double)0.95f, (double)1.0, (double)1.0, (double)0.0);
                double x = radius * (double)MathHelper.func_76134_b((float)rotX) * (double)MathHelper.func_76126_a((float)rotY);
                double y = radius * (double)MathHelper.func_76126_a((float)rotX) * (double)MathHelper.func_76126_a((float)rotY);
                double z = radius * (double)MathHelper.func_76134_b((float)rotY);
                EffectLib.drawParticle(cameraRotation, (IVertexBuilder)builder, DETextures.MIXED_PARTICLE[(TimeKeeper.getClientTick() + rand.nextInt(6423)) % DETextures.MIXED_PARTICLE.length], 1.0f, 0.0f, 0.0f, x, y, z, scale, 240);
            }
        }
        if (handler.chargeState > 0.0f) {
            double y;
            for (i = 0; i < 4; ++i) {
                float loopOffset = (float)i / 4.0f * ((float)Math.PI * 2) + (float)TimeKeeper.getClientTick() / 100.0f;
                for (int j = 0; j < 8; ++j) {
                    float rot = (float)j / 64.0f * (float)Math.PI * 2.0f + (float)TimeKeeper.getClientTick() / 10.0f + loopOffset;
                    if ((float)j > handler.chargeState * 8.0f) continue;
                    double x = MathHelper.func_76126_a((float)rot) * 2.0f;
                    double z = MathHelper.func_76134_b((float)rot) * 2.0f;
                    y = MathHelper.func_76134_b((float)(rot + loopOffset)) * 1.0f;
                    float scale = 0.1f * ((float)j / 8.0f);
                    EffectLib.drawParticle(cameraRotation, (IVertexBuilder)builder, DETextures.ENERGY_PARTICLE[(TimeKeeper.getClientTick() + j) % DETextures.ENERGY_PARTICLE.length], 0.41568628f, 0.050980393f, 0.6784314f, x, y, z, scale, 240);
                }
            }
            if (handler.injectTime > 0.0f && TimeKeeper.getClientTick() % 5 == 0) {
                int pos = rand.nextInt(4);
                for (i = 0; i < 4; ++i) {
                    if (i != pos) continue;
                    float loopOffset = (float)i / 4.0f * ((float)Math.PI * 2) + (float)TimeKeeper.getClientTick() / 100.0f;
                    float rot = 0.68722343f + (float)TimeKeeper.getClientTick() / 10.0f + loopOffset;
                    double x = MathHelper.func_76126_a((float)rot) * 2.0f;
                    double z = MathHelper.func_76134_b((float)rot) * 2.0f;
                    y = MathHelper.func_76134_b((float)(rot + loopOffset)) * 1.0f;
                    EffectLib.renderLightningP2PRotate(mStack, getter, new Vector3(x, y, z), Vector3.ZERO, 8, TimeKeeper.getClientTick() / 2, 0.06f, 0.04f, false, 0.0f, 6488253);
                }
            }
        }
    }

    private void renderIngredientEffect(ActiveRenderInfo renderInfo, MatrixStack mStack, IRenderTypeBuffer getter, float partialTicks, long randSeed, FusionTileFXHandler.IngredFX ingred, int totalParticles) {
        Rotation cameraRotation = new Rotation(new Quat(renderInfo.func_227995_f_()));
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(this.particleType), mStack);
        rand.setSeed(randSeed);
        double anim = ingred.getChargeAnim(partialTicks);
        int chargePCount = Math.min(64, totalParticles / 3);
        float pScale = 0.025f;
        for (int i = 0; i < chargePCount; ++i) {
            anim += rand.nextGaussian();
            float scale = MathHelper.func_76131_a((float)(ingred.getCharge() * ingred.dieOut * (float)chargePCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
            if (scale <= 0.0f) break;
            float rotX = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 10.0);
            float rotY = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 15.0);
            double radius = 0.25;
            double x = ingred.pos.x + radius * (double)MathHelper.func_76134_b((float)rotX) * (double)MathHelper.func_76126_a((float)rotY);
            double y = ingred.pos.y + radius * (double)MathHelper.func_76126_a((float)rotX) * (double)MathHelper.func_76126_a((float)rotY);
            double z = ingred.pos.z + radius * (double)MathHelper.func_76134_b((float)rotY);
            EffectLib.drawParticle(cameraRotation, (IVertexBuilder)builder, DETextures.ENERGY_PARTICLE[(TimeKeeper.getClientTick() + rand.nextInt(6423)) % DETextures.ENERGY_PARTICLE.length], 0.0f, 0.8f + rand.nextFloat() * 0.2f, 1.0f, x, y, z, scale, 240);
        }
        int itemPCount = Math.min(48, totalParticles / 3);
        rand.setSeed(randSeed);
        anim = ingred.getChargeAnim(partialTicks);
        pScale = 0.0125f;
        Vector3 pos = new Vector3();
        for (int i = 0; i < itemPCount; ++i) {
            int seed = (int)Math.floor((anim += rand.nextDouble() * 69420.0) / 20.0);
            MathUtils.setRandSeed((long)seed);
            float pulse = (float)anim / 20.0f % 1.0f;
            float scale = MathHelper.func_76131_a((float)(ingred.coreAnim * ingred.dieOut * (float)itemPCount - (float)i), (float)0.0f, (float)1.0f);
            if (scale <= 0.0f) break;
            scale = (float)((double)scale * (1.0 - Math.sin((double)pulse * Math.PI * 2.0)));
            pos.set((double)MathUtils.nextFloat(), (double)MathUtils.nextFloat(), (double)MathUtils.nextFloat());
            pos.subtract(0.5);
            pos.normalize();
            pos.multiply((double)MathUtils.nextFloat() * 0.1875);
            pos.add(ingred.pos);
            EffectLib.drawParticle(cameraRotation, (IVertexBuilder)builder, DETextures.SPELL_PARTICLE[(rand.nextInt(DETextures.SPELL_PARTICLE.length) + TimeKeeper.getClientTick()) % DETextures.SPELL_PARTICLE.length], 0.7f, 0.0f, 0.0f, pos.x, pos.y, pos.z, scale * pScale, 240);
        }
        double randOffset = 0.125;
        rand.setSeed(randSeed);
        anim = ingred.beamAnim;
        pScale = 0.025f;
        int beamPCount = Math.min(32, totalParticles / 3);
        if (ingred.beamAnim > 0.0f) {
            for (int i = 0; i < beamPCount; ++i) {
                anim += rand.nextDouble() * 64.0;
                float scale = MathHelper.func_76131_a((float)(Math.min(1.0f, ingred.beamAnim / 60.0f) * ingred.dieOut * (float)beamPCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
                if (scale <= 0.0f) break;
                Vector3 start = ingred.pos.copy().add((0.5 - rand.nextDouble()) * (randOffset * 2.0), (0.5 - rand.nextDouble()) * (randOffset * 2.0), (0.5 - rand.nextDouble()) * (randOffset * 2.0));
                Vector3 end = new Vector3((0.5 - rand.nextDouble()) * (randOffset * 2.0), (0.5 - rand.nextDouble()) * (randOffset * 2.0), (0.5 - rand.nextDouble()) * (randOffset * 2.0));
                pos = MathUtils.interpolateVec3((Vector3)start, (Vector3)end, (double)(anim / 10.0 % 1.0));
                EffectLib.drawParticle(cameraRotation, (IVertexBuilder)builder, DETextures.SPARK_PARTICLE[(rand.nextInt(DETextures.SPARK_PARTICLE.length) + TimeKeeper.getClientTick()) % DETextures.SPARK_PARTICLE.length], 0.7f + (float)anim / 10.0f % 1.0f * 0.3f, 0.0f, 0.0f, pos.x, pos.y, pos.z, scale, 240);
            }
        }
    }
}

