/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.colour.Colour;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderTileEnergyCore
extends TileEntityRenderer<TileEnergyCore> {
    private static final double[] SCALES = new double[]{1.1, 1.7, 2.3, 3.6, 5.5, 7.1, 8.6, 10.2};
    private static final RenderType innerCoreType = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/core/energy_core_base.png"));
    private static final RenderType outerCoreType = RenderType.func_228633_a_((String)"outer_core", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/block/core/energy_core_overlay.png"), false, false)).func_228726_a_(RenderState.field_228515_g_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private static final RenderType innerStabType = RenderType.func_228633_a_((String)"inner_stab", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/block/core/stabilizer_sphere.png"), false, false)).func_228726_a_(RenderState.field_228510_b_).func_228728_a_(false));
    private static final RenderType outerStabType = RenderType.func_228633_a_((String)"outer_stab", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/block/core/stabilizer_sphere.png"), false, false)).func_228726_a_(RenderState.field_228515_g_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private static final RenderType beamType = RenderType.func_228633_a_((String)"inner_beam", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/block/core/stabilizer_beam.png"), false, false)).func_228726_a_(RenderState.field_228510_b_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private static final RenderType outerBeamType = RenderType.func_228633_a_((String)"outer_beam", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)5, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/block/core/stabilizer_beam.png"), false, false)).func_228726_a_(RenderState.field_228515_g_).func_228727_a_(RenderState.field_228496_F_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private final CCModel modelStabilizerSphere;
    private final CCModel modelEnergyCore;

    public RenderTileEnergyCore(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Map map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/core/stabilizer_sphere.obj"), (int)7, null);
        this.modelStabilizerSphere = CCModel.combine(map.values());
        this.modelStabilizerSphere.computeNormals();
        map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/core/energy_core_model.obj"), (int)7, null);
        this.modelEnergyCore = CCModel.combine(map.values());
        this.modelEnergyCore.computeNormals();
    }

    public void render(TileEnergyCore te, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        if (!te.active.get()) {
            return;
        }
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        float rotation = ((float)ClientEventHandler.elapsedTicks + partialTicks) / 2.0f;
        int brightness = (int)Math.abs(Math.sin((float)ClientEventHandler.elapsedTicks / 100.0f) * 100.0);
        double scale = SCALES[te.tier.get() - 1];
        ccrs.baseColour = te.getColour();
        ccrs.brightness = 140 + brightness;
        ccrs.bind(innerCoreType, getter);
        Matrix4 coreMat = mat.copy();
        coreMat.translate(Vector3.CENTER);
        coreMat.scale(scale * -0.65, scale * -0.65, scale * -0.65);
        coreMat.rotate((double)rotation * 0.017453292519943, new Vector3(0.0, 1.0, 0.5).normalize());
        this.modelEnergyCore.render(ccrs, new IVertexOperation[]{coreMat});
        ccrs.baseColour = te.tier.get() == 8 ? Colour.packRGBA((double)0.95f, (double)0.45f, (double)0.0, (double)1.0) : Colour.packRGBA((double)0.2f, (double)1.0, (double)1.0, (double)1.0);
        ccrs.bind(outerCoreType, getter);
        Matrix4 overlayMat = mat.copy();
        overlayMat.translate(Vector3.CENTER);
        overlayMat.scale(scale * -0.7, scale * -0.7, scale * -0.7);
        overlayMat.rotate((double)(rotation * 0.5f) * 0.017453292519943, new Vector3(0.0, -1.0, -0.5).normalize());
        this.modelEnergyCore.render(ccrs, new IVertexOperation[]{overlayMat});
        this.renderStabilizers(te, ccrs, mat, getter, partialTicks);
    }

    private void renderStabilizers(TileEnergyCore te, CCRenderState ccrs, Matrix4 matrix4, IRenderTypeBuffer getter, float partialTick) {
        if (!te.stabilizersOK.get()) {
            return;
        }
        for (ManagedVec3I vec3I : te.stabOffsets) {
            Matrix4 mat = matrix4.copy();
            mat.translate((double)(-vec3I.get().x) + 0.5, (double)(-vec3I.get().y) + 0.5, (double)(-vec3I.get().z) + 0.5);
            Direction facing = Direction.func_176737_a((float)vec3I.get().x, (float)vec3I.get().y, (float)vec3I.get().z);
            if (facing.func_176740_k() == Direction.Axis.X || facing.func_176740_k() == Direction.Axis.Y) {
                mat.rotate(-1.5707963267948701, new Vector3((double)(-facing.func_96559_d()), (double)facing.func_82601_c(), 0.0).normalize());
            } else if (facing == Direction.SOUTH) {
                mat.rotate(3.1415926535897403, new Vector3(0.0, 1.0, 0.0).normalize());
            }
            mat.rotate(1.5707963267948701, new Vector3(1.0, 0.0, 0.0).normalize());
            ccrs.baseColour = -1;
            this.renderStabilizerBeam(te, mat, getter, vec3I.get(), partialTick);
            if (te.tier.get() >= 5) {
                mat.scale((double)-1.2f, -0.5, (double)-1.2f);
            } else {
                mat.scale(-0.45, -0.45, -0.45);
            }
            Matrix4 innerMat = mat.copy();
            innerMat.scale((double)0.9f, (double)0.9f, (double)0.9f);
            ccrs.baseColour = 0xFFFFFF;
            ccrs.brightness = 240;
            innerMat.rotate((double)((float)ClientEventHandler.elapsedTicks + partialTick) * 0.017453292519943, new Vector3(0.0, -1.0, 0.0));
            ccrs.bind(innerStabType, getter);
            this.modelStabilizerSphere.render(ccrs, new IVertexOperation[]{innerMat});
            mat.scale((double)1.1f, (double)1.1f, (double)1.1f);
            ccrs.baseColour = 0xFFFF7F;
            ccrs.brightness = 240;
            mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTick) * 0.5f) * 0.017453292519943, new Vector3(0.0, 1.0, 0.0));
            ccrs.bind(outerStabType, getter);
            this.modelStabilizerSphere.render(ccrs, new IVertexOperation[]{mat});
        }
    }

    private void renderStabilizerBeam(TileEnergyCore te, Matrix4 matrix4, IRenderTypeBuffer getter, Vec3I vec, float partialTick) {
        Matrix4 innerMat = matrix4.copy();
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(beamType), (Transformation)innerMat);
        innerMat.rotate(3.1415926535897403, new Vector3(0.0, 0.0, 1.0));
        float beamLength = (float)Math.abs(vec.x + vec.y + vec.z) - 0.5f;
        float time = (float)ClientEventHandler.elapsedTicks + partialTick;
        double rotation = (double)time * 0.025 * -1.5;
        float beamMotion = -time * 0.2f - (float)MathHelper.floor((float)(-time * 0.1f));
        float scale = 0.2f;
        float d7 = 0.5f + (float)Math.cos(rotation + 2.356194496154785) * scale;
        float d9 = 0.5f + (float)Math.sin(rotation + 2.356194496154785) * scale;
        float d11 = 0.5f + (float)Math.cos(rotation + 0.7853981633974483) * scale;
        float d13 = 0.5f + (float)Math.sin(rotation + 0.7853981633974483) * scale;
        float d15 = 0.5f + (float)Math.cos(rotation + 3.9269907474517822) * scale;
        float d17 = 0.5f + (float)Math.sin(rotation + 3.9269907474517822) * scale;
        float d19 = 0.5f + (float)Math.cos(rotation + 5.497786998748779) * scale;
        float d21 = 0.5f + (float)Math.sin(rotation + 5.497786998748779) * scale;
        float texXMin = 0.0f;
        float texXMax = 1.0f;
        float d28 = -1.0f + beamMotion;
        float texHeight = beamLength * (0.5f / scale) + d28;
        if (te.tier.get() >= 5) {
            innerMat.scale(3.5, 1.0, 3.5);
        }
        innerMat.translate(-0.5, 0.0, -0.5);
        builder.func_225582_a_((double)d7, (double)beamLength, (double)d9).func_225583_a_(texXMax, texHeight).func_181675_d();
        builder.func_225582_a_((double)d7, 0.0, (double)d9).func_225583_a_(texXMax, d28).func_181675_d();
        builder.func_225582_a_((double)d11, 0.0, (double)d13).func_225583_a_(texXMin, d28).func_181675_d();
        builder.func_225582_a_((double)d11, (double)beamLength, (double)d13).func_225583_a_(texXMin, texHeight).func_181675_d();
        builder.func_225582_a_((double)d19, (double)beamLength, (double)d21).func_225583_a_(texXMax, texHeight).func_181675_d();
        builder.func_225582_a_((double)d19, 0.0, (double)d21).func_225583_a_(texXMax, d28).func_181675_d();
        builder.func_225582_a_((double)d15, 0.0, (double)d17).func_225583_a_(texXMin, d28).func_181675_d();
        builder.func_225582_a_((double)d15, (double)beamLength, (double)d17).func_225583_a_(texXMin, texHeight).func_181675_d();
        builder.func_225582_a_((double)d11, (double)beamLength, (double)d13).func_225583_a_(texXMax, texHeight).func_181675_d();
        builder.func_225582_a_((double)d11, 0.0, (double)d13).func_225583_a_(texXMax, d28).func_181675_d();
        builder.func_225582_a_((double)d19, 0.0, (double)d21).func_225583_a_(texXMin, d28).func_181675_d();
        builder.func_225582_a_((double)d19, (double)beamLength, (double)d21).func_225583_a_(texXMin, texHeight).func_181675_d();
        builder.func_225582_a_((double)d15, (double)beamLength, (double)d17).func_225583_a_(texXMax, texHeight).func_181675_d();
        builder.func_225582_a_((double)d15, 0.0, (double)d17).func_225583_a_(texXMax, d28).func_181675_d();
        builder.func_225582_a_((double)d7, 0.0, (double)d9).func_225583_a_(texXMin, d28).func_181675_d();
        builder.func_225582_a_((double)d7, (double)beamLength, (double)d9).func_225583_a_(texXMin, texHeight).func_181675_d();
        d7 = 0.5f + (float)Math.cos((rotation += (double)0.77f) + 2.356194496154785) * scale;
        d9 = 0.5f + (float)Math.sin(rotation + 2.356194496154785) * scale;
        d11 = 0.5f + (float)Math.cos(rotation + 0.7853981633974483) * scale;
        d13 = 0.5f + (float)Math.sin(rotation + 0.7853981633974483) * scale;
        d15 = 0.5f + (float)Math.cos(rotation + 3.9269907474517822) * scale;
        d17 = 0.5f + (float)Math.sin(rotation + 3.9269907474517822) * scale;
        d19 = 0.5f + (float)Math.cos(rotation + 5.497786998748779) * scale;
        d21 = 0.5f + (float)Math.sin(rotation + 5.497786998748779) * scale;
        d28 = -1.0f + beamMotion * 1.0f;
        texHeight = beamLength * (0.5f / scale) + d28;
        builder.func_225582_a_((double)d7, (double)beamLength, (double)d9).func_225583_a_(texXMax, texHeight).func_181675_d();
        builder.func_225582_a_((double)d7, 0.0, (double)d9).func_225583_a_(texXMax, d28).func_181675_d();
        builder.func_225582_a_((double)d11, 0.0, (double)d13).func_225583_a_(texXMin, d28).func_181675_d();
        builder.func_225582_a_((double)d11, (double)beamLength, (double)d13).func_225583_a_(texXMin, texHeight).func_181675_d();
        builder.func_225582_a_((double)d19, (double)beamLength, (double)d21).func_225583_a_(texXMax, texHeight).func_181675_d();
        builder.func_225582_a_((double)d19, 0.0, (double)d21).func_225583_a_(texXMax, d28).func_181675_d();
        builder.func_225582_a_((double)d15, 0.0, (double)d17).func_225583_a_(texXMin, d28).func_181675_d();
        builder.func_225582_a_((double)d15, (double)beamLength, (double)d17).func_225583_a_(texXMin, texHeight).func_181675_d();
        builder.func_225582_a_((double)d11, (double)beamLength, (double)d13).func_225583_a_(texXMax, texHeight).func_181675_d();
        builder.func_225582_a_((double)d11, 0.0, (double)d13).func_225583_a_(texXMax, d28).func_181675_d();
        builder.func_225582_a_((double)d19, 0.0, (double)d21).func_225583_a_(texXMin, d28).func_181675_d();
        builder.func_225582_a_((double)d19, (double)beamLength, (double)d21).func_225583_a_(texXMin, texHeight).func_181675_d();
        builder.func_225582_a_((double)d15, (double)beamLength, (double)d17).func_225583_a_(texXMax, texHeight).func_181675_d();
        builder.func_225582_a_((double)d15, 0.0, (double)d17).func_225583_a_(texXMax, d28).func_181675_d();
        builder.func_225582_a_((double)d7, 0.0, (double)d9).func_225583_a_(texXMin, d28).func_181675_d();
        builder.func_225582_a_((double)d7, (double)beamLength, (double)d9).func_225583_a_(texXMin, texHeight).func_181675_d();
        Matrix4 outerMat = matrix4.copy();
        builder = new TransformingVertexBuilder(getter.getBuffer(outerBeamType), (Transformation)outerMat);
        outerMat.rotate(3.1415926535897403, new Vector3(0.0, 0.0, 1.0));
        outerMat.rotate(1.5707963267948701, new Vector3(-1.0, 0.0, 0.0));
        outerMat.rotate(0.7853981633974351, new Vector3(0.0, 0.0, 1.0));
        outerMat.translate(0.0, 0.0, 0.4);
        int sides = 4;
        float enlarge = 0.35f;
        if (te.tier.get() >= 5) {
            sides = 12;
            enlarge = 0.5f + (float)(te.tier.get() - 5) * 0.1f;
            outerMat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTick) * 0.6f) * 0.017453292519943, new Vector3(0.0, 0.0, -1.0));
            outerMat.scale(3.5, 3.5, 1.0);
        }
        for (int i = 0; i <= sides; ++i) {
            float verX = (float)Math.sin((float)(i % sides) * (float)Math.PI * 2.0f / (float)sides) * 1.0f;
            float verY = (float)Math.cos((float)(i % sides) * (float)Math.PI * 2.0f / (float)sides) * 1.0f;
            builder.func_225582_a_((double)(verX * 0.35f), (double)(verY * 0.35f), 0.0).func_225586_a_(255, 255, 255, 32).func_225583_a_((float)i, beamMotion * 2.0f).func_181675_d();
            builder.func_225582_a_((double)(verX * enlarge), (double)(verY * enlarge), (double)beamLength).func_225586_a_(255, 255, 255, 32).func_225583_a_((float)i, beamLength + beamMotion * 2.0f).func_181675_d();
        }
    }

    public boolean shouldRenderOffScreen(TileEnergyCore p_188185_1_) {
        return true;
    }
}

