/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity;

import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.render.entity.GuardianCrystalRenderer;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DraconicGuardianRenderer
extends EntityRenderer<DraconicGuardianEntity> {
    public static final ResourceLocation ENDERCRYSTAL_BEAM_TEXTURES = new ResourceLocation("draconicevolution", "textures/entity/guardian_crystal_beam.png");
    private static final ResourceLocation DRAGON_EXPLODING_TEXTURES = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation DRAGON_TEXTURE = new ResourceLocation("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation GUARDIAN_TEXTURE = new ResourceLocation("draconicevolution", "textures/entity/chaos_guardian.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("textures/entity/enderdragon/dragon_eyes.png");
    private static final RenderType dragonCutoutType = RenderType.func_228640_c_((ResourceLocation)GUARDIAN_TEXTURE);
    private static final RenderType dragonDeathType = RenderType.func_228648_g_((ResourceLocation)GUARDIAN_TEXTURE);
    private static final RenderType eyesType = RenderType.func_228652_i_((ResourceLocation)EYES_TEXTURE);
    private static final RenderType beamType = RenderType.func_228646_f_((ResourceLocation)ENDERCRYSTAL_BEAM_TEXTURES);
    private static RenderType beamType2 = RenderType.func_228633_a_((String)"beam_type_2", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(ENDERCRYSTAL_BEAM_TEXTURES, false, false)).func_228726_a_(RenderState.field_228515_g_).func_228714_a_(RenderState.field_228491_A_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    public static final RenderType shieldType = RenderType.func_228632_a_((String)"shield_type", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228716_a_(RenderState.field_228532_x_).func_228714_a_(RenderState.field_228491_A_).func_228713_a_(RenderState.field_228517_i_).func_228715_a_(RenderState.field_228493_C_).func_228728_a_(false));
    public static RenderType beamShaderType = RenderType.func_228632_a_((String)"beam_shader_type", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(ENDERCRYSTAL_BEAM_TEXTURES, true, false)).func_228719_a_(RenderState.field_228528_t_).func_228722_a_(RenderState.field_228530_v_).func_228728_a_(false));
    public static ShaderProgram shieldShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/guardian_shield.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/guardian_shield.frag")).uniform("time", UniformType.FLOAT).uniform("baseColour", UniformType.VEC4).uniform("activation", UniformType.FLOAT)).whenUsed(cache -> {
        cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 20.0f);
        cache.glUniform1f("activation", 1.0f);
    }).build();
    private static final float sqrt3div2 = (float)(Math.sqrt(3.0) / 2.0);
    private final EnderDragonModel model = new EnderDragonModel();

    public DraconicGuardianRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.5f;
    }

    public void render(DraconicGuardianEntity guardian, float entityYaw, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight) {
        ChargeUpPhase phase;
        IPhase iPhase;
        mStack.func_227860_a_();
        float f = (float)guardian.getMovementOffsets(7, partialTicks)[0];
        float f1 = (float)(guardian.getMovementOffsets(5, partialTicks)[1] - guardian.getMovementOffsets(10, partialTicks)[1]);
        mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
        mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f1 * 10.0f));
        mStack.func_227861_a_(0.0, 0.0, 1.0);
        mStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        mStack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        boolean flag = guardian.field_70737_aN > 0;
        this.model.prepareMobModel(guardian, 0.0f, 0.0f, partialTicks);
        if (guardian.deathTicks > 0) {
            float progress = (float)guardian.deathTicks / 200.0f;
            IVertexBuilder builder = getter.getBuffer(RenderType.func_239264_a_((ResourceLocation)DRAGON_EXPLODING_TEXTURES, (float)progress));
            this.model.func_225598_a_(mStack, builder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            builder = getter.getBuffer(dragonDeathType);
            this.model.func_225598_a_(mStack, builder, packedLight, OverlayTexture.func_229200_a_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            IVertexBuilder builder = getter.getBuffer(dragonCutoutType);
            this.model.func_225598_a_(mStack, builder, packedLight, OverlayTexture.func_229200_a_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        boolean isImmune = guardian.getPhaseManager().getCurrentPhase().isInvulnerable();
        float shieldState = ((Float)guardian.func_184212_Q().func_187225_a(DraconicGuardianEntity.SHIELD_POWER)).floatValue() / (float)DEConfig.guardianShield;
        if (shieldState > 0.0f || isImmune) {
            UniformCache uniforms = shieldShader.pushCache();
            if (isImmune) {
                uniforms.glUniform4f("baseColour", 0.0f, 1.0f, 1.0f, 2.0f);
            } else {
                uniforms.glUniform4f("baseColour", 1.0f, 0.0f, 0.0f, 1.5f * shieldState);
            }
            IVertexBuilder builder = getter.getBuffer((RenderType)new ShaderRenderType(shieldType, shieldShader, uniforms));
            this.model.func_225598_a_(mStack, builder, packedLight, OverlayTexture.func_229200_a_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        IVertexBuilder builder = getter.getBuffer(eyesType);
        this.model.func_225598_a_(mStack, builder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (guardian.deathTicks > 0) {
            float f5 = ((float)guardian.deathTicks + partialTicks) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            Random random = new Random(432L);
            builder = getter.getBuffer(RenderType.func_228657_l_());
            mStack.func_227860_a_();
            mStack.func_227861_a_(0.0, -1.0, -2.0);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
                mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
                mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f));
                mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
                mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
                mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = mStack.func_227866_c_().func_227870_a_();
                int j = (int)(255.0f * (1.0f - f7));
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimB(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimC(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimC(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimD(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimD(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimB(builder, matrix4f, f3, f4);
                ++i;
            }
            mStack.func_227865_b_();
        }
        mStack.func_227865_b_();
        if (guardian.closestGuardianCrystal != null) {
            mStack.func_227860_a_();
            float relX = (float)(guardian.closestGuardianCrystal.func_226277_ct_() - MathHelper.func_219803_d((double)partialTicks, (double)guardian.field_70169_q, (double)guardian.func_226277_ct_()));
            float relY = (float)(guardian.closestGuardianCrystal.func_226278_cu_() - MathHelper.func_219803_d((double)partialTicks, (double)guardian.field_70167_r, (double)guardian.func_226278_cu_()));
            float relZ = (float)(guardian.closestGuardianCrystal.func_226281_cx_() - MathHelper.func_219803_d((double)partialTicks, (double)guardian.field_70166_s, (double)guardian.func_226281_cx_()));
            DraconicGuardianRenderer.renderBeam(relX, relY + GuardianCrystalRenderer.getY(guardian.closestGuardianCrystal, partialTicks), relZ, partialTicks, guardian.field_70173_aa, mStack, getter, packedLight);
            mStack.func_227865_b_();
        }
        if ((iPhase = guardian.getPhaseManager().getCurrentPhase()) instanceof ChargeUpPhase && guardian.getArenaOrigin() != null && (phase = (ChargeUpPhase)iPhase).animState() != 0.0f) {
            BlockPos origin = guardian.getArenaOrigin();
            float beamSin = MathHelper.func_76126_a((float)(phase.animState() * (float)Math.PI));
            mStack.func_227860_a_();
            float relX = (float)((double)origin.func_177958_n() + 0.5 - MathHelper.func_219803_d((double)partialTicks, (double)guardian.field_70169_q, (double)guardian.func_226277_ct_()));
            float relY = (float)((double)origin.func_177956_o() + 0.5 - MathHelper.func_219803_d((double)partialTicks, (double)guardian.field_70167_r, (double)guardian.func_226278_cu_()));
            float relZ = (float)((double)origin.func_177952_p() + 0.5 - MathHelper.func_219803_d((double)partialTicks, (double)guardian.field_70166_s, (double)guardian.func_226281_cx_()));
            DraconicGuardianRenderer.renderChargingBeam(relX, relY, relZ, partialTicks, guardian.field_70173_aa, mStack, getter, packedLight, beamSin);
            mStack.func_227865_b_();
        }
        super.func_225623_a_((Entity)guardian, entityYaw, partialTicks, mStack, getter, packedLight);
    }

    private static void deathAnimA(IVertexBuilder builder, Matrix4f mat, int alpha) {
        builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 0, 0, alpha).func_181675_d();
        builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 0, 0, alpha).func_181675_d();
    }

    private static void deathAnimB(IVertexBuilder builder, Matrix4f mat, float p_229060_2_, float p_229060_3_) {
        builder.func_227888_a_(mat, -sqrt3div2 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).func_225586_a_(255, 0, 0, 0).func_181675_d();
    }

    private static void deathAnimC(IVertexBuilder builder, Matrix4f mat, float p_229062_2_, float p_229062_3_) {
        builder.func_227888_a_(mat, sqrt3div2 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).func_225586_a_(255, 0, 255, 0).func_181675_d();
    }

    private static void deathAnimD(IVertexBuilder builder, Matrix4f mat, float p_229063_2_, float p_229063_3_) {
        builder.func_227888_a_(mat, 0.0f, p_229063_2_, 1.0f * p_229063_3_).func_225586_a_(255, 0, 0, 0).func_181675_d();
    }

    public static void renderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight) {
        float xzDistance = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.0, 2.0, 0.0);
        mStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        IVertexBuilder builder = getter.getBuffer(beamType);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        MatrixStack.Entry stackLast = mStack.func_227866_c_();
        Matrix4f lastMatrix = stackLast.func_227870_a_();
        Matrix3f lastNormal = stackLast.func_227872_b_();
        for (int j = 1; j <= 8; ++j) {
            float rSin = MathHelper.func_76126_a((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = MathHelper.func_76134_b((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.func_227888_a_(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).func_225586_a_(0, 0, 0, 255).func_225583_a_(f6, f2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, f4, f5, distance).func_225586_a_(255, 255, 255, 255).func_225583_a_(f6, f3).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, rSin, rCos, distance).func_225586_a_(255, 255, 255, 255).func_225583_a_(indexDecimal, f3).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).func_225586_a_(0, 0, 0, 255).func_225583_a_(indexDecimal, f2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.func_227865_b_();
    }

    public static void renderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, float alpha) {
        float xzDistance = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.0, 2.0, 0.0);
        mStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        IVertexBuilder builder = getter.getBuffer(beamType2);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        MatrixStack.Entry stackLast = mStack.func_227866_c_();
        Matrix4f lastMatrix = stackLast.func_227870_a_();
        Matrix3f lastNormal = stackLast.func_227872_b_();
        for (int j = 1; j <= 8; ++j) {
            float rSin = MathHelper.func_76126_a((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = MathHelper.func_76134_b((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.func_227888_a_(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(f6, f2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, f4, f5, distance).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(f6, f3).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, rSin, rCos, distance).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(indexDecimal, f3).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(indexDecimal, f2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.func_227865_b_();
    }

    public static void renderChargingBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, float alpha) {
        float xzDistance = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.0, 2.0, 0.0);
        mStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        IVertexBuilder builder = getter.getBuffer(beamType2);
        float vMin = ((float)animTicks + partialTicks) * 0.01f;
        float vMax = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f + ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.1f;
        float texU = 0.0f;
        MatrixStack.Entry stackLast = mStack.func_227866_c_();
        Matrix4f lastMatrix = stackLast.func_227870_a_();
        Matrix3f lastNormal = stackLast.func_227872_b_();
        float taperOffset = 10.0f;
        for (int j = 1; j <= 8; ++j) {
            float rSin = MathHelper.func_76126_a((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.1f;
            float rCos = MathHelper.func_76134_b((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.1f;
            float indexDecimal = (float)j / 8.0f;
            builder.func_227888_a_(lastMatrix, f4 * taperOffset, f5 * taperOffset, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(texU, vMin).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, f4, f5, distance).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(texU, vMax).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, rSin, rCos, distance).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(indexDecimal, vMax).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, rSin * taperOffset, rCos * taperOffset, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(indexDecimal, vMin).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            f4 = rSin;
            f5 = rCos;
            texU = indexDecimal;
        }
        mStack.func_227865_b_();
    }

    public static void renderShaderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight) {
        float xzDistance = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.0, 2.0, 0.0);
        mStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        IVertexBuilder builder = getter.getBuffer(beamType);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = MathHelper.func_76129_c((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        MatrixStack.Entry stackLast = mStack.func_227866_c_();
        Matrix4f lastMatrix = stackLast.func_227870_a_();
        Matrix3f lastNormal = stackLast.func_227872_b_();
        for (int j = 1; j <= 8; ++j) {
            float rSin = MathHelper.func_76126_a((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = MathHelper.func_76134_b((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.func_227888_a_(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).func_225586_a_(0, 0, 0, 255).func_225583_a_(f6, f2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, f4, f5, distance).func_225586_a_(255, 255, 255, 255).func_225583_a_(f6, f3).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, rSin, rCos, distance).func_225586_a_(255, 255, 255, 255).func_225583_a_(indexDecimal, f3).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).func_225586_a_(0, 0, 0, 255).func_225583_a_(indexDecimal, f2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(lastNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(DraconicGuardianEntity entity) {
        return DRAGON_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EnderDragonModel
    extends EntityModel<DraconicGuardianEntity> {
        private final ModelRenderer head;
        private final ModelRenderer spine;
        private final ModelRenderer jaw;
        private final ModelRenderer body;
        private ModelRenderer leftProximalWing;
        private ModelRenderer leftDistalWing;
        private ModelRenderer leftForeThigh;
        private ModelRenderer leftForeLeg;
        private ModelRenderer leftForeFoot;
        private ModelRenderer leftHindThigh;
        private ModelRenderer leftHindLeg;
        private ModelRenderer leftHindFoot;
        private ModelRenderer rightProximalWing;
        private ModelRenderer rightDistalWing;
        private ModelRenderer rightForeThigh;
        private ModelRenderer rightForeLeg;
        private ModelRenderer rightForeFoot;
        private ModelRenderer rightHindThigh;
        private ModelRenderer rightHindLeg;
        private ModelRenderer rightHindFoot;
        @Nullable
        private DraconicGuardianEntity dragonInstance;
        private float partialTicks;

        public EnderDragonModel() {
            this.field_78090_t = 256;
            this.field_78089_u = 256;
            float f = -16.0f;
            this.head = new ModelRenderer((Model)this);
            this.head.func_217178_a("upperlip", -6.0f, -1.0f, -24.0f, 12, 5, 16, 0.0f, 176, 44);
            this.head.func_217178_a("upperhead", -8.0f, -8.0f, -10.0f, 16, 16, 16, 0.0f, 112, 30);
            this.head.field_78809_i = true;
            this.head.func_217178_a("scale", -5.0f, -12.0f, -4.0f, 2, 4, 6, 0.0f, 0, 0);
            this.head.func_217178_a("nostril", -5.0f, -3.0f, -22.0f, 2, 2, 4, 0.0f, 112, 0);
            this.head.field_78809_i = false;
            this.head.func_217178_a("scale", 3.0f, -12.0f, -4.0f, 2, 4, 6, 0.0f, 0, 0);
            this.head.func_217178_a("nostril", 3.0f, -3.0f, -22.0f, 2, 2, 4, 0.0f, 112, 0);
            this.jaw = new ModelRenderer((Model)this);
            this.jaw.func_78793_a(0.0f, 4.0f, -8.0f);
            this.jaw.func_217178_a("jaw", -6.0f, 0.0f, -16.0f, 12, 4, 16, 0.0f, 176, 65);
            this.head.func_78792_a(this.jaw);
            this.spine = new ModelRenderer((Model)this);
            this.spine.func_217178_a("box", -5.0f, -5.0f, -5.0f, 10, 10, 10, 0.0f, 192, 104);
            this.spine.func_217178_a("scale", -1.0f, -9.0f, -3.0f, 2, 4, 6, 0.0f, 48, 0);
            this.body = new ModelRenderer((Model)this);
            this.body.func_78793_a(0.0f, 4.0f, 8.0f);
            this.body.func_217178_a("body", -12.0f, 0.0f, -16.0f, 24, 24, 64, 0.0f, 0, 0);
            this.body.func_217178_a("scale", -1.0f, -6.0f, -10.0f, 2, 6, 12, 0.0f, 220, 53);
            this.body.func_217178_a("scale", -1.0f, -6.0f, 10.0f, 2, 6, 12, 0.0f, 220, 53);
            this.body.func_217178_a("scale", -1.0f, -6.0f, 30.0f, 2, 6, 12, 0.0f, 220, 53);
            this.leftProximalWing = new ModelRenderer((Model)this);
            this.leftProximalWing.field_78809_i = true;
            this.leftProximalWing.func_78793_a(12.0f, 5.0f, 2.0f);
            this.leftProximalWing.func_217178_a("bone", 0.0f, -4.0f, -4.0f, 56, 8, 8, 0.0f, 112, 88);
            this.leftProximalWing.func_217178_a("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, 0.0f, -56, 88);
            this.leftDistalWing = new ModelRenderer((Model)this);
            this.leftDistalWing.field_78809_i = true;
            this.leftDistalWing.func_78793_a(56.0f, 0.0f, 0.0f);
            this.leftDistalWing.func_217178_a("bone", 0.0f, -2.0f, -2.0f, 56, 4, 4, 0.0f, 112, 136);
            this.leftDistalWing.func_217178_a("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, 0.0f, -56, 144);
            this.leftProximalWing.func_78792_a(this.leftDistalWing);
            this.leftForeThigh = new ModelRenderer((Model)this);
            this.leftForeThigh.func_78793_a(12.0f, 20.0f, 2.0f);
            this.leftForeThigh.func_217178_a("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, 0.0f, 112, 104);
            this.leftForeLeg = new ModelRenderer((Model)this);
            this.leftForeLeg.func_78793_a(0.0f, 20.0f, -1.0f);
            this.leftForeLeg.func_217178_a("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, 0.0f, 226, 138);
            this.leftForeThigh.func_78792_a(this.leftForeLeg);
            this.leftForeFoot = new ModelRenderer((Model)this);
            this.leftForeFoot.func_78793_a(0.0f, 23.0f, 0.0f);
            this.leftForeFoot.func_217178_a("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, 0.0f, 144, 104);
            this.leftForeLeg.func_78792_a(this.leftForeFoot);
            this.leftHindThigh = new ModelRenderer((Model)this);
            this.leftHindThigh.func_78793_a(16.0f, 16.0f, 42.0f);
            this.leftHindThigh.func_217178_a("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, 0.0f, 0, 0);
            this.leftHindLeg = new ModelRenderer((Model)this);
            this.leftHindLeg.func_78793_a(0.0f, 32.0f, -4.0f);
            this.leftHindLeg.func_217178_a("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, 0.0f, 196, 0);
            this.leftHindThigh.func_78792_a(this.leftHindLeg);
            this.leftHindFoot = new ModelRenderer((Model)this);
            this.leftHindFoot.func_78793_a(0.0f, 31.0f, 4.0f);
            this.leftHindFoot.func_217178_a("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 0.0f, 112, 0);
            this.leftHindLeg.func_78792_a(this.leftHindFoot);
            this.rightProximalWing = new ModelRenderer((Model)this);
            this.rightProximalWing.func_78793_a(-12.0f, 5.0f, 2.0f);
            this.rightProximalWing.func_217178_a("bone", -56.0f, -4.0f, -4.0f, 56, 8, 8, 0.0f, 112, 88);
            this.rightProximalWing.func_217178_a("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, 0.0f, -56, 88);
            this.rightDistalWing = new ModelRenderer((Model)this);
            this.rightDistalWing.func_78793_a(-56.0f, 0.0f, 0.0f);
            this.rightDistalWing.func_217178_a("bone", -56.0f, -2.0f, -2.0f, 56, 4, 4, 0.0f, 112, 136);
            this.rightDistalWing.func_217178_a("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, 0.0f, -56, 144);
            this.rightProximalWing.func_78792_a(this.rightDistalWing);
            this.rightForeThigh = new ModelRenderer((Model)this);
            this.rightForeThigh.func_78793_a(-12.0f, 20.0f, 2.0f);
            this.rightForeThigh.func_217178_a("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, 0.0f, 112, 104);
            this.rightForeLeg = new ModelRenderer((Model)this);
            this.rightForeLeg.func_78793_a(0.0f, 20.0f, -1.0f);
            this.rightForeLeg.func_217178_a("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, 0.0f, 226, 138);
            this.rightForeThigh.func_78792_a(this.rightForeLeg);
            this.rightForeFoot = new ModelRenderer((Model)this);
            this.rightForeFoot.func_78793_a(0.0f, 23.0f, 0.0f);
            this.rightForeFoot.func_217178_a("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, 0.0f, 144, 104);
            this.rightForeLeg.func_78792_a(this.rightForeFoot);
            this.rightHindThigh = new ModelRenderer((Model)this);
            this.rightHindThigh.func_78793_a(-16.0f, 16.0f, 42.0f);
            this.rightHindThigh.func_217178_a("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, 0.0f, 0, 0);
            this.rightHindLeg = new ModelRenderer((Model)this);
            this.rightHindLeg.func_78793_a(0.0f, 32.0f, -4.0f);
            this.rightHindLeg.func_217178_a("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, 0.0f, 196, 0);
            this.rightHindThigh.func_78792_a(this.rightHindLeg);
            this.rightHindFoot = new ModelRenderer((Model)this);
            this.rightHindFoot.func_78793_a(0.0f, 31.0f, 4.0f);
            this.rightHindFoot.func_217178_a("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 0.0f, 112, 0);
            this.rightHindLeg.func_78792_a(this.rightHindFoot);
        }

        public void prepareMobModel(DraconicGuardianEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
            this.dragonInstance = entityIn;
            this.partialTicks = partialTick;
        }

        public void setupAnim(DraconicGuardianEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }

        public void func_225598_a_(MatrixStack mStack, IVertexBuilder getter, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            mStack.func_227860_a_();
            float f = MathHelper.func_219799_g((float)this.partialTicks, (float)this.dragonInstance.prevAnimTime, (float)this.dragonInstance.animTime);
            this.jaw.field_78795_f = (float)(Math.sin(f * ((float)Math.PI * 2)) + 1.0) * 0.2f;
            float f1 = (float)(Math.sin(f * ((float)Math.PI * 2) - 1.0f) + 1.0);
            f1 = (f1 * f1 + f1 * 2.0f) * 0.05f;
            mStack.func_227861_a_(0.0, (double)(f1 - 2.0f), -3.0);
            mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f1 * 2.0f));
            float f2 = 0.0f;
            float f3 = 20.0f;
            float f4 = -12.0f;
            float f5 = 1.5f;
            double[] adouble = this.dragonInstance.getMovementOffsets(6, this.partialTicks);
            float f6 = MathHelper.func_226168_l_((double)(this.dragonInstance.getMovementOffsets(5, this.partialTicks)[0] - this.dragonInstance.getMovementOffsets(10, this.partialTicks)[0]));
            float f7 = MathHelper.func_226168_l_((double)(this.dragonInstance.getMovementOffsets(5, this.partialTicks)[0] + (double)(f6 / 2.0f)));
            float f8 = f * ((float)Math.PI * 2);
            for (int i = 0; i < 5; ++i) {
                double[] adouble1 = this.dragonInstance.getMovementOffsets(5 - i, this.partialTicks);
                float f9 = (float)Math.cos((float)i * 0.45f + f8) * 0.15f;
                this.spine.field_78796_g = MathHelper.func_226168_l_((double)(adouble1[0] - adouble[0])) * ((float)Math.PI / 180) * 1.5f;
                this.spine.field_78795_f = f9 + this.dragonInstance.getHeadPartYOffset(i, adouble, adouble1) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.spine.field_78808_h = -MathHelper.func_226168_l_((double)(adouble1[0] - (double)f7)) * ((float)Math.PI / 180) * 1.5f;
                this.spine.field_78797_d = f3;
                this.spine.field_78798_e = f4;
                this.spine.field_78800_c = f2;
                f3 = (float)((double)f3 + Math.sin(this.spine.field_78795_f) * 10.0);
                f4 = (float)((double)f4 - Math.cos(this.spine.field_78796_g) * Math.cos(this.spine.field_78795_f) * 10.0);
                f2 = (float)((double)f2 - Math.sin(this.spine.field_78796_g) * Math.cos(this.spine.field_78795_f) * 10.0);
                this.spine.func_228308_a_(mStack, getter, packedLight, packedOverlay);
            }
            this.head.field_78797_d = f3;
            this.head.field_78798_e = f4;
            this.head.field_78800_c = f2;
            double[] adouble2 = this.dragonInstance.getMovementOffsets(0, this.partialTicks);
            this.head.field_78796_g = MathHelper.func_226168_l_((double)(adouble2[0] - adouble[0])) * ((float)Math.PI / 180);
            this.head.field_78795_f = MathHelper.func_226168_l_((double)this.dragonInstance.getHeadPartYOffset(6, adouble, adouble2)) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            this.head.field_78808_h = -MathHelper.func_226168_l_((double)(adouble2[0] - (double)f7)) * ((float)Math.PI / 180);
            this.head.func_228308_a_(mStack, getter, packedLight, packedOverlay);
            mStack.func_227860_a_();
            mStack.func_227861_a_(0.0, 1.0, 0.0);
            mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-f6 * 1.5f));
            mStack.func_227861_a_(0.0, -1.0, 0.0);
            this.body.field_78808_h = 0.0f;
            this.body.func_228308_a_(mStack, getter, packedLight, packedOverlay);
            float f10 = f * ((float)Math.PI * 2);
            this.leftProximalWing.field_78795_f = 0.125f - (float)Math.cos(f10) * 0.2f;
            this.leftProximalWing.field_78796_g = -0.25f;
            this.leftProximalWing.field_78808_h = -((float)(Math.sin(f10) + 0.125)) * 0.8f;
            this.leftDistalWing.field_78808_h = (float)(Math.sin(f10 + 2.0f) + 0.5) * 0.75f;
            this.rightProximalWing.field_78795_f = this.leftProximalWing.field_78795_f;
            this.rightProximalWing.field_78796_g = -this.leftProximalWing.field_78796_g;
            this.rightProximalWing.field_78808_h = -this.leftProximalWing.field_78808_h;
            this.rightDistalWing.field_78808_h = -this.leftDistalWing.field_78808_h;
            this.renderSide(mStack, getter, packedLight, packedOverlay, f1, this.leftProximalWing, this.leftForeThigh, this.leftForeLeg, this.leftForeFoot, this.leftHindThigh, this.leftHindLeg, this.leftHindFoot);
            this.renderSide(mStack, getter, packedLight, packedOverlay, f1, this.rightProximalWing, this.rightForeThigh, this.rightForeLeg, this.rightForeFoot, this.rightHindThigh, this.rightHindLeg, this.rightHindFoot);
            mStack.func_227865_b_();
            float f11 = -((float)Math.sin(f * ((float)Math.PI * 2))) * 0.0f;
            f8 = f * ((float)Math.PI * 2);
            f3 = 10.0f;
            f4 = 60.0f;
            f2 = 0.0f;
            adouble = this.dragonInstance.getMovementOffsets(11, this.partialTicks);
            for (int j = 0; j < 12; ++j) {
                adouble2 = this.dragonInstance.getMovementOffsets(12 + j, this.partialTicks);
                f11 = (float)((double)f11 + Math.sin((float)j * 0.45f + f8) * (double)0.05f);
                this.spine.field_78796_g = (MathHelper.func_226168_l_((double)(adouble2[0] - adouble[0])) * 1.5f + 180.0f) * ((float)Math.PI / 180);
                this.spine.field_78795_f = f11 + (float)(adouble2[1] - adouble[1]) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.spine.field_78808_h = MathHelper.func_226168_l_((double)(adouble2[0] - (double)f7)) * ((float)Math.PI / 180) * 1.5f;
                this.spine.field_78797_d = f3;
                this.spine.field_78798_e = f4;
                this.spine.field_78800_c = f2;
                f3 = (float)((double)f3 + Math.sin(this.spine.field_78795_f) * 10.0);
                f4 = (float)((double)f4 - Math.cos(this.spine.field_78796_g) * Math.cos(this.spine.field_78795_f) * 10.0);
                f2 = (float)((double)f2 - Math.sin(this.spine.field_78796_g) * Math.cos(this.spine.field_78795_f) * 10.0);
                this.spine.func_228308_a_(mStack, getter, packedLight, packedOverlay);
            }
            mStack.func_227865_b_();
        }

        private void renderSide(MatrixStack p_229081_1_, IVertexBuilder p_229081_2_, int p_229081_3_, int p_229081_4_, float p_229081_5_, ModelRenderer p_229081_6_, ModelRenderer p_229081_7_, ModelRenderer p_229081_8_, ModelRenderer p_229081_9_, ModelRenderer p_229081_10_, ModelRenderer p_229081_11_, ModelRenderer p_229081_12_) {
            p_229081_10_.field_78795_f = 1.0f + p_229081_5_ * 0.1f;
            p_229081_11_.field_78795_f = 0.5f + p_229081_5_ * 0.1f;
            p_229081_12_.field_78795_f = 0.75f + p_229081_5_ * 0.1f;
            p_229081_7_.field_78795_f = 1.3f + p_229081_5_ * 0.1f;
            p_229081_8_.field_78795_f = -0.5f - p_229081_5_ * 0.1f;
            p_229081_9_.field_78795_f = 0.75f + p_229081_5_ * 0.1f;
            p_229081_6_.func_228308_a_(p_229081_1_, p_229081_2_, p_229081_3_, p_229081_4_);
            p_229081_7_.func_228308_a_(p_229081_1_, p_229081_2_, p_229081_3_, p_229081_4_);
            p_229081_10_.func_228308_a_(p_229081_1_, p_229081_2_, p_229081_3_, p_229081_4_);
        }
    }
}

