/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.DETextures;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;

public class CrystalFXWireless
extends CrystalFXBase<TileCrystalWirelessIO> {
    private final BlockPos linkTarget;
    private final AxisAlignedBB targetBB;
    private float powerLevel = 0.0f;
    private List<PTracker> trackers = new ArrayList<PTracker>();
    private static final IParticleRenderType BASIC_HANDLER = new FXHandler("textures/particle/energy_beam_basic.png");
    private static final IParticleRenderType WYVERN_HANDLER = new FXHandler("textures/particle/energy_beam_wyvern.png");
    private static final IParticleRenderType DRACONIC_HANDLER = new FXHandler("textures/particle/energy_beam_draconic.png");

    public CrystalFXWireless(ClientWorld worldIn, TileCrystalWirelessIO tile, BlockPos linkTarget) {
        super(worldIn, tile);
        this.field_70546_d = worldIn.field_73012_v.nextInt(1024);
        this.setPosition(tile.getBeamLinkPos(linkTarget));
        this.linkTarget = linkTarget;
        BlockState state = worldIn.func_180495_p(linkTarget);
        VoxelShape shape = state.func_196954_c((IBlockReader)worldIn, linkTarget);
        if (shape.func_197766_b()) {
            shape = VoxelShapes.func_197868_b();
        }
        this.targetBB = shape.func_197752_a();
        this.targetBB.func_186664_h(0.05);
        this.func_187108_a(new AxisAlignedBB(this.field_187126_f, this.field_187127_g, this.field_187128_h, (double)this.linkTarget.func_177958_n(), (double)this.linkTarget.func_177956_o(), (double)this.linkTarget.func_177952_p()));
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        if (this.ticksTillDeath-- <= 0) {
            this.func_187112_i();
        }
        this.field_82339_as = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70552_h = 1.0f;
        this.powerLevel = (float)MathHelper.approachExp((double)this.powerLevel, (double)this.fxState, (double)0.05);
        Iterator<PTracker> i = this.trackers.iterator();
        while (i.hasNext()) {
            PTracker next = i.next();
            if (next.ticksActive >= next.travelTime) {
                i.remove();
                continue;
            }
            ++next.ticksActive;
        }
        int ps = Minecraft.func_71410_x().field_71474_y.field_74362_aa.func_216832_b();
        if (this.field_70546_d % 2 == 0 && this.powerLevel > this.field_187136_p.nextFloat() && (ps == 0 || ps == 1 && this.field_187136_p.nextInt(3) == 0 || ps == 2 && this.field_187136_p.nextInt(10) == 0)) {
            double travel = 50 + this.field_187136_p.nextInt(50);
            this.trackers.add(new PTracker((int)(travel *= (double)(1.4f - this.powerLevel)), new Vector3(this.targetBB.field_72340_a + this.field_187136_p.nextDouble() * (this.targetBB.field_72336_d - this.targetBB.field_72340_a), this.targetBB.field_72338_b + this.field_187136_p.nextDouble() * (this.targetBB.field_72337_e - this.targetBB.field_72338_b), this.targetBB.field_72339_c + this.field_187136_p.nextDouble() * (this.targetBB.field_72334_f - this.targetBB.field_72339_c))));
        }
        ++this.field_70546_d;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        int texIndex = ClientEventHandler.elapsedTicks % DETextures.ENERGY_PARTICLE.length;
        TextureAtlasSprite sprite = DETextures.ENERGY_PARTICLE[texIndex];
        if (sprite == null) {
            return;
        }
        float minU = sprite.func_94209_e();
        float maxU = sprite.func_94212_f();
        float minV = sprite.func_94206_g();
        float maxV = sprite.func_94210_h();
        float scale = 0.08f;
        boolean output = !((TileCrystalWirelessIO)this.tile).inputMode.get();
        Vector3d view = renderInfo.func_216785_c();
        Vector3 source = new Vector3(this.field_187126_f - view.field_72450_a, this.field_187127_g - view.field_72448_b, this.field_187128_h - view.field_72449_c);
        Vector3 target = Vector3.fromBlockPos((BlockPos)this.linkTarget).subtract(view.field_72450_a, view.field_72448_b, view.field_72449_c);
        for (PTracker tracker : this.trackers) {
            double progress = ((double)tracker.ticksActive + (double)partialTicks) / (double)tracker.travelTime;
            if (!output) {
                progress = 1.0 - progress;
            }
            if (progress >= 1.0 || progress <= 0.0) continue;
            Vector3 pathVec = target.copy().subtract(source);
            pathVec.add(tracker.tOffset);
            pathVec.multiply(progress);
            pathVec.add(source);
            Vector3f[] renderVector = this.getRenderVectors(renderInfo, (float)pathVec.x, (float)pathVec.y, (float)pathVec.z, scale);
            buffer.func_225582_a_((double)renderVector[0].func_195899_a(), (double)renderVector[0].func_195900_b(), (double)renderVector[0].func_195902_c()).func_225583_a_(maxU, maxV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[1].func_195899_a(), (double)renderVector[1].func_195900_b(), (double)renderVector[1].func_195902_c()).func_225583_a_(maxU, minV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[2].func_195899_a(), (double)renderVector[2].func_195900_b(), (double)renderVector[2].func_195902_c()).func_225583_a_(minU, minV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[3].func_195899_a(), (double)renderVector[3].func_195900_b(), (double)renderVector[3].func_195902_c()).func_225583_a_(minU, maxV).func_181675_d();
        }
    }

    public IParticleRenderType func_217558_b() {
        return ((TileCrystalWirelessIO)this.tile).getTier() == 0 ? BASIC_HANDLER : (((TileCrystalWirelessIO)this.tile).getTier() == 1 ? WYVERN_HANDLER : DRACONIC_HANDLER);
    }

    public static class PTracker {
        public int ticksActive = 0;
        public final int travelTime;
        public final Vector3 tOffset;

        public PTracker(int travelTime, Vector3 tOffset) {
            this.travelTime = travelTime;
            this.tOffset = tOffset;
        }
    }

    public static class FXHandler
    implements IParticleRenderType {
        private String texture;
        private float green;

        public FXHandler(String texture) {
            this.texture = texture;
        }

        public void func_217600_a(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.color4f((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            textureManager.func_110577_a(AtlasTexture.field_110575_b);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }
}

