/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.ReactorBeamFX;
import com.brandon3055.draconicevolution.client.sound.ReactorSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReactorEffectHandler {
    private TileReactorCore reactor;
    @OnlyIn(value=Dist.CLIENT)
    private ReactorBeamFX[] effects;
    @OnlyIn(value=Dist.CLIENT)
    private ReactorSound reactorSound;

    public ReactorEffectHandler(TileReactorCore reactor) {
        this.reactor = reactor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateEffects() {
        if (this.effects == null) {
            this.effects = new ReactorBeamFX[6];
        }
        if ((this.reactorSound == null || this.reactorSound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)this.reactorSound)) && ((TileReactorCore.ReactorState)this.reactor.reactorState.get()).isShieldActive() && this.reactor.shieldCharge.get() > 0.0) {
            this.reactorSound = new ReactorSound(this.reactor);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.reactorSound);
        } else if (this.reactorSound != null && (!((TileReactorCore.ReactorState)this.reactor.reactorState.get()).isShieldActive() || this.reactor.shieldCharge.get() <= 0.0)) {
            this.reactorSound.donePlaying = true;
        }
        if (this.reactor.reactorState.get() == TileReactorCore.ReactorState.INVALID || this.reactor.shieldAnimationState <= 0.0f) {
            return;
        }
        for (Direction facing : Direction.values()) {
            ReactorBeamFX beamFX;
            int index = facing.func_176745_a();
            TileReactorComponent component = this.reactor.getComponent(facing);
            if (component == null) {
                if (this.effects[index] == null) continue;
                this.effects[index].func_187112_i();
                this.effects[index] = null;
                continue;
            }
            if (this.effects[index] != null && this.effects[index].func_187113_k()) {
                this.effects[index].updateFX(this.reactor.shieldAnimationState, 1.0f);
                continue;
            }
            this.effects[index] = beamFX = new ReactorBeamFX((ClientWorld)this.reactor.func_145831_w(), Vec3D.getCenter((BlockPos)component.func_174877_v()), (Direction)component.facing.get(), this.reactor, component instanceof TileReactorInjector);
            DEParticles.addParticleDirect(this.reactor.func_145831_w(), beamFX);
        }
    }
}

