/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModuleEntity {
    protected final Module<?> module;
    protected ModuleHost host;
    protected Map<String, ConfigProperty> propertyMap = new HashMap<String, ConfigProperty>();
    protected boolean savePropertiesToItem = false;
    protected int gridX;
    protected int gridY;

    public ModuleEntity(Module<?> module) {
        this.module = module;
    }

    public void setHost(ModuleHost host) {
        this.host = host;
    }

    public void tick(ModuleContext context) {
    }

    public void onInstalled(ModuleContext context) {
    }

    public void onRemoved(ModuleContext context) {
    }

    public ConfigProperty addProperty(ConfigProperty property) {
        this.propertyMap.put(property.getName(), property);
        property.generateUnique();
        return property;
    }

    public Collection<ConfigProperty> getEntityProperties() {
        return this.propertyMap.values();
    }

    public void getAttributeModifiers(EquipmentSlotType slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map) {
    }

    public void clearCaches() {
    }

    public void writeToNBT(CompoundNBT compound) {
        compound.func_74774_a("x", (byte)this.gridX);
        compound.func_74774_a("y", (byte)this.gridY);
        if (!this.propertyMap.isEmpty()) {
            CompoundNBT properties = new CompoundNBT();
            this.propertyMap.forEach((name, property) -> properties.func_218657_a(name, (INBT)property.serializeNBT()));
            compound.func_218657_a("properties", (INBT)properties);
        }
    }

    public void readFromNBT(CompoundNBT compound) {
        this.gridX = compound.func_74771_c("x");
        this.gridY = compound.func_74771_c("y");
        CompoundNBT properties = compound.func_74775_l("properties");
        this.propertyMap.forEach((name, property) -> property.deserializeNBT(properties.func_74775_l(name)));
    }

    public void writeToItemStack(ItemStack stack, ModuleContext context) {
        if (this.savePropertiesToItem && !this.propertyMap.isEmpty()) {
            CompoundNBT properties = stack.func_190925_c("properties");
            this.propertyMap.forEach((name, property) -> properties.func_218657_a(name, (INBT)property.serializeNBT()));
        }
    }

    public void readFromItemStack(ItemStack stack, ModuleContext context) {
        CompoundNBT properties;
        if (this.savePropertiesToItem && (properties = stack.func_179543_a("properties")) != null) {
            this.propertyMap.forEach((name, property) -> property.deserializeNBT(properties.func_74775_l(name)));
        }
    }

    public Module<?> getModule() {
        return this.module;
    }

    public void setPos(int gridX, int gridY) {
        this.setGridX(gridX);
        this.setGridY(gridY);
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
    }

    public void setGridY(int gridY) {
        this.gridY = gridY;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public int getMaxGridX() {
        return this.gridX + this.module.getProperties().getWidth();
    }

    public int getMaxGridY() {
        return this.gridY + this.module.getProperties().getHeight();
    }

    public int getWidth() {
        return this.module.getProperties().getWidth();
    }

    public int getHeight() {
        return this.module.getProperties().getHeight();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSlotOverlay(IRenderTypeBuffer getter, Minecraft mc, int x, int y, int width, int height, double mouseX, double mouseY, boolean mouseOver, float partialTicks) {
    }

    public boolean checkPos(int gridX, int gridY) {
        return this.gridX == gridX && this.gridY == gridY;
    }

    public boolean isPosValid(int gridWidth, int gridHeight) {
        return this.gridX >= 0 && this.gridY >= 0 && this.getMaxGridX() < gridWidth && this.getMaxGridY() < gridHeight;
    }

    public boolean contains(int gridX, int gridY) {
        return gridX >= this.gridX && gridX < this.gridX + this.module.getProperties().getWidth() && gridY >= this.gridY && gridY < this.gridY + this.module.getProperties().getHeight();
    }

    public boolean intersects(ModuleEntity other) {
        int tw = this.getWidth();
        int th = this.getHeight();
        int rw = other.getWidth();
        int rh = other.getHeight();
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.gridX;
        int ty = this.gridY;
        int rx = other.gridX;
        int ry = other.gridY;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    public String toString() {
        return "ModuleEntity{module=" + this.module.getRegistryName() + ", gridX=" + this.gridX + ", gridY=" + this.gridY + '}';
    }

    public void addToolTip(List<ITextComponent> list) {
    }
}

