/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.api.data.IDataManager;

public interface IDataWrapper<T>
extends Supplier<T> {
    public boolean isPresent();

    public ResourceLocation getId();

    default public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.get()) : Stream.of(new Object[0]);
    }

    default public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    public static <T> Codec<IDataWrapper<T>> codec(final IDataManager<T> manager) {
        return new Codec<IDataWrapper<T>>(){

            public <U> DataResult<Pair<IDataWrapper<T>, U>> decode(DynamicOps<U> ops, U input) {
                return ResourceLocation.field_240908_a_.decode(ops, input).map(pair -> pair.mapFirst(manager::getWrapper));
            }

            public <U> DataResult<U> encode(IDataWrapper<T> input, DynamicOps<U> ops, U prefix) {
                return ResourceLocation.field_240908_a_.encode((Object)input.getId(), ops, prefix);
            }
        };
    }
}

