/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.network.message;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.event.DataManagerReloadEvent;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.data.serializer.IJsonDataSerializer;

public class DataManagerMessage<T> {
    private final ResourceLocation id;
    private final IDataManager<T> manager;
    private final IJsonDataSerializer<T> serializer;
    private Map<ResourceLocation, T> data;

    public DataManagerMessage(ResourceLocation id) {
        this.id = id;
        this.manager = DataPackAnvil.WRAPPER.getManager(id);
        this.serializer = DataPackAnvil.WRAPPER.getSerializer(id);
        this.data = this.manager.getData();
    }

    public void decode(PacketBuffer buf) {
        try {
            int mapSize = buf.readInt();
            this.data = new HashMap<ResourceLocation, T>(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                this.data.put(buf.func_192575_l(), this.serializer.read(buf));
            }
        }
        catch (Exception e) {
            DataPackAnvilApi.LOGGER.error(() -> "Error while decoding network packet for datamanger " + this.id, (Throwable)e);
        }
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.data.size());
        this.data.forEach((loc, prop) -> {
            buf.func_192572_a(loc);
            this.serializer.write(prop, buf);
        });
    }

    public void process() {
        try {
            this.manager.setData(this.data);
            MinecraftForge.EVENT_BUS.post(new DataManagerReloadEvent<T>(this.manager));
        }
        catch (Exception e) {
            DataManagerWrapper.logManagerException(this.id, e);
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }
}

