/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.data.manager.AbstractDataManager;

public class MergedDataManager<R, T>
extends AbstractDataManager<T, List<JsonElement>> {
    private final Function<Stream<R>, T> merger;
    private final Function<JsonElement, R> rawParser;

    public MergedDataManager(Class<T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter, Function<Stream<R>, T> merger, Function<JsonElement, R> rawParser) {
        super(contentType, folder, defaultValueFactory, idSetter);
        this.merger = merger;
        this.rawParser = rawParser;
    }

    protected Map<ResourceLocation, List<JsonElement>> prepare(IResourceManager resourceManager, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        int i = this.folder.length() + 1;
        for (ResourceLocation resourcelocation : resourceManager.func_199003_a(this.folder, file -> file.endsWith(".json"))) {
            String path = resourcelocation.func_110623_a();
            ResourceLocation resourceId = new ResourceLocation(resourcelocation.func_110624_b(), path.substring(i, path.length() - 5));
            ArrayList list = Lists.newArrayList();
            try {
                for (IResource resource : resourceManager.func_199004_b(resourcelocation)) {
                    JsonElement element = MergedDataManager.getElement(resourcelocation, resourceId, resource);
                    if (element != null) {
                        JsonObject json;
                        if (element instanceof JsonObject && (json = (JsonObject)element).has("replace") && json.get("replace").getAsBoolean()) {
                            list.clear();
                        }
                        list.add(element);
                        continue;
                    }
                    DataPackAnvilApi.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceId, (Object)resourcelocation);
                }
            }
            catch (IOException e) {
                DataPackAnvilApi.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceId, (Object)resourcelocation, (Object)e);
            }
            map.put(resourceId, list);
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    public static JsonElement getElement(ResourceLocation resourcelocation, ResourceLocation resourceId, IResource resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> objects, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        Function<JsonElement, Object> parser = this.rawParser != null ? this.rawParser : json -> DataPackAnvil.WRAPPER.getSerializer(this.id).read((JsonElement)json);
        objects.forEach((loc, list) -> {
            T value = this.merger.apply(list.stream().map(parser));
            this.idSetter.accept(value, loc);
            map.put(loc, value);
        });
        this.setData(map);
    }
}

