/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.logical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AnyBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.NoneBlockPredicate;

public final class NotBlockPredicate
implements IBlockPosPredicate {
    public static final String NAME = "not";
    @ObjectHolder(value="dpanvil:not")
    public static final BlockPosPredicateType<NotBlockPredicate> TYPE = null;
    public static final Codec<NotBlockPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IBlockPosPredicate.CODEC.fieldOf("value").forGetter(NotBlockPredicate::getPredicate)).apply((Applicative)builder, NotBlockPredicate::new));
    protected final IBlockPosPredicate predicate;

    public NotBlockPredicate(IBlockPosPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(IWorldReader world, BlockPos pos) {
        return !this.predicate.test(world, pos);
    }

    public IBlockPosPredicate getPredicate() {
        return this.predicate;
    }

    public BlockPosPredicateType<NotBlockPredicate> getType() {
        return TYPE;
    }

    @Override
    public IBlockPosPredicate not() {
        return this.predicate;
    }

    @Override
    public IBlockPosPredicate simplify() {
        IBlockPosPredicate simplified = this.predicate.simplify();
        if (simplified instanceof NotBlockPredicate) {
            return ((NotBlockPredicate)simplified).predicate;
        }
        if (simplified instanceof AnyBlockPredicate) {
            return IBlockPosPredicate.none();
        }
        if (simplified instanceof NoneBlockPredicate) {
            return IBlockPosPredicate.any();
        }
        return IBlockPosPredicate.super.simplify();
    }
}

