/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected LootTable.Builder createStandardTable(Block block) {
        String name = block.getRegistryName().func_110623_a();
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216055_a("Frequency", "DimStorage.Frequency", CopyNbt.Action.REPLACE)).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "DimStorage LootTables";
    }
}

