/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.pattern;

import com.mojang.blaze3d.matrix.MatrixStack;
import edivad.dimstorage.client.screen.pattern.BaseScreen;
import edivad.dimstorage.tools.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class PanelScreen<T extends Container>
extends BaseScreen<T> {
    private static final int ANIMATION_SPEED = 10;
    private static final int SETTINGS_WIDTH = 80;
    private static final int SETTINGS_HEIGHT = 180;
    private static final int BUTTON_WIDTH = 20;
    private SettingsState state;
    private int animationState;
    protected boolean drawSettings;
    private boolean settingsButtonOver;
    private boolean allowConfig;
    private List<Widget> component;

    public PanelScreen(T container, PlayerInventory invPlayer, ITextComponent text, ResourceLocation background, boolean drawSettings) {
        super(container, invPlayer, text, background);
        this.drawSettings = drawSettings;
        this.settingsButtonOver = false;
        this.allowConfig = (Boolean)Config.DIMCHEST_ALLOWCONFIG.get();
        this.component = new ArrayList<Widget>();
        if (this.drawSettings) {
            this.animationState = 80;
            this.state = SettingsState.STATE_OPENED;
        } else {
            this.animationState = 0;
            this.state = SettingsState.STATE_CLOSED;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        if (this.state == SettingsState.STATE_OPENING) {
            this.animationState += 10;
            if (this.animationState >= 80) {
                this.animationState = 80;
                this.state = SettingsState.STATE_OPENED;
                this.drawSettings(true);
            }
        } else if (this.state == SettingsState.STATE_CLOSING) {
            this.drawSettings(false);
            this.animationState -= 10;
            if (this.animationState <= 0) {
                this.animationState = 0;
                this.state = SettingsState.STATE_CLOSED;
            }
        }
    }

    private int getButtonX() {
        return this.field_147003_i + this.field_146999_f;
    }

    private int getButtonY() {
        return this.field_147009_r + 16;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int clickedButton) {
        super.func_231044_a_(mouseX, mouseY, clickedButton);
        if (this.allowConfig && mouseX >= (double)this.getButtonX() && mouseX <= (double)(this.getButtonX() + 20) && mouseY >= (double)this.getButtonY() && mouseY <= (double)(this.getButtonY() + 20)) {
            if (this.state == SettingsState.STATE_CLOSED) {
                this.state = SettingsState.STATE_OPENING;
            } else if (this.state == SettingsState.STATE_OPENED) {
                this.state = SettingsState.STATE_CLOSING;
            }
            return true;
        }
        return false;
    }

    public void func_212927_b(double mouseX, double mouseY) {
        super.func_212927_b(mouseX, mouseY);
        this.settingsButtonOver = false;
        if (mouseX >= (double)this.getButtonX() && mouseX <= (double)(this.getButtonX() + 20) && mouseY >= (double)this.getButtonY() && mouseY <= (double)(this.getButtonY() + 20)) {
            this.settingsButtonOver = true;
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack mStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(mStack, partialTicks, mouseX, mouseY);
        int settingsX = this.field_147003_i + (this.field_146999_f - 80);
        if (this.allowConfig) {
            this.func_238474_b_(mStack, settingsX + this.animationState, this.field_147009_r + 36, this.field_146999_f, 36, 80, this.field_147000_g);
        }
        this.func_238474_b_(mStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g + 2);
        this.func_238474_b_(mStack, this.getButtonX(), this.getButtonY(), this.field_146999_f, 16, 20, 20);
        if (this.state == SettingsState.STATE_CLOSED || this.state == SettingsState.STATE_OPENING) {
            if (this.settingsButtonOver) {
                this.func_238474_b_(mStack, this.getButtonX() + 6, this.getButtonY() - 3, this.field_146999_f + 28, 16, 8, 20);
            } else {
                this.func_238474_b_(mStack, this.getButtonX() + 6, this.getButtonY() - 3, this.field_146999_f + 20, 16, 8, 20);
            }
        } else if (this.state == SettingsState.STATE_OPENED || this.state == SettingsState.STATE_CLOSING) {
            if (this.settingsButtonOver) {
                this.func_238474_b_(mStack, this.getButtonX() + 4, this.getButtonY() - 3, this.field_146999_f + 44, 16, 8, 20);
            } else {
                this.func_238474_b_(mStack, this.getButtonX() + 4, this.getButtonY() - 3, this.field_146999_f + 36, 16, 8, 20);
            }
        }
    }

    public List<Rectangle2d> getAreas() {
        ArrayList<Rectangle2d> extraAreas = new ArrayList<Rectangle2d>();
        extraAreas.add(new Rectangle2d(this.field_147003_i + this.field_146999_f, this.getButtonY(), 20, 20));
        extraAreas.add(new Rectangle2d(this.field_147003_i + this.field_146999_f, this.getButtonY() + 20, this.animationState, 180));
        return extraAreas;
    }

    protected void clearComponent() {
        for (Widget widget : this.component) {
            if (!(widget instanceof Button)) continue;
            this.field_230710_m_.clear();
            break;
        }
        this.component.clear();
    }

    protected void addComponent(Widget widget) {
        this.component.add(widget);
        if (widget instanceof Button) {
            this.func_230480_a_((Widget)((Button)widget));
        } else if (widget instanceof TextFieldWidget) {
            this.field_230705_e_.add((TextFieldWidget)widget);
        }
    }

    protected void drawSettings(boolean draw) {
        this.drawSettings = draw;
        for (Widget widget : this.component) {
            widget.field_230694_p_ = draw;
        }
    }

    private static enum SettingsState {
        STATE_CLOSED,
        STATE_OPENING,
        STATE_OPENED,
        STATE_CLOSING;

    }
}

