/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.resources;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.diagonalfences.resources.IResourceGenerator;
import fuzs.diagonalfences.resources.IResourceInfoFactory;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.StringUtils;

public class RuntimeResourcePack
implements IResourcePack,
IResourceInfoFactory {
    private final Map<ResourceLocation, byte[]> resources = Maps.newHashMap();
    private final IResourceGenerator generator;
    private final String name;
    private final StringTextComponent description;
    private boolean locked;

    public RuntimeResourcePack(IResourceGenerator generator, String name, String description) {
        this.generator = generator;
        this.name = name;
        this.description = new StringTextComponent(description);
    }

    public InputStream func_195763_b(String fileName) throws IOException {
        throw new FileNotFoundException();
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        return new ByteArrayInputStream(this.getData(location));
    }

    private byte[] getData(ResourceLocation location) throws IOException {
        byte[] data = this.resources.get(location);
        if (data == null) {
            Map<ResourceLocation, byte[]> unitResources = this.getGeneratorData(location);
            unitResources.forEach(this.resources::put);
            data = unitResources.get(location);
        }
        return data;
    }

    private Map<ResourceLocation, byte[]> getGeneratorData(ResourceLocation location) throws IOException {
        this.locked = true;
        Map<ResourceLocation, byte[]> unitResources = this.generator.getResource(location);
        this.locked = false;
        if (unitResources.isEmpty()) {
            throw new FileNotFoundException();
        }
        return unitResources;
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        if (!this.locked && type == ResourcePackType.CLIENT_RESOURCES) {
            int currentDepth = StringUtils.countMatches((CharSequence)pathIn, (CharSequence)"/");
            return this.getAllResourceLocations().stream().filter(location -> location.func_110624_b().equals(namespaceIn)).filter(location -> location.func_110623_a().startsWith(pathIn)).filter(location -> filterIn.test(location.func_110623_a())).filter(location -> StringUtils.countMatches((CharSequence)location.func_110623_a(), (CharSequence)"/") - currentDepth <= maxDepthIn).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        return !this.locked && type == ResourcePackType.CLIENT_RESOURCES && this.getAllResourceLocations().contains(location);
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        if (!this.locked && type == ResourcePackType.CLIENT_RESOURCES) {
            return this.getAllResourceLocations().stream().map(ResourceLocation::func_110624_b).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    public void close() {
        this.resources.clear();
    }

    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) {
        if (deserializer == PackMetadataSection.field_198964_a) {
            return (T)new PackMetadataSection((ITextComponent)this.description, SharedConstants.func_215069_a().getPackVersion());
        }
        return null;
    }

    public String func_195762_a() {
        return this.name;
    }

    @Override
    public StringTextComponent getDescription() {
        return this.description;
    }

    @Override
    public ResourcePackInfo createResourcePack(String owner, boolean alwaysEnabled, ResourcePackInfo.Priority priority, boolean orderLocked, boolean hidden) {
        return new ResourcePackInfo(owner, alwaysEnabled, () -> this, (ITextComponent)new StringTextComponent(this.func_195762_a()), (ITextComponent)this.getDescription(), PackCompatibility.COMPATIBLE, priority, orderLocked, IPackNameDecorator.field_232626_b_, hidden);
    }

    private Collection<ResourceLocation> getAllResourceLocations() {
        return Stream.concat(this.resources.keySet().stream(), this.generator.getResourceLocations().stream()).collect(Collectors.toSet());
    }
}

