/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.element;

import com.google.common.collect.Lists;
import fuzs.diagonalfences.block.IEightWayBlock;
import fuzs.diagonalfences.client.renderer.model.BlockAssetGenerator;
import fuzs.diagonalfences.element.DiagonalFencesElement;
import fuzs.diagonalfences.resources.IResourceInfoFactory;
import fuzs.diagonalfences.resources.RuntimeResourcePack;
import fuzs.puzzleslib.element.extension.ElementExtension;
import fuzs.puzzleslib.element.extension.ExtensibleElement;
import fuzs.puzzleslib.element.side.IClientElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.state.BooleanProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class DiagonalFencesExtension
extends ElementExtension<DiagonalFencesElement>
implements IClientElement {
    private BlockAssetGenerator generator;

    public DiagonalFencesExtension(DiagonalFencesElement parent) {
        super((ExtensibleElement)parent);
    }

    public void setupClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onParticleFactoryRegister);
        Minecraft mc = Minecraft.func_71410_x();
        ResourcePackList packList = mc.func_195548_H();
        this.generator = new BlockAssetGenerator(mc.func_195551_G());
        RuntimeResourcePack resourcePack = new RuntimeResourcePack(this.generator, "Diagonal Fences", ((DiagonalFencesElement)this.parent).getDescription()[0]);
        this.addPackFinder(packList, resourcePack);
    }

    private void onParticleFactoryRegister(ParticleFactoryRegisterEvent evt) {
        this.addUnits();
    }

    private void addPackFinder(ResourcePackList packList, IResourceInfoFactory resourcePack) {
        packList.addPackFinder((infoConsumer, infoFactory) -> {
            ResourcePackInfo resourcepackinfo = resourcePack.createResourcePack("diagonalfences", true, ResourcePackInfo.Priority.TOP, true, true);
            infoConsumer.accept(resourcepackinfo);
        });
    }

    private void addUnits() {
        Set<Block> allFences = ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof FenceBlock && ((IEightWayBlock)block).hasProperties()).collect(Collectors.toSet());
        ArrayList<BooleanProperty> properties = new ArrayList<BooleanProperty>(IEightWayBlock.DIRECTION_TO_PROPERTY_MAP.values());
        Map<Pair<String, String>, String> propertyConverter = IntStream.range(0, properties.size() / 2).boxed().map(i -> Pair.of(properties.get((int)i), (Object)((BooleanProperty)properties.get(i + 4)).func_177701_a())).collect(Collectors.toMap(entry -> Pair.of((Object)((BooleanProperty)entry.getKey()).func_177701_a(), (Object)((BooleanProperty)entry.getKey()).func_177702_a(Boolean.valueOf(true))), Pair::getValue));
        this.generator.addUnits(allFences, propertyConverter, this::modifyElements);
    }

    private void modifyElements(List<BlockPart> elements) {
        ArrayList rotatedElements = Lists.newArrayList();
        for (BlockPart blockPart : elements) {
            if (blockPart.field_178237_d != null && blockPart.field_178237_d.field_178343_c != 0.0f) continue;
            float center = 8.0f;
            Vector3f positionFrom = this.rescalePosition(blockPart.field_178241_a, 8.0f);
            Vector3f positionTo = this.rescalePosition(blockPart.field_178239_b, 8.0f);
            BlockPartRotation rotation = new BlockPartRotation(new Vector3f(8.0f, 8.0f, 8.0f), Direction.Axis.Y, -45.0f, false);
            blockPart = new BlockPart(positionFrom, positionTo, blockPart.field_178240_c, rotation, blockPart.field_178238_e);
            rotatedElements.add(blockPart);
        }
        elements.clear();
        elements.addAll(rotatedElements);
    }

    private Vector3f rescalePosition(Vector3f position, float center) {
        float angle = 0.70710677f;
        return new Vector3f(position.func_195899_a(), position.func_195900_b(), (position.func_195902_c() - center) / 0.70710677f + center);
    }
}

