/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.block;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import fuzs.diagonalfences.api.IDiagonalBlock;
import fuzs.diagonalfences.mixin.accessor.IStateContainerAccessor;
import fuzs.diagonalfences.state.ExposedStateContainerBuilder;
import fuzs.diagonalfences.util.EightWayDirection;
import fuzs.diagonalfences.util.math.shapes.NoneVoxelShape;
import fuzs.diagonalfences.util.math.shapes.VoxelCollection;
import fuzs.diagonalfences.util.math.shapes.VoxelUtils;
import fuzs.puzzleslib.util.PuzzlesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public interface IEightWayBlock
extends IDiagonalBlock {
    public static final Map<List<Float>, VoxelShape[]> DIMENSIONS_TO_SHAPE_MAP = Maps.newHashMap();
    public static final Map<EightWayDirection, BooleanProperty> DIRECTION_TO_PROPERTY_MAP = (Map)PuzzlesUtil.make((Object)Maps.newEnumMap(EightWayDirection.class), directions -> {
        directions.put(EightWayDirection.NORTH, SixWayBlock.field_196488_a);
        directions.put(EightWayDirection.EAST, SixWayBlock.field_196490_b);
        directions.put(EightWayDirection.SOUTH, SixWayBlock.field_196492_c);
        directions.put(EightWayDirection.WEST, SixWayBlock.field_196495_y);
        directions.put(EightWayDirection.NORTH_EAST, IDiagonalBlock.NORTH_EAST);
        directions.put(EightWayDirection.SOUTH_EAST, IDiagonalBlock.SOUTH_EAST);
        directions.put(EightWayDirection.SOUTH_WEST, IDiagonalBlock.SOUTH_WEST);
        directions.put(EightWayDirection.NORTH_WEST, IDiagonalBlock.NORTH_WEST);
    });

    public boolean canConnect(IBlockReader var1, BlockPos var2, BlockState var3, Direction var4);

    default public BlockState getDefaultStates(BlockState defaultState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)IDiagonalBlock.NORTH_EAST, (Comparable)Boolean.FALSE)).func_206870_a((Property)IDiagonalBlock.SOUTH_EAST, (Comparable)Boolean.FALSE)).func_206870_a((Property)IDiagonalBlock.SOUTH_WEST, (Comparable)Boolean.FALSE)).func_206870_a((Property)IDiagonalBlock.NORTH_WEST, (Comparable)Boolean.FALSE);
    }

    default public MapCodec<BlockState> makeLenientMapCodec(Supplier<BlockState> defaultState, ExposedStateContainerBuilder<Block, BlockState> builder, ExposedStateContainerBuilder<Block, BlockState> additionalBuilder) {
        MapCodec<BlockState> mapcodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(defaultState));
        for (Map.Entry entry : ImmutableSortedMap.copyOf(builder.field_206896_b).entrySet()) {
            if (additionalBuilder.field_206896_b.containsKey(entry.getKey())) continue;
            mapcodec = IStateContainerAccessor.callSetPropertyCodec(mapcodec, defaultState, (String)entry.getKey(), (Property)entry.getValue());
        }
        return mapcodec;
    }

    default public void fillStateContainer2(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{IDiagonalBlock.NORTH_EAST, IDiagonalBlock.SOUTH_EAST, IDiagonalBlock.SOUTH_WEST, IDiagonalBlock.NORTH_WEST});
    }

    default public int makeIndex(BlockState stateIn) {
        int index = 0;
        for (Map.Entry<EightWayDirection, BooleanProperty> entry : DIRECTION_TO_PROPERTY_MAP.entrySet()) {
            if (!((Boolean)stateIn.func_177229_b((Property)entry.getValue())).booleanValue()) continue;
            index |= entry.getKey().getHorizontalIndex();
        }
        return index;
    }

    default public BlockState makeStateForPlacement(BlockState placementState, IBlockReader iblockreader, BlockPos basePos, FluidState fluidState) {
        placementState.func_206870_a((Property)FourWayBlock.field_204514_u, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        placementState = this.withDirections(EightWayDirection.getAllCardinals(), basePos, placementState, (mutablePos, newPlacementState, direction) -> this.canConnect(iblockreader, mutablePos, iblockreader.func_180495_p(mutablePos), direction.convertTo().func_176734_d()));
        placementState = this.withDirections(EightWayDirection.getAllIntercardinals(), basePos, placementState, (mutablePos, newPlacementState, direction) -> {
            if (!this.canConnectDiagonally(iblockreader.func_180495_p(mutablePos))) return false;
            if (!Stream.of(direction.getCardinalNeighbors()).map(DIRECTION_TO_PROPERTY_MAP::get).noneMatch(arg_0 -> ((BlockState)newPlacementState).func_177229_b(arg_0))) return false;
            return true;
        });
        return placementState;
    }

    default public BlockState withDirections(EightWayDirection[] directions, BlockPos basePos, BlockState placementState, DirectionStatePredicate predicate) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (EightWayDirection direction : directions) {
            Vector3i directionVec = direction.directionVec;
            mutablePos.func_239621_a_((Vector3i)basePos, directionVec.func_177958_n(), directionVec.func_177956_o(), directionVec.func_177952_p());
            placementState = (BlockState)placementState.func_206870_a((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction), (Comparable)Boolean.valueOf(predicate.test((BlockPos)mutablePos, placementState, direction)));
        }
        return placementState;
    }

    default public BlockState updatePostPlacement2(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos, BlockState newState) {
        if (facing.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL) {
            BlockPos.Mutable diagonalPos = new BlockPos.Mutable();
            for (EightWayDirection direction : EightWayDirection.convertTo(facing).getIntercardinalNeighbors()) {
                Vector3i directionVec = direction.directionVec;
                diagonalPos.func_239621_a_((Vector3i)currentPos, directionVec.func_177958_n(), directionVec.func_177956_o(), directionVec.func_177952_p());
                BlockState diagonalState = worldIn.func_180495_p((BlockPos)diagonalPos);
                boolean isBlocked = false;
                for (EightWayDirection cardinal : direction.getCardinalNeighbors()) {
                    isBlocked = isBlocked || (Boolean)newState.func_177229_b((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)cardinal)) != false;
                }
                newState = (BlockState)newState.func_206870_a((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction), (Comparable)Boolean.valueOf(!isBlocked && this.canConnectDiagonally(diagonalState)));
            }
            return newState;
        }
        return null;
    }

    default public void updateDiagonalNeighbors2(BlockState state, IWorld world, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.Mutable diagonalPos = new BlockPos.Mutable();
        for (EightWayDirection direction : EightWayDirection.getAllIntercardinals()) {
            Vector3i directionVec = direction.directionVec;
            diagonalPos.func_239621_a_((Vector3i)pos, directionVec.func_177958_n(), directionVec.func_177956_o(), directionVec.func_177952_p());
            BlockState diagonalState = world.func_180495_p((BlockPos)diagonalPos);
            if (!(diagonalState.func_177230_c() instanceof IEightWayBlock) || !((IEightWayBlock)diagonalState.func_177230_c()).canConnectDiagonally()) continue;
            boolean isBlocked = false;
            for (EightWayDirection cardinal : direction.getOpposite().getCardinalNeighbors()) {
                isBlocked = isBlocked || (Boolean)diagonalState.func_177229_b((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)cardinal)) != false;
            }
            BlockState newState = (BlockState)diagonalState.func_206870_a((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction.getOpposite()), (Comparable)Boolean.valueOf(!isBlocked && ((IEightWayBlock)diagonalState.func_177230_c()).canConnectDiagonally(world.func_180495_p(pos))));
            Block.func_241468_a_((BlockState)diagonalState, (BlockState)newState, (IWorld)world, (BlockPos)diagonalPos, (int)flags, (int)recursionLeft);
        }
    }

    default public VoxelShape[] getShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        ArrayList dimensions = Lists.newArrayList((Object[])new Float[]{Float.valueOf(nodeWidth), Float.valueOf(extensionWidth), Float.valueOf(nodeHeight), Float.valueOf(extensionBottom), Float.valueOf(extensionHeight)});
        return DIMENSIONS_TO_SHAPE_MAP.computeIfAbsent(dimensions, dimension -> this.makeDiagonalShapes(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight));
    }

    default public VoxelCollection[] makeDiagonalShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        float nodeStart = 8.0f - nodeWidth;
        float nodeEnd = 8.0f + nodeWidth;
        float extensionStart = 8.0f - extensionWidth;
        float extensionEnd = 8.0f + extensionWidth;
        VoxelShape nodeShape = Block.func_208617_a((double)nodeStart, (double)0.0, (double)nodeStart, (double)nodeEnd, (double)nodeHeight, (double)nodeEnd);
        Vector3d[] sideShape = new Vector3d[]{new Vector3d((double)extensionStart, (double)extensionBottom, 0.0), new Vector3d((double)extensionEnd, (double)extensionHeight, (double)extensionStart)};
        VoxelShape[] verticalShapes = (VoxelShape[])Stream.of(EightWayDirection.getAllCardinals()).map(direction -> direction.transform(sideShape)).map(VoxelUtils::makeCuboidShape).toArray(VoxelShape[]::new);
        VoxelShape[] diagonalShapes = (VoxelShape[])Stream.of(EightWayDirection.getAllIntercardinals()).map(direction -> this.getDiagonalShape(extensionWidth, extensionBottom, extensionHeight, (EightWayDirection)((Object)direction))).toArray(VoxelShape[]::new);
        VoxelShape[] sideShapes = new VoxelShape[]{verticalShapes[2], verticalShapes[3], verticalShapes[0], verticalShapes[1], diagonalShapes[2], diagonalShapes[3], diagonalShapes[0], diagonalShapes[1]};
        return this.constructStateShapes(nodeShape, sideShapes);
    }

    default public VoxelCollection[] constructStateShapes(VoxelShape nodeShape, VoxelShape[] directionalShapes) {
        VoxelCollection[] stateShapes = new VoxelCollection[(int)Math.pow(2.0, directionalShapes.length)];
        for (int i = 0; i < stateShapes.length; ++i) {
            stateShapes[i] = new VoxelCollection(nodeShape);
            for (int j = 0; j < directionalShapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stateShapes[i].addVoxelShape(directionalShapes[j]);
            }
        }
        return stateShapes;
    }

    default public VoxelShape getDiagonalShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction) {
        VoxelShape collisionShape = this.getDiagonalCollisionShape(extensionWidth, extensionBottom, extensionHeight, direction);
        extensionWidth = (float)Math.sqrt(extensionWidth * extensionWidth * 2.0f);
        float diagonalSide = 0.70710677f * extensionWidth;
        Vector3d[] corners = VoxelUtils.createVectorArray(Float.valueOf(-diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(-diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide + 8.0f));
        Vector3d[] edges = VoxelUtils.create12Edges(corners);
        if (direction.directionVec.func_177958_n() != 1) {
            edges = VoxelUtils.flipX(edges);
        }
        if (direction.directionVec.func_177952_p() != 1) {
            edges = VoxelUtils.flipZ(edges);
        }
        return new NoneVoxelShape(collisionShape, VoxelUtils.scaleDown(edges));
    }

    default public VoxelShape getDiagonalCollisionShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction) {
        VoxelShape collisionShape = VoxelShapes.func_197880_a();
        for (int i = 0; i < 8; ++i) {
            Vector3i directionVec = direction.directionVec;
            int posX = directionVec.func_177958_n() > 0 ? i : 16 - i;
            int posZ = directionVec.func_177952_p() > 0 ? i : 16 - i;
            VoxelShape cuboidShape = Block.func_208617_a((double)((float)posX - extensionWidth), (double)extensionBottom, (double)((float)posZ - extensionWidth), (double)((float)posX + extensionWidth), (double)extensionHeight, (double)((float)posZ + extensionWidth));
            collisionShape = VoxelShapes.func_197872_a((VoxelShape)collisionShape, (VoxelShape)cuboidShape);
        }
        return collisionShape;
    }

    @FunctionalInterface
    public static interface DirectionStatePredicate {
        public boolean test(BlockPos var1, BlockState var2, EightWayDirection var3);
    }
}

