/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.util.math.shapes;

import com.google.common.collect.Lists;
import fuzs.diagonalfences.util.math.shapes.ExtensibleVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;

public class NoneVoxelShape
extends ExtensibleVoxelShape {
    private final VoxelShape collisionShape;
    private final VoxelShape outlineShapeBase;
    private final List<Vector3d[]> outlineShapeEdges;

    public NoneVoxelShape(VoxelShape collisionShape, Vector3d ... outlineShapeEdges) {
        this(collisionShape, VoxelShapes.func_197880_a(), outlineShapeEdges);
    }

    public NoneVoxelShape(VoxelShape collisionShape, VoxelShape outlineShapeBase, Vector3d ... outlineShapeEdges) {
        super(collisionShape);
        this.collisionShape = collisionShape;
        this.outlineShapeBase = outlineShapeBase;
        this.outlineShapeEdges = this.createOutlineList(outlineShapeEdges);
    }

    private List<Vector3d[]> createOutlineList(Vector3d[] outlineShapeEdges) {
        assert (outlineShapeEdges.length % 2 == 0) : "Edges must be in groups of two points";
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < outlineShapeEdges.length; i += 2) {
            list.add(new Vector3d[]{outlineShapeEdges[i], outlineShapeEdges[i + 1]});
        }
        return list;
    }

    @Override
    protected DoubleList func_197757_a(Direction.Axis axis) {
        return this.callGetValues(this.collisionShape, axis);
    }

    public void func_197754_a(VoxelShapes.ILineConsumer boxConsumer) {
        this.outlineShapeBase.func_197754_a(boxConsumer);
        for (Vector3d[] edge : this.outlineShapeEdges) {
            boxConsumer.consume(edge[0].field_72450_a, edge[0].field_72448_b, edge[0].field_72449_c, edge[1].field_72450_a, edge[1].field_72448_b, edge[1].field_72449_c);
        }
    }
}

