/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.util.math.shapes;

import fuzs.diagonalfences.DiagonalFences;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.SplitVoxelShape;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class ExtensibleVoxelShape
extends SplitVoxelShape {
    private final Field partField = ObfuscationReflectionHelper.findField(VoxelShape.class, (String)"field_197768_g");
    private final Method getValuesMethod = ObfuscationReflectionHelper.findMethod(VoxelShape.class, (String)"func_197757_a", (Class[])new Class[]{Direction.Axis.class});

    public ExtensibleVoxelShape(VoxelShape voxelProvider) {
        super(voxelProvider, Direction.Axis.X, 0);
        this.setVoxelPart((VoxelShape)this, this.getVoxelPart(voxelProvider));
    }

    protected abstract DoubleList func_197757_a(Direction.Axis var1);

    protected final void setVoxelPart(VoxelShape voxelShape, VoxelShapePart part) {
        try {
            this.partField.set(voxelShape, part);
        }
        catch (IllegalAccessException ignored) {
            DiagonalFences.LOGGER.warn("Unable to set part field in {}", (Object)voxelShape.getClass().toString());
        }
    }

    protected final VoxelShapePart getVoxelPart(VoxelShape voxelShape) {
        try {
            return (VoxelShapePart)this.partField.get(voxelShape);
        }
        catch (IllegalAccessException ignored) {
            DiagonalFences.LOGGER.warn("Unable to get part field in {}", (Object)voxelShape.getClass().toString());
            return null;
        }
    }

    protected final DoubleList callGetValues(VoxelShape voxelShape, Direction.Axis axis) {
        try {
            return (DoubleList)this.getValuesMethod.invoke((Object)voxelShape, axis);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            DiagonalFences.LOGGER.warn("Unable to call 'getValues' method in {}", (Object)voxelShape.getClass().toString());
            return null;
        }
    }
}

