/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.util;

import fuzs.diagonalfences.util.math.shapes.VoxelUtils;
import java.util.stream.Stream;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public final class EightWayDirection
extends Enum<EightWayDirection> {
    public static final /* enum */ EightWayDirection SOUTH = new EightWayDirection(0, 0, 1);
    public static final /* enum */ EightWayDirection WEST = new EightWayDirection(1, -1, 0);
    public static final /* enum */ EightWayDirection NORTH = new EightWayDirection(2, 0, -1);
    public static final /* enum */ EightWayDirection EAST = new EightWayDirection(3, 1, 0);
    public static final /* enum */ EightWayDirection SOUTH_WEST = new EightWayDirection(0, -1, 1);
    public static final /* enum */ EightWayDirection NORTH_WEST = new EightWayDirection(1, -1, -1);
    public static final /* enum */ EightWayDirection NORTH_EAST = new EightWayDirection(2, 1, -1);
    public static final /* enum */ EightWayDirection SOUTH_EAST = new EightWayDirection(3, 1, 1);
    public final int index;
    public final Vector3i directionVec;
    private static final /* synthetic */ EightWayDirection[] $VALUES;

    public static EightWayDirection[] values() {
        return (EightWayDirection[])$VALUES.clone();
    }

    public static EightWayDirection valueOf(String name) {
        return Enum.valueOf(EightWayDirection.class, name);
    }

    private EightWayDirection(int index, int directionX, int directionZ) {
        this.index = index;
        this.directionVec = new Vector3i(directionX, 0, directionZ);
    }

    public boolean isCardinal() {
        return !this.isIntercardinal();
    }

    public boolean isIntercardinal() {
        return Math.abs(this.directionVec.func_177958_n()) + Math.abs(this.directionVec.func_177952_p()) == 2;
    }

    public int getHorizontalIndex() {
        return 1 << (this.isIntercardinal() ? 4 + this.index : this.index);
    }

    public Vector3d[] transform(Vector3d[] vectors) {
        if (this.directionVec.func_177958_n() != 0) {
            vectors = VoxelUtils.ortho(vectors);
        }
        if (this.directionVec.func_177958_n() == -1 || this.directionVec.func_177952_p() == -1) {
            vectors = VoxelUtils.mirror(vectors);
        }
        return vectors;
    }

    public EightWayDirection getOpposite() {
        return EightWayDirection.byIndex(this.index + 2, this.isIntercardinal());
    }

    public EightWayDirection[] getCardinalNeighbors() {
        assert (this.isIntercardinal()) : "Direction already is cardinal";
        return new EightWayDirection[]{EightWayDirection.byIndex(this.index, false), EightWayDirection.byIndex(this.index + 1, false)};
    }

    public EightWayDirection[] getIntercardinalNeighbors() {
        assert (this.isCardinal()) : "Direction already is intercardinal";
        return new EightWayDirection[]{EightWayDirection.byIndex(this.index + 3, true), EightWayDirection.byIndex(this.index, true)};
    }

    public Direction convertTo() {
        assert (this.isCardinal()) : "Cannot convert intercardinal direction to vanilla direction";
        return Direction.func_176731_b((int)this.index);
    }

    public static EightWayDirection convertTo(Direction direction) {
        return EightWayDirection.getAllCardinals()[direction.func_176736_b()];
    }

    public static EightWayDirection[] getAllCardinals() {
        return (EightWayDirection[])Stream.of(EightWayDirection.values()).filter(EightWayDirection::isCardinal).toArray(EightWayDirection[]::new);
    }

    public static EightWayDirection[] getAllIntercardinals() {
        return (EightWayDirection[])Stream.of(EightWayDirection.values()).filter(EightWayDirection::isIntercardinal).toArray(EightWayDirection[]::new);
    }

    public static EightWayDirection byIndex(int index, boolean intercardinal) {
        return intercardinal ? EightWayDirection.getAllIntercardinals()[index] : EightWayDirection.getAllCardinals()[index %= 4];
    }

    public static EightWayDirection byHorizontalIndex(int index) {
        return EightWayDirection.byIndex(index, index >= 4);
    }

    static {
        $VALUES = new EightWayDirection[]{SOUTH, WEST, NORTH, EAST, SOUTH_WEST, NORTH_WEST, NORTH_EAST, SOUTH_EAST};
    }
}

