/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.json.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fuzs.diagonalfences.client.util.IAdapterUtils;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.model.BlockFaceUV;

public class BlockFaceUVAdapter
extends BlockFaceUV.Deserializer
implements JsonSerializer<BlockFaceUV>,
IAdapterUtils {
    public JsonElement serialize(BlockFaceUV src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        this.addUVs(jsonObject, src.field_178351_a);
        if (src.field_178350_b != 0) {
            this.addRotation(jsonObject, src.field_178350_b);
        }
        return jsonObject;
    }

    private void addUVs(JsonObject jsonObject, float[] uvs) {
        if (uvs.length != 4) {
            throw new JsonParseException("Expected 4 uv values, found: " + uvs.length);
        }
        jsonObject.add("uv", (JsonElement)this.serializeFloatArray(uvs));
    }

    private void addRotation(JsonObject jsonObject, int rotation) {
        if (rotation < 0 || rotation % 90 != 0 || rotation / 90 > 3) {
            throw new JsonParseException("Invalid rotation " + rotation + " found, only 0/90/180/270 allowed");
        }
        jsonObject.addProperty("rotation", (Number)rotation);
    }
}

