/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import link.infra.demagnetize.ConfigHandler;
import link.infra.demagnetize.blocks.DemagnetizerContainer;
import link.infra.demagnetize.blocks.DemagnetizerEventHandler;
import link.infra.demagnetize.blocks.ModBlocks;
import link.infra.demagnetize.network.PacketDemagnetizerSettings;
import link.infra.demagnetize.network.PacketHandler;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class DemagnetizerTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private AxisAlignedBB scanArea;
    private int range;
    private RedstoneStatus redstoneSetting = RedstoneStatus.REDSTONE_DISABLED;
    private boolean filtersWhitelist = false;
    private boolean isPowered = false;
    final boolean advanced;
    private final int tickTime = 4;
    private int currTick = 4;
    final ItemStackHandler itemStackHandler;

    public DemagnetizerTileEntity(boolean advanced) {
        super(advanced ? ModBlocks.DEMAGNETIZER_ADVANCED_TILE_ENTITY : ModBlocks.DEMAGNETIZER_TILE_ENTITY);
        this.advanced = advanced;
        this.range = this.getMaxRange();
        this.updateBoundingBox();
        DemagnetizerEventHandler.addTileEntity(this);
        this.itemStackHandler = new ItemStackHandler(this.getFilterSize()){

            protected void onContentsChanged(int slot) {
                DemagnetizerTileEntity.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                return ItemStack.field_190927_a;
            }
        };
    }

    int getMaxRange() {
        return this.advanced ? ((Integer)ConfigHandler.DEMAGNETIZER_ADVANCED_RANGE.get()).intValue() : ((Integer)ConfigHandler.DEMAGNETIZER_RANGE.get()).intValue();
    }

    private void updateBoundingBox() {
        int negRange = this.range * -1;
        this.scanArea = new AxisAlignedBB(this.func_174877_v().func_177982_a(negRange, negRange, negRange), this.func_174877_v().func_177982_a(this.range, this.range, this.range));
    }

    public void func_174878_a(@Nonnull BlockPos pos) {
        super.func_174878_a(pos);
        this.updateBoundingBox();
    }

    public void func_226984_a_(@Nonnull World world, @Nonnull BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.updateBoundingBox();
    }

    public void func_230337_a_(@Nonnull BlockState state, CompoundNBT compound) {
        int pendingRange;
        if (compound.func_74764_b("redstone")) {
            try {
                this.redstoneSetting = RedstoneStatus.valueOf(compound.func_74779_i("redstone"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (compound.func_74764_b("range") && (pendingRange = compound.func_74762_e("range")) <= this.getMaxRange() && pendingRange > 0) {
            this.range = pendingRange;
        }
        if (this.getFilterSize() == 0) {
            this.filtersWhitelist = false;
        } else {
            if (compound.func_74764_b("whitelist")) {
                this.filtersWhitelist = compound.func_74767_n("whitelist");
            }
            if (compound.func_74764_b("items")) {
                CompoundNBT itemsTag = compound.func_74775_l("items");
                itemsTag.func_74768_a("Size", this.getFilterSize());
                this.itemStackHandler.deserializeNBT(itemsTag);
            }
        }
        if (compound.func_74764_b("redstonePowered")) {
            this.isPowered = compound.func_74767_n("redstonePowered");
        }
        super.func_230337_a_(state, compound);
        this.updateBoundingBox();
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("items", (INBT)this.itemStackHandler.serializeNBT());
        compound.func_74778_a("redstone", this.redstoneSetting.name());
        compound.func_74768_a("range", this.range);
        compound.func_74757_a("whitelist", this.filtersWhitelist);
        compound.func_74757_a("redstonePowered", this.isPowered);
        return super.func_189515_b(compound);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public void func_73660_a() {
        if (this.func_145837_r() || !this.func_145830_o()) {
            DemagnetizerEventHandler.removeTileEntity(this);
            return;
        }
        if (this.redstoneUnpowered()) {
            this.currTick = 4;
            return;
        }
        if (this.currTick == 4) {
            assert (this.field_145850_b != null);
            List list = this.field_145850_b.func_217357_a(ItemEntity.class, this.scanArea);
            for (ItemEntity item : list) {
                if (!this.checkItemFilter(item)) continue;
                this.demagnetizeItem(item);
            }
            this.currTick = 0;
        } else {
            ++this.currTick;
        }
    }

    boolean checkItem(ItemEntity item) {
        if (this.redstoneUnpowered()) {
            return false;
        }
        if (this.scanArea != null && item != null) {
            AxisAlignedBB entityBox = item.func_174813_aQ();
            return this.scanArea.func_72326_a(entityBox) && this.checkItemFilter(item);
        }
        return false;
    }

    boolean checkItemClientPreMetadata(ItemEntity item) {
        if (this.redstoneUnpowered()) {
            return false;
        }
        if (this.scanArea != null && item != null) {
            return this.scanArea.func_72326_a(item.func_174813_aQ());
        }
        return false;
    }

    void demagnetizeItem(ItemEntity item) {
        CompoundNBT data = item.getPersistentData();
        if (!data.func_74767_n("PreventRemoteMovement")) {
            data.func_74757_a("PreventRemoteMovement", true);
        }
        if (!data.func_74767_n("AllowMachineRemoteMovement")) {
            data.func_74757_a("AllowMachineRemoteMovement", true);
        }
    }

    public void updateBlock() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    void updateRedstone(boolean redstoneStatus) {
        this.isPowered = redstoneStatus;
        this.updateBlock();
    }

    private boolean redstoneUnpowered() {
        switch (this.redstoneSetting) {
            case POWERED: {
                return !this.isPowered;
            }
            case UNPOWERED: {
                return this.isPowered;
            }
        }
        return false;
    }

    int getFilterSize() {
        return this.advanced ? ((Integer)ConfigHandler.DEMAGNETIZER_ADVANCED_FILTER_SLOTS.get()).intValue() : ((Integer)ConfigHandler.DEMAGNETIZER_FILTER_SLOTS.get()).intValue();
    }

    private boolean checkItemFilter(ItemEntity item) {
        if (item.func_92059_d().func_190926_b()) {
            if (!this.filtersWhitelist) {
                for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.filtersWhitelist) {
            return this.checkItemFilterMatches(item);
        }
        return !this.checkItemFilterMatches(item);
    }

    private boolean checkItemFilterMatches(ItemEntity item) {
        ItemStack matchingItem = item.func_92059_d();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (i >= this.getFilterSize()) {
                return false;
            }
            ItemStack filterStack = this.itemStackHandler.getStackInSlot(i);
            if (filterStack.func_190926_b() || !filterStack.func_185136_b(matchingItem)) continue;
            return true;
        }
        return false;
    }

    int getRange() {
        if (this.range > this.getMaxRange()) {
            this.range = this.getMaxRange();
        }
        if (this.range < 1) {
            this.range = 0;
        }
        return this.range;
    }

    RedstoneStatus getRedstoneSetting() {
        return this.redstoneSetting;
    }

    boolean isWhitelist() {
        return this.filtersWhitelist;
    }

    public void setRange(int range) {
        this.range = range;
        this.updateBoundingBox();
    }

    public void setRedstoneSetting(RedstoneStatus setting) {
        this.redstoneSetting = setting;
    }

    public void setWhitelist(boolean whitelist) {
        this.filtersWhitelist = this.getFilterSize() > 0 ? whitelist : false;
    }

    void sendSettingsToServer() {
        PacketHandler.INSTANCE.sendToServer((Object)new PacketDemagnetizerSettings(this.range, this.redstoneSetting, this.filtersWhitelist, this.func_174877_v()));
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        if (this.advanced) {
            return new TranslationTextComponent(ModBlocks.DEMAGNETIZER_ADVANCED.func_149739_a());
        }
        return new TranslationTextComponent(ModBlocks.DEMAGNETIZER.func_149739_a());
    }

    @Nullable
    public Container createMenu(int i, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerEntity) {
        assert (this.field_145850_b != null);
        return new DemagnetizerContainer(i, this.field_145850_b, this.field_174879_c, playerInventory);
    }

    public static enum RedstoneStatus {
        REDSTONE_DISABLED(0),
        POWERED(1),
        UNPOWERED(2);

        private final int num;

        private RedstoneStatus(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }

        public static RedstoneStatus parse(int num) {
            for (RedstoneStatus s : RedstoneStatus.values()) {
                if (s.getNum() != num) continue;
                return s;
            }
            return null;
        }
    }
}

