/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.blocks;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import link.infra.demagnetize.blocks.DemagnetizerTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DemagnetizerEventHandler {
    private static final List<WeakReference<DemagnetizerTileEntity>> teList = new ArrayList<WeakReference<DemagnetizerTileEntity>>();
    private static final Deque<WeakReference<ItemEntity>> itemsPendingMetadataPacket = new ArrayDeque<WeakReference<ItemEntity>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addTileEntity(DemagnetizerTileEntity te) {
        List<WeakReference<DemagnetizerTileEntity>> list = teList;
        synchronized (list) {
            teList.add(new WeakReference<DemagnetizerTileEntity>(te));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTileEntity(DemagnetizerTileEntity te) {
        List<WeakReference<DemagnetizerTileEntity>> list = teList;
        synchronized (list) {
            Iterator<WeakReference<DemagnetizerTileEntity>> iterator = teList.iterator();
            while (iterator.hasNext()) {
                WeakReference<DemagnetizerTileEntity> weakRef = iterator.next();
                if (weakRef == null || weakRef.get() == null) {
                    iterator.remove();
                    continue;
                }
                DemagnetizerTileEntity ent = (DemagnetizerTileEntity)((Object)weakRef.get());
                if (ent != null && !ent.func_145837_r() && !((Object)((Object)ent)).equals((Object)te)) continue;
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public static void itemSpawned(EntityJoinWorldEvent event) {
        Entity ent = event.getEntity();
        if (ent instanceof ItemEntity) {
            DemagnetizerEventHandler.handleItemSpawn((ItemEntity)ent, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleItemSpawn(ItemEntity item, boolean fromClientTick) {
        List<WeakReference<DemagnetizerTileEntity>> list = teList;
        synchronized (list) {
            Iterator<WeakReference<DemagnetizerTileEntity>> iterator = teList.iterator();
            while (iterator.hasNext()) {
                WeakReference<DemagnetizerTileEntity> weakRef = iterator.next();
                if (weakRef == null || weakRef.get() == null) {
                    iterator.remove();
                    continue;
                }
                DemagnetizerTileEntity te = (DemagnetizerTileEntity)((Object)weakRef.get());
                if (te == null || te.func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                if (!Objects.equals(te.func_145831_w(), item.func_130014_f_())) continue;
                if (item.func_92059_d().func_190926_b() && te.func_145831_w().func_201670_d() && !fromClientTick) {
                    if (!te.checkItemClientPreMetadata(item)) continue;
                    itemsPendingMetadataPacket.push(new WeakReference<ItemEntity>(item));
                    return;
                }
                if (!te.checkItem(item)) continue;
                te.demagnetizeItem(item);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT) {
            while (!itemsPendingMetadataPacket.isEmpty()) {
                ItemEntity item = (ItemEntity)itemsPendingMetadataPacket.pop().get();
                if (item == null) continue;
                DemagnetizerEventHandler.handleItemSpawn(item, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBoundingBoxes() {
        List<WeakReference<DemagnetizerTileEntity>> list = teList;
        synchronized (list) {
            Iterator<WeakReference<DemagnetizerTileEntity>> iterator = teList.iterator();
            while (iterator.hasNext()) {
                WeakReference<DemagnetizerTileEntity> weakRef = iterator.next();
                if (weakRef == null || weakRef.get() == null) {
                    iterator.remove();
                    continue;
                }
                DemagnetizerTileEntity ent = (DemagnetizerTileEntity)((Object)weakRef.get());
                if (ent == null || ent.func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                ent.setRange(ent.getRange());
            }
        }
    }
}

