/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize;

import link.infra.demagnetize.ConfigHandler;
import link.infra.demagnetize.blocks.Demagnetizer;
import link.infra.demagnetize.blocks.DemagnetizerContainer;
import link.infra.demagnetize.blocks.DemagnetizerGui;
import link.infra.demagnetize.blocks.DemagnetizerTileEntity;
import link.infra.demagnetize.blocks.ModBlocks;
import link.infra.demagnetize.items.BlockItemClearConfiguration;
import link.infra.demagnetize.items.ModItems;
import link.infra.demagnetize.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="demagnetize")
public class Demagnetize {
    public static final String MODID = "demagnetize";

    public Demagnetize() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupCommon);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHandler.COMMON_CONFIG);
        ConfigHandler.loadConfig(ConfigHandler.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("demagnetize-common.toml"));
    }

    private void setupClient(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ModBlocks.DEMAGNETIZER_CONTAINER, DemagnetizerGui::new);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        PacketHandler.registerMessages();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            event.getRegistry().register((IForgeRegistryEntry)new Demagnetizer(false));
            event.getRegistry().register((IForgeRegistryEntry)new Demagnetizer(true));
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            Item.Properties properties = new Item.Properties().func_200916_a(ModItems.tab);
            event.getRegistry().register(new BlockItemClearConfiguration(ModBlocks.DEMAGNETIZER, properties).setRegistryName("demagnetizer"));
            event.getRegistry().register(new BlockItemClearConfiguration(ModBlocks.DEMAGNETIZER_ADVANCED, properties).setRegistryName("demagnetizer_advanced"));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new DemagnetizerTileEntity(false), (Block[])new Block[]{ModBlocks.DEMAGNETIZER}).func_206865_a(null).setRegistryName("demagnetizer"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new DemagnetizerTileEntity(true), (Block[])new Block[]{ModBlocks.DEMAGNETIZER_ADVANCED}).func_206865_a(null).setRegistryName("demagnetizer_advanced"));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new DemagnetizerContainer(windowId, inv.field_70458_d.field_70170_p, pos, inv);
            }).setRegistryName("demagnetizer"));
        }
    }
}

