/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.utils;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.container.AbstractDankContainer;
import tfar.dankstorage.inventory.DankHandler;
import tfar.dankstorage.inventory.PortableDankHandler;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.network.CMessageTogglePickup;
import tfar.dankstorage.network.CMessageToggleUseType;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.Mode;
import tfar.dankstorage.utils.SortingData;

public class Utils {
    public static final String INV = "inv";
    public static final Set<ResourceLocation> taglist = new HashSet<ResourceLocation>();
    public static boolean DEV;

    public static Mode getMode(ItemStack bag) {
        return CMessageTogglePickup.modes[bag.func_196082_o().func_74762_e("mode")];
    }

    public static boolean isConstruction(ItemStack bag) {
        return bag.func_77973_b() instanceof DankItem && bag.func_77942_o() && bag.func_77978_p().func_74764_b("construction") && bag.func_77978_p().func_74762_e("construction") == CMessageToggleUseType.UseType.construction.ordinal();
    }

    public static void cycleMode(ItemStack bag, PlayerEntity player) {
        int ordinal = bag.func_196082_o().func_74762_e("mode");
        if (++ordinal > CMessageTogglePickup.modes.length - 1) {
            ordinal = 0;
        }
        bag.func_196082_o().func_74768_a("mode", ordinal);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("dankstorage.mode." + CMessageTogglePickup.modes[ordinal].name()), true);
    }

    public static CMessageToggleUseType.UseType getUseType(ItemStack bag) {
        return CMessageToggleUseType.useTypes[bag.func_196082_o().func_74762_e("construction")];
    }

    public static void cyclePlacement(ItemStack bag, PlayerEntity player) {
        int ordinal = bag.func_196082_o().func_74762_e("construction");
        if (++ordinal >= CMessageToggleUseType.useTypes.length) {
            ordinal = 0;
        }
        bag.func_196082_o().func_74768_a("construction", ordinal);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("dankstorage.usetype." + CMessageToggleUseType.useTypes[ordinal].name()), true);
    }

    public static int getSelectedSlot(ItemStack bag) {
        return bag.func_196082_o().func_74762_e("selectedSlot");
    }

    public static void setSelectedSlot(ItemStack bag, int slot) {
        bag.func_196082_o().func_74768_a("selectedSlot", slot);
    }

    public static int getSlotCount(ItemStack bag) {
        return Utils.getStats((ItemStack)bag).slots;
    }

    public static DankStats getStats(ItemStack bag) {
        return ((DankItem)bag.func_77973_b()).tier;
    }

    public static int getSlotCount(int tier) {
        if (tier > 0 && tier < 7) {
            return 9 * tier;
        }
        if (tier == 7) {
            return 81;
        }
        throw new IndexOutOfBoundsException("tier " + tier + " is out of bounds!");
    }

    public static void sort(PlayerEntity player) {
        if (player == null) {
            return;
        }
        Container openContainer = player.field_71070_bA;
        if (openContainer instanceof AbstractDankContainer) {
            ArrayList<SortingData> itemlist = new ArrayList<SortingData>();
            DankHandler handler = ((AbstractDankContainer)openContainer).dankHandler;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                boolean exists = SortingData.exists(itemlist, stack.func_77946_l());
                if (exists) {
                    int rem = SortingData.addToList(itemlist, stack.func_77946_l());
                    if (rem <= 0) continue;
                    ItemStack bigstack = stack.func_77946_l();
                    bigstack.func_190920_e(Integer.MAX_VALUE);
                    ItemStack smallstack = stack.func_77946_l();
                    smallstack.func_190920_e(rem);
                    itemlist.add(new SortingData(bigstack));
                    itemlist.add(new SortingData(smallstack));
                    continue;
                }
                itemlist.add(new SortingData(stack.func_77946_l()));
            }
            handler.getContents().clear();
            Collections.sort(itemlist);
            for (SortingData data : itemlist) {
                ItemStack stack = data.stack.func_77946_l();
                ItemStack rem = stack.func_77946_l();
                for (int i = 0; i < handler.getSlots() && !(rem = handler.insertItem(i, rem, false)).func_190926_b(); ++i) {
                }
            }
        }
    }

    public static int getStackLimit(ItemStack bag) {
        return Utils.getStats((ItemStack)bag).stacklimit;
    }

    public static int getTier(ItemStack bag) {
        return Utils.getStats(bag).ordinal();
    }

    public static void changeSlot(ItemStack bag, boolean right) {
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            DankHandler dankHandler = (DankHandler)((Object)handler);
            if (dankHandler.noValidSlots()) {
                return;
            }
            int selectedSlot = Utils.getSelectedSlot(bag);
            int size = handler.getSlots();
            do {
                if (right) {
                    if (++selectedSlot < size) continue;
                    selectedSlot = 0;
                    continue;
                }
                if (--selectedSlot >= 0) continue;
                selectedSlot = size - 1;
            } while (handler.getStackInSlot(selectedSlot).func_190926_b() || handler.getStackInSlot(selectedSlot).func_77973_b().func_206844_a(ModTags.BLACKLISTED_USAGE));
            Utils.setSelectedSlot(bag, selectedSlot);
        });
    }

    public static boolean oredict(ItemStack bag) {
        return bag.func_77973_b() instanceof DankItem && bag.func_77942_o() && bag.func_77978_p().func_74767_n("tag");
    }

    public static PortableDankHandler getHandler(ItemStack bag) {
        return Utils.getHandler(bag, null);
    }

    public static PortableDankHandler getHandler(ItemStack bag, Hand hand) {
        return new PortableDankHandler(bag, hand);
    }

    public static int getNbtSize(ItemStack stack) {
        return Utils.getNbtSize(stack.func_77978_p());
    }

    public static DankItem getItemFromTier(int tier) {
        return (DankItem)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dankstorage", "dank_" + tier));
    }

    public static int getNbtSize(@Nullable CompoundNBT nbt) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150786_a(nbt);
        buffer.release();
        return buffer.writerIndex();
    }

    public static ItemStack getItemStackInSelectedSlot(ItemStack bag) {
        return bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
            ItemStack stack = iItemHandler.getStackInSlot(Utils.getSelectedSlot(bag));
            return stack.func_77973_b().func_206844_a(ModTags.BLACKLISTED_USAGE) ? ItemStack.field_190927_a : stack;
        }).orElse(ItemStack.field_190927_a);
    }

    public static boolean areItemStacksConvertible(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77942_o() || stack2.func_77942_o()) {
            return false;
        }
        Set taglistofstack1 = stack1.func_77973_b().getTags();
        Set taglistofstack2 = stack2.func_77973_b().getTags();
        HashSet commontags = new HashSet(taglistofstack1);
        commontags.retainAll(taglistofstack2);
        commontags.retainAll(taglist);
        return !commontags.isEmpty();
    }

    @Nullable
    public static CompoundNBT copyNBTSkipKey(@Nonnull CompoundNBT nbt, @Nonnull String keyToSkip) {
        CompoundNBT copiedNBT = new CompoundNBT();
        for (String key : nbt.func_150296_c()) {
            INBT innerNBT;
            if (keyToSkip.equals(key) || (innerNBT = nbt.func_74781_a(key)) == null) continue;
            copiedNBT.func_218657_a(key, innerNBT.func_74737_b());
        }
        if (copiedNBT.isEmpty()) {
            return null;
        }
        return copiedNBT;
    }

    static {
        try {
            Items.class.getField("field_190931_a");
            DEV = false;
        }
        catch (NoSuchFieldException e) {
            DEV = true;
        }
    }
}

